/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.widgets.table;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.view.widgets.table.TableShower;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class ExtendedTable {
    private Table _table;
    private TableShower _tableShower;
    private List<Object> _items;
    private String[] _header;

    public ExtendedTable(Composite pParent, int pStyle, TableShower pTableShower) {
        this._table = new Table(pParent, pStyle);
        this._tableShower = pTableShower;
    }

    public void setHeader(String[] pHeader) {
        if (!this.headerEquals(pHeader)) {
            this._header = pHeader;
            Object[] objectArray = this._table.getColumns();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = objectArray[n2];
                column.dispose();
                ++n2;
            }
            objectArray = pHeader;
            n = pHeader.length;
            n2 = 0;
            while (n2 < n) {
                TableColumn header = objectArray[n2];
                TableColumn column = new TableColumn(this._table, 0);
                column.setText((String)header);
                column.pack();
                ++n2;
            }
        }
    }

    private boolean headerEquals(String[] pHeader) {
        if (pHeader == this._header) {
            return true;
        }
        if (pHeader == null) {
            return false;
        }
        if (this._header == null) {
            return false;
        }
        if (this._header.length != pHeader.length) {
            return false;
        }
        boolean returnValue = true;
        int i = 0;
        while (i < pHeader.length) {
            if (!this._header[i].equals(pHeader[i])) {
                returnValue = false;
            }
            ++i;
        }
        return returnValue;
    }

    public String[] getHeader() {
        return this._header;
    }

    public void setInput(Object[] pItems, int pHighlightedColumn) {
        this._table.removeAll();
        this._items = new ArrayList<Object>();
        Color red = new Color((Device)this._table.getDisplay(), ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR);
        Object[] objectArray = pItems;
        int n = pItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this._items.add(item);
            List<String> input = this._tableShower.getStringListFromRowObject(item);
            TableItem tableItem = new TableItem(this._table, 0);
            tableItem.setText(input.toArray(new String[0]));
            tableItem.setBackground(pHighlightedColumn, red);
            ++n2;
        }
    }

    public void setInput(Object[] pItems) {
        this._table.removeAll();
        this._items = new ArrayList<Object>();
        Object[] objectArray = pItems;
        int n = pItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            this._items.add(item);
            List<String> input = this._tableShower.getStringListFromRowObject(item);
            TableItem tableItem = new TableItem(this._table, 0);
            tableItem.setText(input.toArray(new String[0]));
            ++n2;
        }
    }

    public Object getSelection() {
        int selection = this._table.getSelectionIndex();
        if (selection == -1) {
            return null;
        }
        return this._items.get(selection);
    }

    public void setSelection(Object pObjectToSelect) {
        int selection = this._items.indexOf(pObjectToSelect);
        this._table.setSelection(selection);
    }

    public Table getTable() {
        return this._table;
    }

    public void setLayoutData(Object pLayout) {
        this._table.setLayoutData(pLayout);
    }

    public void setColumns(String[] pAttributNames) {
        TableColumn column;
        int n;
        int n2;
        Object[] objectArray;
        boolean isEquals = false;
        int counter = 0;
        if (pAttributNames.length == this._table.getColumns().length) {
            isEquals = true;
            objectArray = this._table.getColumns();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                column = objectArray[n];
                if (column.getText() != pAttributNames[counter]) {
                    isEquals = false;
                }
                ++counter;
                ++n;
            }
        }
        if (!isEquals) {
            this._table.removeAll();
            objectArray = this._table.getColumns();
            n2 = objectArray.length;
            n = 0;
            while (n < n2) {
                column = objectArray[n];
                column.dispose();
                ++n;
            }
            objectArray = pAttributNames;
            n2 = pAttributNames.length;
            n = 0;
            while (n < n2) {
                TableColumn attribut = objectArray[n];
                TableColumn column2 = new TableColumn(this._table, 0);
                column2.setText((String)attribut);
                column2.pack();
                ++n;
            }
            this._table.redraw();
        }
    }
}

