/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.vImage.figures;

import de.hwrBerlin.dataMining.view.vImage.figures.FilledFigure;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class Oval
extends FilledFigure {
    public int width = 0;
    public int height = 0;

    public Oval(int pX, int pY, int pWidth, int pHeight) {
        this.x = pX;
        this.y = pY;
        this.width = pWidth;
        this.height = pHeight;
    }

    @Override
    public void paintImage(GC pGc) {
        this.setValuesToGc(pGc);
        pGc.fillOval(this.x, this.y, this.width, this.height);
        pGc.drawOval(this.x, this.y, this.width, this.height);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.width, this.height);
    }

    @Override
    public void paintSVG(Document pDocument) {
        Element root = pDocument.getRootElement();
        Element oval = root.addElement("ellipse");
        this.setValuesToSVGElement(oval);
        oval.addAttribute("cx", "" + (this.x + this.width / 2));
        oval.addAttribute("cy", "" + (this.y + this.height / 2));
        oval.addAttribute("rx", "" + this.width / 2);
        oval.addAttribute("ry", "" + this.height / 2);
    }
}

