/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.vImage.figures;

import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public abstract class Figure {
    public int x = 0;
    public int y = 0;
    protected Color _foreground = null;
    protected int _lineWidth = 1;
    protected int _antialias = 1;

    public abstract void paintImage(GC var1);

    public Image toImage() {
        Image image = new Image(null, this.getBounds().x + this.getBounds().width, this.getBounds().y + this.getBounds().height);
        GC gc = new GC((Drawable)image);
        this.paintImage(gc);
        return image;
    }

    public abstract void paintSVG(Document var1);

    public Document toSVG() {
        Document document = DocumentHelper.createDocument();
        this.paintSVG(document);
        return document;
    }

    protected void setValuesToGc(GC pGc) {
        if (this._foreground != null) {
            pGc.setForeground(this._foreground);
        }
        pGc.setAntialias(this._antialias);
        pGc.setLineWidth(this._lineWidth);
    }

    protected void setValuesToSVGElement(Element pElement) {
        String value = "";
        if (this._foreground != null) {
            value = String.valueOf(value) + "stroke:#" + this.colorToHex(this._foreground) + ";";
        }
        value = String.valueOf(value) + "stroke-width:" + this._lineWidth + "px;";
        pElement.addAttribute("style", value);
    }

    protected String colorToHex(Color pColor) {
        String hex = "";
        int[] rgb = new int[]{pColor.getRed(), pColor.getGreen(), pColor.getBlue()};
        int i = 0;
        while (i < rgb.length) {
            String hexPart = Integer.toHexString(rgb[i]);
            if (hexPart.length() == 1) {
                hexPart = "0" + hexPart;
            }
            hex = String.valueOf(hex) + hexPart;
            ++i;
        }
        return hex;
    }

    public abstract Rectangle getBounds();

    public void setForeground(Color pColor) {
        this._foreground = pColor;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setLineWidth(int pWidth) {
        this._lineWidth = pWidth;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setAntialias(int pAntialias) {
        this._antialias = pAntialias;
    }

    public int getAntialias() {
        return this._antialias;
    }
}

