/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.constants.Images;
import de.hwrBerlin.dataMining.constants.UIConstants;
import de.hwrBerlin.dataMining.controller.Controller;
import de.hwrBerlin.dataMining.controller.observer.Observer;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.dataMining.view.TableView;
import de.hwrBerlin.dataMining.view.TreeView;
import de.hwrBerlin.dataMining.view.dialog.AboutDialogue;
import de.hwrBerlin.dataMining.view.dialog.ConfigurationDialog;
import de.hwrBerlin.dataMining.view.dialog.ManualDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

public class View
implements Observer {
    private Shell _shell;
    private Display _display;
    private Controller _controller;
    private TableView _tableView;
    private static TabFolder _tabFolder;
    private static TabItem _tableItem;
    private static TabItem _interativeTreeItem;
    private static TabItem _automaticTreeItem;
    private MenuItem _subMenuItemExport;

    public View(Controller pController) {
        Display.setAppName((String)"Baumschule");
        this._controller = pController;
        this._controller.addObserverToModel(this);
        this._display = new Display();
        this._shell = new Shell();
        FillLayout shellLayout = new FillLayout();
        shellLayout.marginHeight = 5;
        shellLayout.marginWidth = 5;
        this._shell.setLayout((Layout)shellLayout);
        this._shell.setImages(Images.LOGO_ICONS);
        this._shell.setText("Baumschule");
        this.createMenu();
        this.createTabs();
        this._controller.loadTable(new TableData());
        this.updateEnable(this._controller.getModel().getTable());
        this._shell.open();
        while (!this._shell.isDisposed()) {
            if (this._display.readAndDispatch()) continue;
            this._display.sleep();
        }
        this._display.dispose();
    }

    private void createMenu() {
        Menu menuBar = new Menu((Decorations)this._shell, 2);
        this.createFileMenu(menuBar);
        this.createHelpMenu(menuBar);
        this._shell.setMenuBar(menuBar);
    }

    private void createFileMenu(Menu pParent) {
        MenuItem fileItem = new MenuItem(pParent, 64);
        fileItem.setText("Datei");
        Menu fileMenu = new Menu((Decorations)this._shell, 4);
        fileItem.setMenu(fileMenu);
        MenuItem subMenuItemImport = new MenuItem(fileMenu, 64);
        subMenuItemImport.setText("Import");
        Menu subMenuImport = new Menu((Decorations)this._shell, 4);
        subMenuItemImport.setMenu(subMenuImport);
        MenuItem importTableItem = new MenuItem(subMenuImport, 8);
        importTableItem.setText("Tabelle importieren...");
        importTableItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileDialog = new FileDialog(View.this._shell, 4096);
                fileDialog.setFilterExtensions(UIConstants.TABLE_IMPORT_EXTENSIONS);
                fileDialog.setFilterNames(UIConstants.TABLE_IMPORT_EXTENSIONS_NAMES);
                if (View.this._controller.loadTable(fileDialog.open())) {
                    _tabFolder.setSelection(_tableItem);
                }
            }
        });
        MenuItem importTreeItem = new MenuItem(subMenuImport, 8);
        importTreeItem.setText("Baum importieren...");
        importTreeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileDialog = new FileDialog(View.this._shell, 4096);
                fileDialog.setFilterExtensions(UIConstants.TREE_IMPORT_EXTENSIONS);
                fileDialog.setFilterNames(UIConstants.TREE_IMPORT_EXTENSIONS_NAMES);
                if (View.this._controller.openInteractiveTree(fileDialog.open())) {
                    _tabFolder.setSelection(_interativeTreeItem);
                }
            }
        });
        this._subMenuItemExport = new MenuItem(fileMenu, 64);
        this._subMenuItemExport.setText("Export");
        Menu subMenuExport = new Menu((Decorations)this._shell, 4);
        this._subMenuItemExport.setMenu(subMenuExport);
        MenuItem exportTableItem = new MenuItem(subMenuExport, 8);
        exportTableItem.setText("Tabelle exportieren...");
        exportTableItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileDialog = new FileDialog(View.this._shell, 8192);
                fileDialog.setFilterExtensions(UIConstants.TABLE_EXPORT_EXTENSIONS);
                fileDialog.setFilterNames(UIConstants.TABLE_EXPORT_EXTENSIONS_NAMES);
                View.this._controller.saveTable(fileDialog.open());
            }
        });
        MenuItem exportInteractiveTreeItem = new MenuItem(subMenuExport, 8);
        exportInteractiveTreeItem.setText("Interaktiven Baum exportieren...");
        exportInteractiveTreeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileDialog = new FileDialog(View.this._shell, 8192);
                fileDialog.setFilterExtensions(UIConstants.TREE_EXPORT_EXTENSIONS);
                fileDialog.setFilterNames(UIConstants.TREE_EXPORT_EXTENSIONS_NAMES);
                View.this._controller.saveInteractiveTree(fileDialog.open());
            }
        });
        MenuItem exportAutomaticTreeItem = new MenuItem(subMenuExport, 8);
        exportAutomaticTreeItem.setText("Automatischen Baum exportieren...");
        exportAutomaticTreeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileDialog = new FileDialog(View.this._shell, 8192);
                fileDialog.setFilterExtensions(UIConstants.TREE_EXPORT_EXTENSIONS);
                fileDialog.setFilterNames(UIConstants.TREE_EXPORT_EXTENSIONS_NAMES);
                View.this._controller.saveAutomaticTree(fileDialog.open());
            }
        });
        MenuItem configurationItem = new MenuItem(fileMenu, 8);
        configurationItem.setText("Optionen...");
        configurationItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                View.this.openConfigurations();
            }
        });
        MenuItem exitItem = new MenuItem(fileMenu, 8);
        exitItem.setText("Beenden");
        exitItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                if (!ConfigConstants.SURE_TO_EXIT) {
                    MessageBox messageBox = new MessageBox(View.this._shell, 296);
                    messageBox.setText("Beenden");
                    messageBox.setMessage("Sind sie sich sicher, dass sie Das Programm schli\u00dfen wollen? Alle vorgenommenen \u00c4nderungen die nicht gespeichert wurden gehen verloren!");
                    if (messageBox.open() == 32) {
                        System.exit(0);
                    }
                } else {
                    System.exit(0);
                }
            }
        });
    }

    private void createHelpMenu(Menu pParent) {
        MenuItem helpItem = new MenuItem(pParent, 64);
        helpItem.setText("Hilfe");
        Menu helpMenu = new Menu((Decorations)this._shell, 4);
        helpItem.setMenu(helpMenu);
        MenuItem manualItem = new MenuItem(helpMenu, 8);
        manualItem.setText("Handbuch...");
        manualItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                View.this.openManual();
            }
        });
        MenuItem aboutItem = new MenuItem(helpMenu, 8);
        aboutItem.setText("\u00dcber...");
        aboutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                View.this.openAboutDialog();
            }
        });
    }

    private void openManual() {
        Shell manualShell = new Shell(this._display);
        manualShell.setLayout((Layout)new FillLayout());
        manualShell.setImages(Images.LOGO_ICONS);
        manualShell.setText("Handbuch...");
        new ManualDialog((Composite)manualShell, 0);
        manualShell.pack();
        manualShell.setSize(1000, 600);
        manualShell.open();
    }

    private void openAboutDialog() {
        Shell aboutShell = new Shell(this._display);
        aboutShell.setLayout((Layout)new FillLayout());
        aboutShell.setImages(Images.LOGO_ICONS);
        aboutShell.setText("\u00dcber...");
        new AboutDialogue((Composite)aboutShell, 0);
        aboutShell.pack();
        aboutShell.open();
    }

    private void openConfigurations() {
        if (new ConfigurationDialog(this._shell, 0, this._controller, this._tableView).open() == 32 && this._controller.getModel().getTable() != null) {
            this._controller.updateTrees();
            this._tableView.updateAllTable(this._controller.getModel().getTable());
        }
    }

    private void createTabs() {
        _tabFolder = new TabFolder((Composite)this._shell, 0);
        _tableItem = new TabItem(_tabFolder, 0);
        _tableItem.setText("Tabelle");
        this._tableView = new TableView((Composite)_tabFolder, 0, _tableItem, this._controller);
        _interativeTreeItem = new TabItem(_tabFolder, 0);
        _interativeTreeItem.setText("Interaktiver Baum");
        new TreeView((Composite)_tabFolder, 0, _interativeTreeItem, true, this._controller);
        _automaticTreeItem = new TabItem(_tabFolder, 0);
        _automaticTreeItem.setText("Automatischer optimaler Baum");
        new TreeView((Composite)_tabFolder, 0, _automaticTreeItem, false, this._controller);
        _tabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!View.this._controller.isTableTreeable()) {
                    _tabFolder.setSelection(_tableItem);
                }
            }
        });
    }

    private void updateEnable(TableData pTableData) {
        if (this._controller.isTableTreeable(pTableData)) {
            this._subMenuItemExport.setEnabled(true);
            _interativeTreeItem.setText("Interaktiver Baum");
            _automaticTreeItem.setText("Automatischer optimaler Baum");
        } else {
            this._subMenuItemExport.setEnabled(false);
            _interativeTreeItem.setText("Interaktiver Baum (Deaktiviert)");
            _automaticTreeItem.setText("Automatischer optimaler Baum (Deaktiviert)");
        }
    }

    @Override
    public void updateAllTable(TableData pTableData) {
        this.updateEnable(pTableData);
    }

    @Override
    public void updateTree(TreeNode pTree) {
    }

    @Override
    public void updateAllInteractiveTree(TreeNode pTree) {
    }

    @Override
    public void updateAllAutomaticTree(TreeNode pTree) {
    }
}

