/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view;

import de.hwrBerlin.dataMining.controller.Controller;
import de.hwrBerlin.dataMining.controller.observer.Observer;
import de.hwrBerlin.dataMining.dataStructure.DecisionTreeNode;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.dataMining.view.FullScreenTreeView;
import de.hwrBerlin.dataMining.view.TreeDetails;
import de.hwrBerlin.dataMining.view.TreeZoomView;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TabItem;

public class TreeView
extends Composite
implements Observer {
    private TreeZoomView _treeZoomView;
    private boolean _editable;
    private TreeDetails _treeDetails;
    private Button _setNewRoot;

    public TreeView(Composite pParent, int pStyle, TabItem pTabItem, boolean pEditable, final Controller pController) {
        super(pParent, pStyle);
        this._editable = pEditable;
        pController.addObserverToModel(this);
        final TreeView tmpThis = this;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent pArg0) {
                pController.removeObserverToModel(tmpThis);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        Composite optionComposite = new Composite((Composite)this, 2048);
        optionComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.spacing = 2;
        fillLayout.marginWidth = 1;
        fillLayout.marginHeight = 1;
        optionComposite.setLayout((Layout)fillLayout);
        Composite buttonComposite = new Composite(optionComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(7, false));
        if (pEditable) {
            this._setNewRoot = new Button(buttonComposite, 8);
            this._setNewRoot.setImage(new Image((Device)this.getDisplay(), "images/arrow_undo.png"));
            this._setNewRoot.setToolTipText("Baum zur\u00fccksetzen");
            this._setNewRoot.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent pE) {
                    TreeView.this._treeZoomView.getTreePainter().setSelection(null);
                    TreeView.this._treeDetails.setInput(null);
                    String targetAttribute = ((DecisionTreeNode)TreeView.this._treeZoomView.getTreePainter().getTree().getRoot()).getTargetAttribute();
                    ((DecisionTreeNode)TreeView.this._treeZoomView.getTreePainter().getTree()).setOwnAttribute(targetAttribute);
                }
            });
            this._setNewRoot.setEnabled(false);
        }
        Button setFullScreen = new Button(buttonComposite, 8);
        setFullScreen.setImage(new Image((Device)this.getDisplay(), "images/full_screen_mode.png"));
        setFullScreen.setToolTipText("\u00d6ffnet die Ansicht im Pr\u00e4sentationsmodus.");
        setFullScreen.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new FullScreenTreeView(TreeView.this.getDisplay(), 0, TreeView.this._treeZoomView.getTreePainter().getTree());
            }
        });
        SashForm sashForm = new SashForm((Composite)this, 0);
        sashForm.setLayoutData((Object)new GridData(4, 4, true, true));
        this._treeZoomView = new TreeZoomView((Composite)sashForm, 2048, this);
        this._treeZoomView.setLayoutData(new GridData(4, 4, true, true));
        this._treeDetails = new TreeDetails((Composite)sashForm, 2048, pEditable);
        pTabItem.setControl((Control)this);
    }

    public boolean isEditable() {
        return this._editable;
    }

    public void selectNode(DecisionTreeNode pFindNodeAtPosition) {
        this._treeDetails.setInput(pFindNodeAtPosition);
    }

    @Override
    public void updateAllTable(TableData pTableData) {
    }

    @Override
    public void updateTree(TreeNode pTree) {
    }

    @Override
    public void updateAllInteractiveTree(TreeNode pTree) {
        if (this._editable) {
            if (pTree != null) {
                if (!pTree.getNodeList().contains(this._treeZoomView.getTreePainter().getSelection())) {
                    this._treeZoomView.getTreePainter().setSelection(null);
                }
                this._setNewRoot.setEnabled(true);
            }
            this._treeDetails.setInput((DecisionTreeNode)this._treeZoomView.getTreePainter().getSelection());
            this._treeZoomView.getTreePainter().repaint(pTree);
            this._treeZoomView.getTreePainter().redraw();
        }
    }

    @Override
    public void updateAllAutomaticTree(TreeNode pTree) {
        if (!this._editable) {
            if (pTree != null && !pTree.getNodeList().contains(this._treeZoomView.getTreePainter().getSelection())) {
                this._treeZoomView.getTreePainter().setSelection(null);
            }
            this._treeDetails.setInput((DecisionTreeNode)this._treeZoomView.getTreePainter().getSelection());
            this._treeZoomView.getTreePainter().repaint(pTree);
            this._treeZoomView.getTreePainter().redraw();
        }
    }
}

