/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.dataStructure.DecisionTreeNode;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.dataMining.view.TreeView;
import de.hwrBerlin.dataMining.view.vImage.VImage;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Timer;
import java.util.TimerTask;
import org.dom4j.Document;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseWheelListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.ScrollBar;

public class TreePainter
extends ScrolledComposite {
    private double _zoomFactor = 1.0;
    private TreeNode _root;
    private TreeNode _selectedNode;
    private Image _key_open = new Image(null, "images/key_open.png");
    private Image _key_close = new Image(null, "images/key_close.png");
    private Image _key_icon;
    private Image _key = new Image(null, "images/key.png");
    private boolean _isKeyVisible = false;
    private final int _border = 10;
    private final int _attributeHeigh = 80;
    private final int _spaceHeigh = 60;
    private final int _spaceWidth = 10;
    private final int _fontHeight = 10;
    private final int _fontSpace = 4;
    private Color _background;
    private Color _nodeBackground;
    private Color _nodeForeground;
    private Color _leafBackground;
    private Color _leafForeground;
    private Color _selectedNodeBackground;
    private Color _selectedForeground;
    private Map<Rectangle, TreeNode> _nodeCoordinates = new HashMap<Rectangle, TreeNode>();
    private Composite _paintComposite;
    private List<TreeNode> _painted = new ArrayList<TreeNode>();
    private int _mouseMode = 0;
    ArrayList<Integer> _freeModi = new ArrayList();
    private Point _mouseMoveModeCenter = new Point(0, 0);
    private int _mouseMoveModeXDirection = 0;
    private int _mouseMoveModeYDirection = 0;
    private Timer _mouseMoveModeTimer;

    public TreePainter(Composite pParent, int pStyle, final TreeView pTreeView) {
        super(pParent, pStyle);
        this._freeModi.add(0);
        this._freeModi.add(2);
        this.setColors();
        this.setBackground(this._background);
        this._key_icon = this._isKeyVisible ? this._key_close : this._key_open;
        this._paintComposite = new Composite((Composite)this, 0);
        this._paintComposite.setLayoutData((Object)new GridData(4, 4, true, true));
        this._paintComposite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent pE) {
                VImage image = new VImage(null, ((TreePainter)TreePainter.this).getMaxTreeSize().x, ((TreePainter)TreePainter.this).getMaxTreeSize().y);
                TreePainter.this.paintTree(image);
                image.paintImage(pE.gc);
                if (TreePainter.this._isKeyVisible) {
                    pE.gc.drawImage(TreePainter.this._key, 0, 0);
                }
                pE.gc.drawImage(TreePainter.this._key_icon, 0, 0);
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseUp(MouseEvent pE) {
                if (pE.button == 1 && TreePainter.this._freeModi.contains(TreePainter.this._mouseMode)) {
                    DecisionTreeNode foundNode;
                    if (TreePainter.this._key_icon.getBounds().contains(pE.x, pE.y)) {
                        TreePainter.this._isKeyVisible = !TreePainter.this._isKeyVisible;
                        if (TreePainter.this._isKeyVisible) {
                            TreePainter.this._key_icon = TreePainter.this._key_close;
                        } else {
                            TreePainter.this._key_icon = TreePainter.this._key_open;
                        }
                        TreePainter.this.repaint(TreePainter.this._root);
                    }
                    if (!(TreePainter.this._key_icon.getBounds().contains(pE.x, pE.y) || TreePainter.this._isKeyVisible && TreePainter.this._key.getBounds().contains(pE.x, pE.y) || (foundNode = (DecisionTreeNode)this.findNodeAtPosition(pE.x, pE.y)) == TreePainter.this._selectedNode || pTreeView == null)) {
                        pTreeView.selectNode(foundNode);
                        TreePainter.this._selectedNode = foundNode;
                        TreePainter.this.repaint(TreePainter.this._root);
                    }
                } else if (pE.button == 2 && TreePainter.this._freeModi.contains(TreePainter.this._mouseMode)) {
                    MouseMoveListener mouseMoveListener = new MouseMoveListener(){

                        private int calculateMouseMoveModeDirection(double newPosition, double oldPosition) {
                            return (int)((newPosition - oldPosition) / 2.0 / 5.0 * 5.0);
                        }

                        public void mouseMove(MouseEvent pE) {
                            int xPos = pE.x - TreePainter.this.getHorizontalBar().getSelection();
                            int yPos = pE.y - TreePainter.this.getVerticalBar().getSelection();
                            TreePainter.this._mouseMoveModeXDirection = this.calculateMouseMoveModeDirection(xPos, ((TreePainter)(this).TreePainter.this)._mouseMoveModeCenter.x);
                            TreePainter.this._mouseMoveModeYDirection = this.calculateMouseMoveModeDirection(yPos, ((TreePainter)(this).TreePainter.this)._mouseMoveModeCenter.y);
                            if (TreePainter.this._mouseMoveModeXDirection < 0) {
                                if (TreePainter.this._mouseMoveModeYDirection < 0) {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_nw.png"), 16, 16));
                                } else if (TreePainter.this._mouseMoveModeYDirection > 0) {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_sw.png"), 16, 16));
                                } else {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_w.png"), 16, 16));
                                }
                            } else if (TreePainter.this._mouseMoveModeXDirection > 0) {
                                if (TreePainter.this._mouseMoveModeYDirection < 0) {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_ne.png"), 16, 16));
                                } else if (TreePainter.this._mouseMoveModeYDirection > 0) {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_se.png"), 16, 16));
                                } else {
                                    TreePainter.this.getCursor().dispose();
                                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_e.png"), 16, 16));
                                }
                            } else if (TreePainter.this._mouseMoveModeYDirection < 0) {
                                TreePainter.this.getCursor().dispose();
                                TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_n.png"), 16, 16));
                            } else if (TreePainter.this._mouseMoveModeYDirection > 0) {
                                TreePainter.this.getCursor().dispose();
                                TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_s.png"), 16, 16));
                            } else {
                                TreePainter.this.getCursor().dispose();
                                TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_all.png"), 16, 16));
                            }
                        }
                    };
                    MouseAdapter mouseListener = new MouseAdapter(){

                        public void mouseUp(MouseEvent pE) {
                            if (TreePainter.this._mouseMode != 0) {
                                TreePainter.this.getCursor().dispose();
                                TreePainter.this.setCursor(new Cursor(null, 0));
                                TreePainter.this._mouseMoveModeTimer.cancel();
                                TreePainter.this._mouseMode = 0;
                            }
                        }
                    };
                    TreePainter.this.addMouseMoveListener(mouseMoveListener);
                    TreePainter.this.addMouseListener((MouseListener)mouseListener);
                    TreePainter.this._mouseMode = 1;
                    ((TreePainter)TreePainter.this)._mouseMoveModeCenter.x = pE.x - TreePainter.this.getHorizontalBar().getSelection();
                    ((TreePainter)TreePainter.this)._mouseMoveModeCenter.y = pE.y - TreePainter.this.getVerticalBar().getSelection();
                    TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_size_all.png"), 16, 16));
                    TreePainter.this._mouseMoveModeTimer = new Timer();
                    TreePainter.this._mouseMoveModeTimer.schedule(new TimerTask(){

                        @Override
                        public void run() {
                            if (!TreePainter.this.isDisposed()) {
                                TreePainter.this.getDisplay().asyncExec(new Runnable(){

                                    @Override
                                    public void run() {
                                        TreePainter.this.scroll(TreePainter.this._mouseMoveModeXDirection, TreePainter.this._mouseMoveModeYDirection);
                                    }
                                });
                            }
                        }
                    }, 0L, 50L);
                    while (TreePainter.this._mouseMode == 1) {
                        Display display;
                        if (TreePainter.this.isDisposed() || (display = TreePainter.this.getDisplay()).readAndDispatch()) continue;
                        display.sleep();
                    }
                    TreePainter.this.removeMouseMoveListener(mouseMoveListener);
                    TreePainter.this.removeMouseListener((MouseListener)mouseListener);
                }
            }

            public void mouseDown(MouseEvent pE) {
                TreePainter.this.setFocus();
                if (pE.button == 1 && TreePainter.this._freeModi.contains(TreePainter.this._mouseMode)) {
                    MouseMoveListener mouseMoveListener = new MouseMoveListener(){

                        public void mouseMove(MouseEvent pE) {
                            if (TreePainter.this._mouseMode != 3) {
                                TreePainter.this._mouseMode = 3;
                                TreePainter.this.setCursor(new Cursor((Device)TreePainter.this.getDisplay(), new ImageData("images/cursor_grabber.png"), 16, 16));
                            }
                            TreePainter.this._mouseMoveModeXDirection = ((TreePainter)(this).TreePainter.this)._mouseMoveModeCenter.x - pE.x;
                            TreePainter.this._mouseMoveModeYDirection = ((TreePainter)(this).TreePainter.this)._mouseMoveModeCenter.y - pE.y;
                            TreePainter.this.scroll(TreePainter.this._mouseMoveModeXDirection, TreePainter.this._mouseMoveModeYDirection);
                        }
                    };
                    MouseAdapter mouseListener = new MouseAdapter(){

                        public void mouseUp(MouseEvent pE) {
                            if (TreePainter.this._mouseMode != 0 && pE.button == 1) {
                                if (TreePainter.this._mouseMode == 3) {
                                    TreePainter.this.getCursor().dispose();
                                }
                                TreePainter.this.setCursor(new Cursor(null, 0));
                                TreePainter.this._mouseMode = 0;
                            }
                        }
                    };
                    TreePainter.this.addMouseMoveListener(mouseMoveListener);
                    TreePainter.this.addMouseListener((MouseListener)mouseListener);
                    TreePainter.this._mouseMode = 2;
                    ((TreePainter)TreePainter.this)._mouseMoveModeCenter.x = pE.x;
                    ((TreePainter)TreePainter.this)._mouseMoveModeCenter.y = pE.y;
                    while (TreePainter.this._mouseMode == 2 || TreePainter.this._mouseMode == 3) {
                        Display display;
                        if (TreePainter.this.isDisposed() || (display = TreePainter.this.getDisplay()).readAndDispatch()) continue;
                        display.sleep();
                    }
                    TreePainter.this.removeMouseMoveListener(mouseMoveListener);
                    TreePainter.this.removeMouseListener((MouseListener)mouseListener);
                }
            }

            private TreeNode findNodeAtPosition(int pX, int pY) {
                for (Rectangle rectangle : TreePainter.this._nodeCoordinates.keySet()) {
                    if (!rectangle.contains(pX, pY)) continue;
                    return (TreeNode)TreePainter.this._nodeCoordinates.get(rectangle);
                }
                return null;
            }
        });
        this.setFocus();
    }

    public void addMouseListener(MouseListener pListener) {
        super.addMouseListener(pListener);
        this._paintComposite.addMouseListener(pListener);
    }

    public void removeMouseListener(MouseListener pListener) {
        super.removeMouseListener(pListener);
        this._paintComposite.removeMouseListener(pListener);
    }

    public void addMouseMoveListener(MouseMoveListener pListener) {
        super.addMouseMoveListener(pListener);
        this._paintComposite.addMouseMoveListener(pListener);
    }

    public void removeMouseMoveListener(MouseMoveListener pListener) {
        super.removeMouseMoveListener(pListener);
        this._paintComposite.removeMouseMoveListener(pListener);
    }

    public void addMouseWheelListener(MouseWheelListener pListener) {
        super.addMouseWheelListener(pListener);
        this._paintComposite.addMouseWheelListener(pListener);
    }

    public void removeMouseWheelListener(MouseWheelListener pListener) {
        super.removeMouseWheelListener(pListener);
        this._paintComposite.removeMouseWheelListener(pListener);
    }

    private void scroll(int pX, int pY) {
        ScrollBar horizontalBar = this.getHorizontalBar();
        ScrollBar verticalBar = this.getVerticalBar();
        int x = horizontalBar.getSelection() + pX;
        int y = verticalBar.getSelection() + pY;
        x = x < horizontalBar.getMinimum() ? horizontalBar.getMinimum() : x;
        x = x > horizontalBar.getMaximum() ? horizontalBar.getMaximum() : x;
        y = y < verticalBar.getMinimum() ? verticalBar.getMinimum() : y;
        y = y > verticalBar.getMaximum() ? verticalBar.getMaximum() : y;
        this.setOrigin(x, y);
    }

    private void paintTree(VImage pImage) {
        this._nodeCoordinates.clear();
        this._paintComposite.setBackground(this._background);
        this.setBackground(this._background);
        pImage.setBackground(this._background);
        pImage.setForeground(this._background);
        pImage.drawRectangle(0, 0, this.getMaxTreeSize().x, this.getMaxTreeSize().y);
        if (this._root != null) {
            this._painted = new ArrayList<TreeNode>();
            pImage.setFontName("Courier");
            pImage.setFontSize(this.zoomSize(10.0));
            int width = 10;
            Stack<DecisionTreeNode> toPaint = new Stack<DecisionTreeNode>();
            for (TreeNode treeNode : this._root.getAllLeafs()) {
                toPaint.push((DecisionTreeNode)treeNode);
            }
            Stack<Point> pointsForLines = new Stack<Point>();
            while (!toPaint.isEmpty()) {
                DecisionTreeNode paintingNode = (DecisionTreeNode)toPaint.pop();
                int nodeWidth = this.getNodeWidth(paintingNode);
                int xPos = width;
                int yPos = 10 + 140 * (paintingNode.getElementDepth() - 1);
                int childSize = 0;
                for (TreeNode item : paintingNode.getAllLeafs()) {
                    childSize += this.getNodeWidth((DecisionTreeNode)item);
                    childSize += 10;
                }
                xPos -= (childSize -= 10) / 2;
                if (!paintingNode.isLeaf()) {
                    xPos -= nodeWidth / 2;
                    xPos -= 5;
                } else {
                    xPos += nodeWidth / 2;
                    xPos += 5;
                }
                pImage.setAntialias(1);
                for (String key : paintingNode.getChilds().keySet()) {
                    int xStartLine = xPos + nodeWidth / 2;
                    int yStartLine = yPos + 40;
                    int xEndLine = ((Point)pointsForLines.peek()).x;
                    int yEndLine = ((Point)pointsForLines.pop()).y;
                    int xText = xEndLine - this.getStringPixelSize(key) / 2;
                    int yText = yEndLine - 10 - 8;
                    pImage.setForeground(this._nodeForeground);
                    pImage.setBackground(this._background);
                    pImage.setLineWidth(this.zoomSize(1.0));
                    pImage.drawLine(this.zoomSize(xStartLine), this.zoomSize(yStartLine), this.zoomSize(xEndLine), this.zoomSize(yEndLine));
                    if (!(this._zoomFactor > 0.3)) continue;
                    pImage.drawText(key, this.zoomSize(xText), this.zoomSize(yText));
                }
                if (this._zoomFactor > 0.3 && !paintingNode.isLeaf()) {
                    DecimalFormat format = new DecimalFormat("0.00");
                    String weightedEntropyText = String.valueOf(format.format(paintingNode.calculateWeightedEntropy()));
                    int xText = xPos + nodeWidth / 2 - this.getStringPixelSize(weightedEntropyText) / 2;
                    int yText = yPos + 80 + 8;
                    pImage.drawText(weightedEntropyText, this.zoomSize(xText), this.zoomSize(yText));
                }
                this.paintNodeAtPosition(paintingNode, xPos, yPos, pImage);
                this._painted.add(paintingNode);
                pointsForLines.push(new Point(xPos + nodeWidth / 2, yPos));
                if (paintingNode.getChilds().size() == 0) {
                    width += nodeWidth;
                    width += 10;
                }
                if (paintingNode.getParent() == null || !this.allChildsPainted(paintingNode.getParent())) continue;
                toPaint.push((DecisionTreeNode)paintingNode.getParent());
            }
        }
    }

    private boolean allChildsPainted(TreeNode pParent) {
        for (String itemKey : pParent.getChilds().keySet()) {
            if (this._painted.contains(pParent.getChilds().get(itemKey))) continue;
            return false;
        }
        return true;
    }

    private int getNodeWidth(DecisionTreeNode pNode) {
        int width = 0;
        Object[] objectArray = this.getNodeStrings(pNode);
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object line = objectArray[n2];
            width = Math.max(width, ((String)line).length());
            ++n2;
        }
        width = this.getStringPixelSize(width) + 80;
        return width;
    }

    private Object[] getNodeStrings(DecisionTreeNode pNode) {
        ArrayList<String> list = new ArrayList<String>();
        DecimalFormat format = new DecimalFormat("0.00");
        list.add(String.valueOf(pNode.getCountOfElements()));
        list.add(pNode.getNodeName());
        list.add(String.valueOf(format.format(pNode.calculateEntropy())));
        if (pNode.isLeaf()) {
            list.add("-----");
            TableData table = pNode.getSourceTable();
            int elementCount = table.getRowCount() - 1;
            Map<String, Integer> valueCounts = table.getValueCountsForAttributName(pNode.getTargetAttribute());
            for (String value : valueCounts.keySet()) {
                list.add(String.valueOf(value) + ": " + valueCounts.get(value) + " / " + elementCount);
            }
        }
        return list.toArray();
    }

    private int getNodeHeight(DecisionTreeNode pNode) {
        int height = 80;
        if (pNode.isLeaf()) {
            height += this.getLeafPlusHeight(pNode);
        }
        return height;
    }

    private int getLeafPlusHeight(DecisionTreeNode pNode) {
        return (pNode.getSourceTable().getCountOfDifferentValuesFromAttributName(pNode.getTargetAttribute()) + 1) * 14;
    }

    private void paintNodeAtPosition(DecisionTreeNode pNode, int pX, int pY, VImage pImage) {
        int nodeWidth = this.getNodeWidth(pNode);
        int nodeHeight = this.getNodeHeight(pNode);
        this._nodeCoordinates.put(new Rectangle(this.zoomSize(pX), this.zoomSize(pY), this.zoomSize(nodeWidth), this.zoomSize(nodeHeight)), pNode);
        if (pNode != this._selectedNode) {
            if (pNode.isLeaf()) {
                pImage.setBackground(this._leafBackground);
                pImage.setForeground(this._leafForeground);
            } else {
                pImage.setBackground(this._nodeBackground);
                pImage.setForeground(this._nodeForeground);
            }
        } else {
            pImage.setBackground(this._selectedNodeBackground);
            pImage.setForeground(this._selectedForeground);
        }
        pImage.setLineWidth(this.zoomSize(2.0));
        if (pNode.isLeaf()) {
            pImage.drawRectangle(this.zoomSize(pX), this.zoomSize(pY), this.zoomSize(nodeWidth), this.zoomSize(nodeHeight));
        } else {
            pImage.drawOval(this.zoomSize(pX), this.zoomSize(pY), this.zoomSize(nodeWidth), this.zoomSize(nodeHeight));
        }
        if (this._zoomFactor > 0.3) {
            int textY = pY + 40 - 5 - 4 - 10;
            Object[] objectArray = this.getNodeStrings(pNode);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object value = objectArray[n2];
                String writeString = (String)value;
                pImage.drawText(writeString, this.zoomSize(pX + (nodeWidth - this.getStringPixelSize(writeString)) / 2), this.zoomSize(textY));
                textY += 14;
                ++n2;
            }
        }
    }

    public Image toImage() {
        VImage image = new VImage(null, this.getMaxTreeSize().x, this.getMaxTreeSize().y);
        this.paintTree(image);
        return image.toImage();
    }

    public Document toSVG() {
        VImage image = new VImage(null, this.getMaxTreeSize().x, this.getMaxTreeSize().y);
        this.paintTree(image);
        return image.toSVG();
    }

    private void setColors() {
        this._background = new Color((Device)this.getDisplay(), ConfigConstants.TREE_BACKGROUND_COLOR);
        this._nodeBackground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_NODE_BACKGROUND_COLOR);
        this._nodeForeground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_NODE_FOREGROUND_COLOR);
        this._leafBackground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_LEAF_BACKGROUND_COLOR);
        this._leafForeground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_LEAF_FOREGROUND_COLOR);
        this._selectedNodeBackground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR);
        this._selectedForeground = new Color((Device)this.getDisplay(), ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR);
    }

    private int zoomSize(double pSize) {
        return (int)(pSize * this._zoomFactor);
    }

    public void zoom(int pSelection) {
        this._zoomFactor = (double)(100 - pSelection) / 50.0;
        if (this._zoomFactor == 0.0) {
            this._zoomFactor = 0.01;
        }
        if (pSelection < 50) {
            this._zoomFactor = this._zoomFactor * this._zoomFactor * this._zoomFactor * this._zoomFactor;
        }
        this.repaint(this._root);
    }

    private int getStringPixelSize(String pString) {
        return this.getStringPixelSize(pString.length());
    }

    private int getStringPixelSize(int pLength) {
        return pLength * 8;
    }

    private Point getMaxTreeSize() {
        int x = 20;
        int y = 20 + 80 * this._root.getTreeDepth() + 60 * (this._root.getTreeDepth() - 1);
        int plusY = 0;
        for (TreeNode leaf : this._root.getAllLeafs()) {
            plusY = Math.max(plusY, this.getLeafPlusHeight((DecisionTreeNode)leaf));
        }
        y += plusY;
        for (TreeNode treeNode : this._root.getAllLeafs()) {
            x += this.getNodeWidth((DecisionTreeNode)treeNode);
        }
        x += 10 * this._root.getAllLeafs().size();
        x = this.zoomSize(x);
        y = this.zoomSize(y);
        return new Point(x, y);
    }

    public void repaint(TreeNode pRoot) {
        this.setColors();
        this.setBackground(this._background);
        this._root = pRoot;
        if (this._root != null) {
            Point origin = this.getOrigin();
            int maxWidth = this.getMaxTreeSize().x;
            int maxHeigh = this.getMaxTreeSize().y;
            this.setContent((Control)this._paintComposite);
            if (maxWidth < this._key_icon.getBounds().x + this._key_icon.getBounds().width) {
                maxWidth = this._key_icon.getBounds().x + this._key_icon.getBounds().width;
            }
            if (maxHeigh < this._key_icon.getBounds().y + this._key_icon.getBounds().height) {
                maxHeigh = this._key_icon.getBounds().y + this._key_icon.getBounds().height;
            }
            if (this._isKeyVisible) {
                if (maxWidth < this._key.getBounds().x + this._key.getBounds().width) {
                    maxWidth = this._key.getBounds().x + this._key.getBounds().width;
                }
                if (maxHeigh < this._key.getBounds().y + this._key.getBounds().height) {
                    maxHeigh = this._key.getBounds().y + this._key.getBounds().height;
                }
            }
            this._paintComposite.setSize(maxWidth, maxHeigh);
            this._paintComposite.redraw();
            this.setOrigin(origin);
        }
    }

    public TreeNode getTree() {
        return this._root;
    }

    public void setSelection(TreeNode node) {
        this._selectedNode = node;
    }

    public TreeNode getSelection() {
        return this._selectedNode;
    }
}

