/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.controller.Controller;
import de.hwrBerlin.dataMining.controller.observer.Observer;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.dataMining.view.ListTableShower;
import de.hwrBerlin.dataMining.view.dialog.AddAttributeDialog;
import de.hwrBerlin.dataMining.view.dialog.AddLineDialog;
import de.hwrBerlin.dataMining.view.dialog.DeleteAttributeDialog;
import de.hwrBerlin.dataMining.view.dialog.EditAttributeDialog;
import de.hwrBerlin.dataMining.view.dialog.EditLineDialog;
import de.hwrBerlin.dataMining.view.widgets.combo.ExtendedComboBox;
import de.hwrBerlin.dataMining.view.widgets.table.ExtendedTable;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.TabItem;

public class TableView
extends Composite
implements Observer {
    private ExtendedTable _table;
    private Controller _controller;
    private Button _newTable;
    private Button _editAttribute;
    private Button _deleteAttribute;
    private Button _addAttribute;
    private Button _editLine;
    private Button _deleteLine;
    private Button _addLine;
    private ExtendedComboBox _selectedAttribut;

    public TableView(Composite pParent, int pStyle, TabItem pTabItem, final Controller pController) {
        super(pParent, pStyle);
        this._controller = pController;
        this._controller.addObserverToModel(this);
        final TableView tmpThis = this;
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent pArg0) {
                TableView.this._controller.removeObserverToModel(tmpThis);
            }
        });
        GridLayout layout = new GridLayout(1, false);
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.setLayout((Layout)layout);
        Composite optionComposite = new Composite((Composite)this, 2048);
        optionComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        FillLayout fillLayout = new FillLayout(256);
        fillLayout.spacing = 2;
        fillLayout.marginWidth = 1;
        fillLayout.marginHeight = 1;
        optionComposite.setLayout((Layout)fillLayout);
        Composite buttonComposite = new Composite(optionComposite, 0);
        buttonComposite.setLayout((Layout)new GridLayout(12, false));
        this._newTable = new Button(buttonComposite, 8);
        this._newTable.setImage(new Image((Device)this.getDisplay(), "images/arrow_undo.png"));
        this._newTable.setToolTipText("Neue Tabelle");
        this._newTable.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                TableView.this._controller.loadTable(new TableData());
            }
        });
        this._newTable.setEnabled(true);
        new Label(buttonComposite, 0).setText("");
        this._addLine = new Button(buttonComposite, 8);
        this._addLine.setImage(new Image((Device)this.getDisplay(), "images/table_add_column.png"));
        this._addLine.setToolTipText("Neuen Datensatz hinzuf\u00fcgen");
        this._addLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new AddLineDialog(TableView.this.getShell(), 0).open(TableView.this._controller);
            }
        });
        this._addLine.setEnabled(false);
        this._deleteLine = new Button(buttonComposite, 8);
        this._deleteLine.setImage(new Image((Device)this.getDisplay(), "images/table_delete_column.png"));
        this._deleteLine.setToolTipText("Ausgew\u00e4hlten Datensatz l\u00f6schen");
        this._deleteLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                MessageBox deleteBox = new MessageBox(TableView.this.getShell(), 296);
                deleteBox.setText("Ausgew\u00e4hlten Datensatz l\u00f6schen");
                deleteBox.setMessage("Sind sie sich sicher, dass sie den folgenden Datensatz l\u00f6schen wollen?\n" + TableView.this._table.getSelection().toString());
                if (deleteBox.open() == 32) {
                    TableView.this._controller.removeLine(TableView.this._table.getTable().getSelectionIndices()[0]);
                    TableView.this._editLine.setEnabled(false);
                    TableView.this._deleteLine.setEnabled(false);
                }
            }
        });
        this._deleteLine.setEnabled(false);
        this._editLine = new Button(buttonComposite, 8);
        this._editLine.setImage(new Image((Device)this.getDisplay(), "images/table_edit_column.png"));
        this._editLine.setToolTipText("Ausgew\u00e4hlten Datensatz editieren");
        this._editLine.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new EditLineDialog(TableView.this.getShell(), 0).open(TableView.this._controller, (List)TableView.this._table.getSelection(), TableView.this._table.getTable().getSelectionIndices()[0] + 1);
            }
        });
        this._editLine.setEnabled(false);
        new Label(buttonComposite, 0).setText("");
        this._addAttribute = new Button(buttonComposite, 8);
        this._addAttribute.setImage(new Image((Device)this.getDisplay(), "images/table_add_row.png"));
        this._addAttribute.setToolTipText("Neues Attribut hinzuf\u00fcgen");
        this._addAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new AddAttributeDialog(TableView.this.getShell(), 0).open(TableView.this._controller);
            }
        });
        this._addAttribute.setEnabled(false);
        this._deleteAttribute = new Button(buttonComposite, 8);
        this._deleteAttribute.setImage(new Image((Device)this.getDisplay(), "images/table_delete_row.png"));
        this._deleteAttribute.setToolTipText("Ein Attribut l\u00f6schen");
        this._deleteAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new DeleteAttributeDialog(TableView.this.getShell(), 0).open(TableView.this._controller);
            }
        });
        this._deleteAttribute.setEnabled(false);
        this._editAttribute = new Button(buttonComposite, 8);
        this._editAttribute.setImage(new Image((Device)this.getDisplay(), "images/table_edit_row.png"));
        this._editAttribute.setToolTipText("Ein Attribut bearbeiten");
        this._editAttribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                new EditAttributeDialog(TableView.this.getShell(), 0).open(TableView.this._controller);
            }
        });
        this._editAttribute.setEnabled(false);
        new Label(buttonComposite, 0).setText("");
        Label selectedAttributLabel = new Label(buttonComposite, 0);
        selectedAttributLabel.setText("Zielattribut:");
        selectedAttributLabel.setToolTipText("W\u00e4hle ein Zielattribut aus");
        this._selectedAttribut = new ExtendedComboBox(buttonComposite, 8, false);
        this._selectedAttribut.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                pController.setTargetAttribute((String)TableView.this._selectedAttribut.getSelection());
            }
        });
        this._selectedAttribut.getCombo().setEnabled(false);
        this._table = new ExtendedTable(this, 67584, new ListTableShower());
        this._table.setLayoutData(new GridData(4, 4, true, true));
        this._table.getTable().setHeaderVisible(true);
        this._table.getTable().setLinesVisible(true);
        this._table.getTable().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                if (TableView.this._table.getSelection() != null) {
                    TableView.this._editLine.setEnabled(true);
                    TableView.this._deleteLine.setEnabled(true);
                } else {
                    TableView.this._editLine.setEnabled(false);
                    TableView.this._deleteLine.setEnabled(false);
                }
            }
        });
        this.updateTreeButtonsEnabled(this._controller.getModel().getTable());
        pTabItem.setControl((Control)this);
    }

    private void updateTreeButtonsEnabled(TableData pTableData) {
        Logger.log((LogLevel)LogLevel.DEBUG, (String)"update Table-Buttons");
        if (pTableData == null) {
            this._addLine.setEnabled(false);
            this._addAttribute.setEnabled(false);
            this._editAttribute.setEnabled(false);
            this._deleteAttribute.setEnabled(false);
            this._selectedAttribut.getCombo().setEnabled(false);
        } else {
            this._addLine.setEnabled(pTableData.getRowCount() - 1 < ConfigConstants.MAX_ROWS && pTableData.getColumnCount() > 0);
            this._addAttribute.setEnabled(pTableData.getColumnCount() < ConfigConstants.MAX_ATTRIBUTES);
            this._editAttribute.setEnabled(pTableData.getColumnCount() > 0);
            this._deleteAttribute.setEnabled(pTableData.getColumnCount() > 0);
            this._selectedAttribut.getCombo().setEnabled(pTableData.getColumnCount() > 0);
        }
    }

    @Override
    public void updateAllTable(TableData pTableData) {
        this._table.setColumns(pTableData.getAttributNames());
        int selectedColumn = -1;
        int i = 0;
        while (pTableData.getAttributNames().length > i) {
            if (pTableData.getAttributNames()[i].equals(pTableData.getSelectedAttribute())) {
                selectedColumn = i;
                break;
            }
            ++i;
        }
        this._table.setInput(pTableData.getRows(), selectedColumn);
        this._selectedAttribut.setInput(pTableData.getAttributNames());
        this._selectedAttribut.setSetlection(pTableData.getSelectedAttribute());
        this.updateTreeButtonsEnabled(pTableData);
    }

    @Override
    public void updateTree(TreeNode pTree) {
    }

    @Override
    public void updateAllInteractiveTree(TreeNode pTree) {
    }

    @Override
    public void updateAllAutomaticTree(TreeNode pTree) {
    }

    public Button getEditAttributeButton() {
        return this._editAttribute;
    }

    public Button getDeleteAttributeButton() {
        return this._deleteAttribute;
    }

    public Button getAddAttributeButton() {
        return this._addAttribute;
    }

    public Button getEditLineButton() {
        return this._editLine;
    }

    public Button getDeleteLineButton() {
        return this._deleteLine;
    }

    public Button getAddLineButton() {
        return this._addLine;
    }
}

