/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.dataStructure;

import de.hwrBerlin.dataMining.controller.observer.Observer;
import de.hwrBerlin.dataMining.controller.observer.Subject;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TreeNode
extends Subject
implements Observer {
    private TreeNode _parent = null;
    protected Map<String, TreeNode> _childs = new HashMap<String, TreeNode>();
    private String _nodeName = "";
    private Object _data = null;

    public TreeNode() {
    }

    public TreeNode(Document pXMLDoc) {
        Element root = pXMLDoc.getRootElement();
        this.setNodeName(root.element("name").getText());
        for (Element child : root.elements("node")) {
            Document childDocument = DocumentHelper.createDocument();
            childDocument.add(child.createCopy());
            this.addChild(child.element("parentPathName").getText(), new TreeNode(childDocument));
        }
    }

    public void addChild(String pAttributeValue, TreeNode pChild) {
        if (!this._childs.containsValue(pChild)) {
            if (pChild._parent != null) {
                pChild._parent.removeChild(pChild);
            }
            pChild._parent = this;
            this._childs.put(pAttributeValue, pChild);
            pChild.addObserver(this);
            this.updatetAllTree(this);
        }
    }

    public void removeChild(TreeNode pChild) {
        for (String key : this._childs.keySet()) {
            if (this._childs.get(key) == pChild) {
                this._childs.get((Object)key)._parent = null;
                this._childs.remove(key);
                pChild.removeObserver(this);
                break;
            }
            this.updatetAllTree(this);
        }
    }

    public String toString() {
        int vSpace = 1;
        int hSpace = 1;
        String returnString = "o ".concat(this._nodeName);
        String br1 = "";
        int i = 0;
        while (i < vSpace) {
            br1 = br1.concat("\n|");
            ++i;
        }
        String branch = "+";
        int i2 = 0;
        while (i2 < hSpace) {
            branch = branch.concat("-");
            ++i2;
        }
        TreeNode[] childs = this._childs.values().toArray(new TreeNode[this._childs.values().size()]);
        int i3 = 0;
        while (i3 < this._childs.values().size()) {
            String br2 = "\n";
            br2 = i3 == this._childs.values().size() - 1 ? br2.concat(" ") : br2.concat("|");
            int j = 0;
            while (j < hSpace) {
                br2 = br2.concat(" ");
                ++j;
            }
            returnString = returnString.concat(br1).concat("\n").concat(branch).concat(childs[i3].toString().replace("\n", br2));
            ++i3;
        }
        return returnString;
    }

    public Object getData() {
        return this._data;
    }

    public void setData(Object pData) {
        this._data = pData;
    }

    public String getNodeName() {
        return this._nodeName;
    }

    public void setNodeName(String pNodeName) {
        this._nodeName = pNodeName;
    }

    public Map<String, TreeNode> getChilds() {
        return this._childs;
    }

    public TreeNode getParent() {
        return this._parent;
    }

    public List<TreeNode> getAllLeafs() {
        ArrayList<TreeNode> returnList = new ArrayList<TreeNode>();
        if (this.isLeaf()) {
            returnList.add(this);
            return returnList;
        }
        for (String treeNodeKey : this._childs.keySet()) {
            returnList.addAll(this._childs.get(treeNodeKey).getAllLeafs());
        }
        return returnList;
    }

    public int getTreeDepth() {
        if (this.isLeaf()) {
            return 1;
        }
        int depth = 1;
        for (String nodeKey : this._childs.keySet()) {
            if (depth >= this._childs.get(nodeKey).getTreeDepth()) continue;
            depth = this._childs.get(nodeKey).getTreeDepth();
        }
        return ++depth;
    }

    public boolean isLeaf() {
        return this.getChilds().isEmpty();
    }

    public int getElementDepth() {
        if (this.isRoot()) {
            return 1;
        }
        return this._parent.getElementDepth() + 1;
    }

    public boolean isRoot() {
        return this._parent == null;
    }

    @Override
    public void updateTree(TreeNode pTree) {
        this.updatetAllTree(this);
    }

    @Override
    public void updateAllInteractiveTree(TreeNode pTree) {
    }

    @Override
    public void updateAllAutomaticTree(TreeNode pTree) {
    }

    @Override
    public void updateAllTable(TableData pTableData) {
    }

    public TreeNode getRoot() {
        if (this._parent == null) {
            return this;
        }
        return this._parent.getRoot();
    }

    public List<TreeNode> getNodeList() {
        ArrayList<TreeNode> returnList = new ArrayList<TreeNode>();
        for (TreeNode child : this._childs.values()) {
            returnList.addAll(child.getNodeList());
        }
        returnList.add(this);
        return returnList;
    }

    public void update() {
        this.updatetAllTree(this);
    }

    public String getPathNameFromChild(TreeNode pChild) {
        for (String path : this._childs.keySet()) {
            if (this._childs.get(path) != pChild) continue;
            return path;
        }
        return null;
    }

    public String getOwnPathName() {
        if (!this.isRoot()) {
            return this.getParent().getPathNameFromChild(this);
        }
        return null;
    }

    public Document toXML() {
        Document document = DocumentHelper.createDocument();
        String nodeTag = this.isRoot() ? "tree" : "node";
        Element root = document.addElement(nodeTag);
        Element name = root.addElement("name");
        name.addText(this._nodeName);
        if (!this.isRoot()) {
            Element fatherPathName = root.addElement("parentPathName");
            fatherPathName.addText(this.getOwnPathName());
        }
        for (String key : this._childs.keySet()) {
            root.add(this._childs.get(key).toXML().getRootElement());
        }
        return document;
    }
}

