/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.dataStructure;

import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.tools.logger.Logger;
import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;

public class TestTableData
extends TestCase {
    @Test
    public void testAddRowToEnd() {
        TableData tData = new TableData();
        ArrayList<String> attributNames = new ArrayList<String>();
        attributNames.add("AttriName 1");
        attributNames.add("AttriName 2");
        attributNames.add("AttriName 3");
        attributNames.add("TESTNAME");
        attributNames.add("AttriName 5");
        ArrayList<String> firstDataRow = new ArrayList<String>();
        firstDataRow.add("AData 23");
        firstDataRow.add("Dsata 34");
        firstDataRow.add("TESTWERT1");
        firstDataRow.add("Datea 231");
        firstDataRow.add("Daeta 24");
        ArrayList<String> secondDataRow = new ArrayList<String>();
        secondDataRow.add("gsdrg");
        secondDataRow.add("dgrdg 45 2");
        secondDataRow.add("Asefsefe 3");
        secondDataRow.add("4534gb sgsegss");
        secondDataRow.add("TESTWERT2");
        tData.addRowToEnd(attributNames);
        tData.addRowToEnd(firstDataRow);
        tData.addRowToEnd(secondDataRow);
        TestTableData.assertTrue((tData.getRowCount() == 3 && tData.getColumnCount() == 5 ? 1 : 0) != 0);
        TestTableData.assertTrue((boolean)tData.getValueFromIndex(0, 0).equals("AttriName 1"));
        TestTableData.assertTrue((boolean)tData.getValueFromIndex(2, 4).equals("TESTWERT2"));
    }

    @Test
    public void testAddColumnToEnd() {
        TableData tData = new TableData();
        ArrayList<String> column1 = new ArrayList<String>();
        column1.add("AttriName 1");
        column1.add("AttriName 2");
        column1.add("AttriName 3");
        column1.add("TESTNAME");
        column1.add("AttriName 5");
        ArrayList<String> column2 = new ArrayList<String>();
        column2.add("AData 23");
        column2.add("Dsata 34");
        column2.add("TESTWERT1");
        column2.add("Datea 231");
        column2.add("Daeta 24");
        ArrayList<String> column3 = new ArrayList<String>();
        column3.add("gsdrg");
        column3.add("dgrdg 45 2");
        column3.add("Asefsefe 3");
        column3.add("4534gb sgsegss");
        column3.add("TESTWERT2");
        tData.addColumnToEnd(column1);
        tData.addColumnToEnd(column2);
        tData.addColumnToEnd(column3);
        TestTableData.assertEquals((int)5, (int)tData.getRowCount());
        TestTableData.assertEquals((int)3, (int)tData.getColumnCount());
        TestTableData.assertTrue((boolean)tData.getValueFromIndex(0, 0).equals("AttriName 1"));
        TestTableData.assertTrue((boolean)tData.getValueFromIndex(3, 2).equals("4534gb sgsegss"));
        TestTableData.assertTrue((boolean)tData.getValueFromIndex(4, 2).equals("TESTWERT2"));
    }

    @Test
    public void testDeleteRow() {
        TableData tData = this.generateTestTable();
        TestTableData.assertTrue((tData.getRowCount() == 3 && tData.getColumnCount() == 5 ? 1 : 0) != 0);
        tData.deleteRow(0);
        TestTableData.assertEquals((int)2, (int)tData.getRowCount());
        TestTableData.assertEquals((String)"AData 23", (String)tData.getValueFromIndex(0, 0));
        TestTableData.assertTrue((boolean)tData.deleteRow(0));
        TestTableData.assertEquals((int)1, (int)tData.getRowCount());
        tData.deleteRow(0);
        TestTableData.assertEquals((int)0, (int)tData.getRowCount());
        Logger.setGraphicalLog((boolean)false);
        TestTableData.assertFalse((String)"Versuche Zeile zu l\u00f6schen, die es nicht gibt", (boolean)tData.deleteRow(6));
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testDeleteColumn() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)3, (int)tData.getRowCount());
        TestTableData.assertEquals((int)5, (int)tData.getColumnCount());
        Logger.setGraphicalLog((boolean)false);
        TestTableData.assertTrue((boolean)tData.deleteColumn(1));
        TestTableData.assertEquals((int)4, (int)tData.getColumnCount());
        TestTableData.assertEquals((String)"Asefsefe 3", (String)tData.getValueFromIndex(2, 1));
        TestTableData.assertTrue((boolean)tData.deleteColumn(0));
        TestTableData.assertEquals((int)3, (int)tData.getColumnCount());
        TestTableData.assertTrue((boolean)tData.deleteColumn(0));
        TestTableData.assertEquals((int)2, (int)tData.getColumnCount());
        TestTableData.assertTrue((boolean)tData.deleteColumn(0));
        TestTableData.assertEquals((int)1, (int)tData.getColumnCount());
        TestTableData.assertTrue((boolean)tData.deleteColumn(0));
        TestTableData.assertEquals((int)0, (int)tData.getColumnCount());
        TestTableData.assertFalse((boolean)tData.deleteColumn(6));
        TestTableData.assertFalse((boolean)tData.deleteColumn(0));
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testUpdateCellValueFromIndex() {
        TableData tData = this.generateTestTable();
        tData.updateCellValueFromIndex(0, 0, "Neuer ZellenWert");
        TestTableData.assertEquals((String)"Neuer ZellenWert", (String)tData.getValueFromIndex(0, 0));
        tData.updateCellValueFromIndex(2, 1, "Neuer ZellenWert");
        TestTableData.assertEquals((String)"Neuer ZellenWert", (String)tData.getValueFromIndex(2, 1));
        TestTableData.assertNotSame((Object)"Neuer ZellenWert", (Object)tData.getValueFromIndex(1, 2));
        Logger.setGraphicalLog((boolean)false);
        TestTableData.assertFalse((String)"Es darf nicht auf diese Zelle zugegriffen werden", (boolean)tData.updateCellValueFromIndex(99, 99, "Bla"));
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testGetAttributNames() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((String)"AttriName 1", (String)tData.getAttributNames()[0]);
        TestTableData.assertEquals((String)"AttriName 5", (String)tData.getAttributNames()[4]);
        TestTableData.assertEquals((int)5, (int)tData.getAttributNames().length);
        ArrayList<String> column = new ArrayList<String>();
        column.add("gsdrg");
        column.add("dgrdg 45 2");
        column.add("TESTWERT2");
        tData.addColumnToEnd(column);
        TestTableData.assertEquals((int)6, (int)tData.getAttributNames().length);
        TestTableData.assertEquals((String)"gsdrg", (String)tData.getAttributNames()[5]);
    }

    @Test
    public void testContainsAttribut() {
        TableData tData = this.generateTestTable();
        TestTableData.assertTrue((String)"Der Attributname soll vorhanden sein", (boolean)tData.containsAttribut("AttriName 1"));
        TestTableData.assertFalse((String)"Dieser Attributname sollte nicht vorhanden sein", (boolean)tData.containsAttribut("AttriName adawdawd"));
    }

    @Test
    public void testAttributContainsValueIntString() {
        TableData tData = this.generateTestTable();
        TestTableData.assertTrue((String)"Der Wert soll vorhanden sein", (boolean)tData.attributContainsValue(0, "gsdrg"));
        TestTableData.assertFalse((String)"Der Wert soll nicht vorhanden sein", (boolean)tData.attributContainsValue(0, "awdawdgsdrg"));
        TestTableData.assertFalse((String)"Die Spalte gibts nicht", (boolean)tData.attributContainsValue(99, "awdawdgsdrg"));
    }

    @Test
    public void testAttributContainsValueStringString() {
        TableData tData = this.generateTestTable();
        TestTableData.assertTrue((String)"Der Wert soll vorhanden sein", (boolean)tData.attributContainsValue("AttriName 1", "gsdrg"));
        TestTableData.assertFalse((String)"Der Wert soll nicht vorhanden sein", (boolean)tData.attributContainsValue("AttriName 1", "awdawdgsdrg"));
        TestTableData.assertFalse((String)"Die Spalte gibts nicht", (boolean)tData.attributContainsValue("Hallo Falsche Spalte", "awdawdgsdrg"));
    }

    @Test
    public void testGetValuesForAttributPosition() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)3, (int)tData.getValuesForAttributPosition(0).length);
        TestTableData.assertEquals((String)"AttriName 1", (String)tData.getValuesForAttributPosition(0)[0]);
        TestTableData.assertEquals((String)"AData 23", (String)tData.getValuesForAttributPosition(0)[1]);
        TestTableData.assertEquals(null, (Object)tData.getValuesForAttributPosition(99));
    }

    @Test
    public void testGetValuesForAttributName() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)3, (int)tData.getValuesForAttributName("AttriName 1").length);
        TestTableData.assertEquals((String)"AttriName 1", (String)tData.getValuesForAttributName("AttriName 1")[0]);
        TestTableData.assertEquals((String)"AData 23", (String)tData.getValuesForAttributName("AttriName 1")[1]);
        TestTableData.assertEquals(null, (Object)tData.getValuesForAttributName("Attrawdawd"));
    }

    @Test
    public void testGetDifferentValuesFromAttributPosition() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)2, (int)tData.getDifferentValuesFromAttributPosition(0).length);
        tData.updateCellValueFromIndex(1, 0, "gsdrg");
        TestTableData.assertEquals((int)1, (int)tData.getDifferentValuesFromAttributPosition(0).length);
        TestTableData.assertEquals((String)"gsdrg", (String)tData.getDifferentValuesFromAttributPosition(0)[0]);
        TestTableData.assertEquals(null, (Object)tData.getDifferentValuesFromAttributPosition(99));
    }

    @Test
    public void testGetDifferentValuesFromAttributName() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)2, (int)tData.getDifferentValuesFromAttributName("AttriName 1").length);
        tData.updateCellValueFromIndex(1, 0, "gsdrg");
        TestTableData.assertEquals((int)1, (int)tData.getDifferentValuesFromAttributName("AttriName 1").length);
        TestTableData.assertEquals((String)"gsdrg", (String)tData.getDifferentValuesFromAttributName("AttriName 1")[0]);
        TestTableData.assertEquals(null, (Object)tData.getDifferentValuesFromAttributName("AttriName 2324"));
    }

    @Test
    public void testGetValueCountsForAttributPosition() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)2, (int)tData.getValueCountsForAttributPosition(0).size());
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributPosition(0).get("gsdrg"));
        tData.updateCellValueFromIndex(1, 0, "gsdrg");
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributPosition(0).size());
        TestTableData.assertEquals((int)2, (int)tData.getValueCountsForAttributPosition(0).get("gsdrg"));
        tData.deleteRow(2);
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributPosition(0).size());
        TestTableData.assertEquals(null, tData.getValueCountsForAttributPosition(99));
    }

    @Test
    public void testGetValueCountsForAttributName() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)2, (int)tData.getValueCountsForAttributName("AttriName 1").size());
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributName("AttriName 1").get("gsdrg"));
        tData.updateCellValueFromIndex(1, 0, "gsdrg");
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributName("AttriName 1").size());
        TestTableData.assertEquals((int)2, (int)tData.getValueCountsForAttributName("AttriName 1").get("gsdrg"));
        tData.deleteRow(2);
        TestTableData.assertEquals((int)1, (int)tData.getValueCountsForAttributName("AttriName 1").size());
        TestTableData.assertEquals(null, tData.getValueCountsForAttributName("AttriName 1awrw3r"));
    }

    @Test
    public void testGetValueFromIndex() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((String)"AttriName 1", (String)tData.getValueFromIndex(0, 0));
        TestTableData.assertEquals((String)"gsdrg", (String)tData.getValueFromIndex(2, 0));
        TestTableData.assertEquals((String)"TESTWERT2", (String)tData.getValueFromIndex(2, 4));
        Logger.setGraphicalLog((boolean)false);
        TestTableData.assertEquals(null, (String)tData.getValueFromIndex(99, 124));
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testGetValueFromRowAndAttributName() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((String)"AttriName 1", (String)tData.getValueFromRowAndAttributName(0, "AttriName 1"));
        TestTableData.assertEquals((String)"gsdrg", (String)tData.getValueFromRowAndAttributName(2, "AttriName 1"));
        TestTableData.assertEquals((String)"TESTWERT2", (String)tData.getValueFromRowAndAttributName(2, "AttriName 5"));
        Logger.setGraphicalLog((boolean)false);
        TestTableData.assertEquals(null, (String)tData.getValueFromRowAndAttributName(1, "Falsche Bezeichnung"));
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testGetRowCount() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)3, (int)tData.getRowCount());
        tData.deleteRow(0);
        TestTableData.assertEquals((int)2, (int)tData.getRowCount());
        tData.deleteRow(0);
        tData.deleteRow(0);
        TestTableData.assertEquals((int)0, (int)tData.getRowCount());
        ArrayList<String> newRow = new ArrayList<String>();
        newRow.add("AttriName 1");
        newRow.add("AttriName 2");
        newRow.add("AttriName 3");
        newRow.add("TESTNAME");
        newRow.add("AttriName 5");
        tData.addRowToEnd(newRow);
        TestTableData.assertEquals((int)1, (int)tData.getRowCount());
    }

    @Test
    public void testGetCellCount() {
        TableData tData = this.generateTestTable();
        TestTableData.assertEquals((int)5, (int)tData.getColumnCount());
        tData.deleteColumn(0);
        TestTableData.assertEquals((int)4, (int)tData.getColumnCount());
        tData.deleteColumn(0);
        tData.deleteColumn(0);
        tData.deleteColumn(0);
        tData.deleteColumn(0);
        TestTableData.assertEquals((int)0, (int)tData.getColumnCount());
        ArrayList<String> newRow = new ArrayList<String>();
        newRow.add("AttriName n1");
        newRow.add("AttriName 2");
        newRow.add("AttriName 3");
        newRow.add("TESTNAME");
        newRow.add("AttriName 5");
        tData.addRowToEnd(newRow);
        TestTableData.assertEquals((int)5, (int)tData.getColumnCount());
    }

    @Test
    public void testToString() {
    }

    @Test
    public void testCreateDuplicateTable() {
        TableData tData = this.generateTestTable();
        TableData tDataCopy = tData.createDuplicateTable();
        TestTableData.assertEquals((int)tData.getColumnCount(), (int)tDataCopy.getColumnCount());
        TestTableData.assertEquals((int)tData.getRowCount(), (int)tDataCopy.getRowCount());
        TestTableData.assertEquals((String)tData.getValueFromIndex(0, 1), (String)tDataCopy.getValueFromIndex(0, 1));
    }

    @Test
    public void testYesNoParser() {
    }

    @Test
    public void testSetCompleteTable() {
        TableData tData = new TableData();
        ArrayList<List<String>> tableData = new ArrayList<List<String>>();
        ArrayList<String> attributNames = new ArrayList<String>();
        attributNames.add("AttriName 1");
        attributNames.add("AttriName 2");
        attributNames.add("AttriName 3");
        attributNames.add("TESTNAME");
        attributNames.add("AttriName 5");
        ArrayList<String> firstDataRow = new ArrayList<String>();
        firstDataRow.add("AData 23");
        firstDataRow.add("Dsata 34");
        firstDataRow.add("TESTWERT1");
        firstDataRow.add("Datea 231");
        firstDataRow.add("Daeta 24");
        ArrayList<String> secondDataRow = new ArrayList<String>();
        secondDataRow.add("gsdrg");
        secondDataRow.add("dgrdg 45 2");
        secondDataRow.add("Asefsefe 3");
        secondDataRow.add("4534gb sgsegss");
        secondDataRow.add("TESTWERT2");
        tableData.add(attributNames);
        tableData.add(firstDataRow);
        tableData.add(secondDataRow);
        tData.setCompleteTable(tableData);
        TestTableData.assertEquals((int)3, (int)tData.getRowCount());
        TestTableData.assertEquals((int)5, (int)tData.getColumnCount());
    }

    @Test
    public void testGetCompleteTable() {
        TableData tData = this.generateTestTable();
        List<List<String>> tableData = tData.getCompleteTable();
        TestTableData.assertEquals((int)3, (int)tableData.size());
        TestTableData.assertEquals((int)5, (int)tableData.get(0).size());
    }

    private TableData generateTestTable() {
        TableData tData = new TableData();
        ArrayList<String> attributNames = new ArrayList<String>();
        attributNames.add("AttriName 1");
        attributNames.add("AttriName 2");
        attributNames.add("AttriName 3");
        attributNames.add("TESTNAME");
        attributNames.add("AttriName 5");
        ArrayList<String> firstDataRow = new ArrayList<String>();
        firstDataRow.add("AData 23");
        firstDataRow.add("Dsata 34");
        firstDataRow.add("TESTWERT1");
        firstDataRow.add("Datea 231");
        firstDataRow.add("Daeta 24");
        ArrayList<String> secondDataRow = new ArrayList<String>();
        secondDataRow.add("gsdrg");
        secondDataRow.add("dgrdg 45 2");
        secondDataRow.add("Asefsefe 3");
        secondDataRow.add("4534gb sgsegss");
        secondDataRow.add("TESTWERT2");
        tData.addRowToEnd(attributNames);
        tData.addRowToEnd(firstDataRow);
        tData.addRowToEnd(secondDataRow);
        return tData;
    }
}

