/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.dataStructure;

import de.hwrBerlin.dataMining.controller.observer.Subject;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class TableData
extends Subject {
    private List<List<String>> _table = new ArrayList<List<String>>();
    private String _selectedAttribute;

    public TableData() {
    }

    public TableData(Document pXMLDoc) {
        Element root = pXMLDoc.getRootElement();
        Element head = root.element("head");
        ArrayList<String> headList = new ArrayList<String>();
        for (Element attribut : head.elements("attribute")) {
            headList.add(attribut.getText());
        }
        this.addRowToEnd(headList);
        for (Element row : root.elements("row")) {
            ArrayList<String> rowList = new ArrayList<String>();
            for (Element cell : row.elements("cell")) {
                rowList.add(cell.getText());
            }
            this.addRowToEnd(rowList);
        }
    }

    public boolean addRowToEnd(List<String> pList) {
        if (this.getRowCount() == 0) {
            this._table.add(pList);
            this.updateAllTable(this);
            return true;
        }
        if (pList.size() == this._table.get(0).size()) {
            this._table.add(pList);
            this.updateAllTable(this);
            return true;
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Es wurde versucht eine ung\u00fcltige Zeile in die Tabelle zu f\u00fcgen:" + pList.toString()));
        return false;
    }

    public boolean addColumnToEnd(List<String> pList) {
        if (pList.size() == this._table.size() || this._table.size() == 0) {
            if (this._table.size() == 0) {
                int i = 0;
                while (i < pList.size()) {
                    ArrayList<String> dummyFirstRow = new ArrayList<String>();
                    dummyFirstRow.add(pList.get(i));
                    this._table.add(dummyFirstRow);
                    ++i;
                }
            } else {
                int i = 0;
                while (i < this._table.size()) {
                    this._table.get(i).add(pList.get(i));
                    ++i;
                }
            }
            this.updateAllTable(this);
            return true;
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)"Es wurde versucht eine ung\u00fcltige Spalte in die Tabelle zu f\u00fcgen");
        return false;
    }

    public boolean deleteRow(int pRowNumber) {
        if (pRowNumber > this.getRowCount() - 1 || pRowNumber < 0) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("deleteRow: Konnte die Zeile nicht l\u00f6schen: Nr." + pRowNumber));
            return false;
        }
        this._table.remove(pRowNumber);
        this.updateAllTable(this);
        return true;
    }

    public boolean deleteColumn(int pColumnNumber) {
        String columnName = this._table.get(0).get(pColumnNumber);
        if (pColumnNumber > this.getColumnCount() - 1 || pColumnNumber < 0) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("deleteColumn: Konnte die Spalte nicht l\u00f6schen: Nr." + pColumnNumber));
            return false;
        }
        for (List<String> rowElement : this._table) {
            rowElement.remove(pColumnNumber);
        }
        if (columnName.equals(this.getSelectedAttribute())) {
            if (this._table.get(0).size() == 0) {
                this.setSelectedAttribute(null);
            } else {
                this.setSelectedAttribute(this._table.get(0).get(this._table.get(0).size() - 1));
            }
        }
        try {
            if (this._table.get(0).size() == 0) {
                this._table = new ArrayList<List<String>>();
                Logger.log((LogLevel)LogLevel.INFO, (String)"Tabelle wurde geleert");
            }
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.INFO, (String)"deleteColumn: Konnte Spaltengr\u00f6\u00dfe nicht abfragen");
        }
        this.updateAllTable(this);
        return true;
    }

    public boolean deleteColumnByName(String pAttributName) {
        return this.deleteColumn(this.getAttributPositionByAttributName(pAttributName));
    }

    private boolean internUpdateCellValueFromIndex(int pRow, int pColumn, String pNewCellValue) {
        if (pRow < this._table.size() && pColumn < this._table.get(0).size()) {
            this._table.get(pRow).set(pColumn, pNewCellValue);
            return true;
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("updateCellValueFromIndex: Es wurde auf einen Platz der Tabelle zugegriffen, den es nicht gibt: Zeile: " + pRow + ";Spalte: " + pColumn));
        return false;
    }

    public boolean updateCellValueFromIndex(int pRow, int pColumn, String pNewCellValue) {
        String oldColumnName = this._table.get(0).get(pColumn);
        if (pRow < this._table.size() && pColumn < this._table.get(0).size()) {
            this._table.get(pRow).set(pColumn, pNewCellValue);
            if (pRow == 0 && oldColumnName.equals(this.getSelectedAttribute())) {
                this.setSelectedAttribute(pNewCellValue);
            }
            this.updateAllTable(this);
            return true;
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("updateCellValueFromIndex: Es wurde auf einen Platz der Tabelle zugegriffen, den es nicht gibt: Zeile: " + pRow + ";Spalte: " + pColumn));
        return false;
    }

    public String[] getAttributNames() {
        if (this._table.size() == 0) {
            return new String[0];
        }
        if (this._table.get(0).size() == 0) {
            return new String[0];
        }
        return this._table.get(0).toArray(new String[0]);
    }

    public boolean contains(String pValue) {
        if (this._table.size() == 0) {
            return false;
        }
        int i = 0;
        while (i < this._table.size()) {
            if (this._table.get(i).contains(pValue)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean containsAttribut(String pAttributName) {
        if (this._table.size() == 0) {
            return false;
        }
        return this._table.get(0).contains(pAttributName);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean attributContainsValue(int pAttributPosition, String pAttributValue) {
        try {
            int i = 1;
            while (true) {
                if (i >= this._table.size()) {
                    return false;
                }
                if (pAttributValue.equals(this._table.get(i).get(pAttributPosition))) {
                    return true;
                }
                ++i;
            }
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.INFO, (String)("attributContainsValue: Es wird h\u00f6chstwahrscheinlich auf eine falsche Spalte zugegriffen. Spalte: " + pAttributPosition));
            return false;
        }
    }

    public boolean attributContainsValue(String pAttributName, String pAttributValue) {
        return this.attributContainsValue(this.getAttributPositionByAttributName(pAttributName), pAttributValue);
    }

    private int getAttributPositionByAttributName(String pAttributName) {
        if (this.containsAttribut(pAttributName)) {
            int positionOfAttribut = this._table.get(0).indexOf(pAttributName);
            return positionOfAttribut;
        }
        Logger.log((LogLevel)LogLevel.INFO, (String)("Die Spalte mit dem Namen:>" + pAttributName + "<gibt es nicht. Es gibt: " + this._table.get(0)));
        return -1;
    }

    public String[] getValuesForAttributPosition(int pAtrributPosition) {
        ArrayList<String> returnList = null;
        returnList = new ArrayList<String>();
        try {
            for (List<String> listElement : this._table) {
                returnList.add(listElement.get(pAtrributPosition));
            }
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.INFO, (String)("getValuesForAttributPosition: Es wurde wahrscheinlich versucht auf eine falsche Spalte zuzugreifen:" + pAtrributPosition));
            return null;
        }
        return returnList.toArray(new String[0]);
    }

    public String[] getValuesForAttributName(String pAttributName) {
        return this.getValuesForAttributPosition(this.getAttributPositionByAttributName(pAttributName));
    }

    public String[] getDifferentValuesFromAttributPosition(int pAttributPosition) {
        ArrayList<String> foundValues = new ArrayList<String>();
        try {
            if (this.getRowCount() > 0) {
                String[] attributValues = this.getValuesForAttributPosition(pAttributPosition);
                int i = 1;
                while (i < attributValues.length) {
                    if (!foundValues.contains(attributValues[i])) {
                        foundValues.add(attributValues[i]);
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.INFO, (String)("getDifferentValuesFromAttributPosition: Es wurde wahrscheinlich auf eine ung\u00fcltige Zeilennummer zugegriffen:" + pAttributPosition));
            return null;
        }
        return foundValues.toArray(new String[0]);
    }

    public String[] getDifferentValuesFromAttributName(String pAttributName) {
        return this.getDifferentValuesFromAttributPosition(this.getAttributPositionByAttributName(pAttributName));
    }

    public int getCountOfDifferentValuesFromAttributPosition(int pAttributPosition) {
        return this.getDifferentValuesFromAttributPosition(pAttributPosition).length;
    }

    public int getCountOfDifferentValuesFromAttributName(String pAttributName) {
        int position = this.getAttributPositionByAttributName(pAttributName);
        if (position < 0) {
            return 0;
        }
        return this.getCountOfDifferentValuesFromAttributPosition(this.getAttributPositionByAttributName(pAttributName));
    }

    public Map<String, Integer> getValueCountsForAttributPosition(int pAttributPosition) {
        HashMap<String, Integer> returnMap = null;
        try {
            if (this.getRowCount() > 0) {
                returnMap = new HashMap<String, Integer>();
                String[] attributValues = this.getValuesForAttributPosition(pAttributPosition);
                int i = 0;
                while (i < attributValues.length) {
                    if (i != 0) {
                        String foundValue = attributValues[i];
                        if (returnMap.containsKey(foundValue)) {
                            int newCount = (Integer)returnMap.get(foundValue) + 1;
                            returnMap.put(foundValue, newCount);
                        } else {
                            returnMap.put(foundValue, 1);
                        }
                    }
                    ++i;
                }
            }
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.INFO, (String)("getValuesForAttributPosition: Es wurde wahrscheinlich versucht auf eine falsche Spalte zuzugreifen:" + pAttributPosition));
            return null;
        }
        return returnMap;
    }

    public Map<String, Integer> getValueCountsForAttributName(String pAttributName) {
        return this.getValueCountsForAttributPosition(this.getAttributPositionByAttributName(pAttributName));
    }

    public String getValueFromIndex(int pRow, int pColumn) {
        if (pRow < this._table.size() && pColumn < this._table.get(0).size() && pColumn >= 0 && pRow >= 0) {
            Logger.log((LogLevel)LogLevel.DEBUG, (String)("Es soll auf Zeile" + pRow + ";Spalte: " + pColumn + " zugegriffen werden. Es gibt Zeilen: " + this.getRowCount() + ";Spalten:" + this.getColumnCount()));
            return this._table.get(pRow).get(pColumn);
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Es wurde auf einen Platz der Tabelle zugegriffen, den es nicht gibt: Zeile: " + pRow + ";Spalte: " + pColumn));
        return null;
    }

    public String getValueFromRowAndAttributName(int pRow, String pAttributName) {
        return this.getValueFromIndex(pRow, this.getAttributPositionByAttributName(pAttributName));
    }

    public int getRowCount() {
        return this._table.size();
    }

    public int getColumnCount() {
        if (this.getRowCount() == 0) {
            return 0;
        }
        return this._table.get(0).size();
    }

    public String toString() {
        StringBuffer sBuffer = new StringBuffer();
        int i = 0;
        while (i < this._table.size()) {
            StringBuffer cells = new StringBuffer();
            cells.append("Zeile:>" + i + "< ");
            int j = 0;
            while (j < this._table.get(i).size()) {
                cells.append("|" + this._table.get(i).get(j) + ":");
                if (this._table.get(0).get(j).length() > this._table.get(i).get(j).length()) {
                    int k = 0;
                    while (k < this._table.get(0).get(j).length() - this._table.get(i).get(j).length()) {
                        cells.append(" ");
                        ++k;
                    }
                }
                ++j;
            }
            cells.append("\n");
            sBuffer.append(cells.toString());
            ++i;
        }
        return sBuffer.toString();
    }

    public TableData createDuplicateTable() {
        ArrayList<List<String>> duplicateList = new ArrayList<List<String>>();
        int i = 0;
        while (i < this._table.size()) {
            ArrayList<String> duplicateRow = new ArrayList<String>();
            duplicateList.add(duplicateRow);
            int j = 0;
            while (j < this._table.get(i).size()) {
                duplicateRow.add(this._table.get(i).get(j));
                ++j;
            }
            ++i;
        }
        TableData duplicateTable = new TableData();
        duplicateTable.setCompleteTable(duplicateList);
        return duplicateTable;
    }

    public TableData createDublicateTableWithReferecedRows() {
        ArrayList<List<String>> duplicateList = new ArrayList<List<String>>();
        int i = 0;
        while (i < this._table.size()) {
            duplicateList.add(this._table.get(i));
            ++i;
        }
        TableData duplicateTable = new TableData();
        duplicateTable.setCompleteTable(duplicateList);
        return duplicateTable;
    }

    public void setCompleteTable(List<List<String>> pTable) {
        this._table = pTable;
        Logger.log((LogLevel)LogLevel.INFO, (String)Arrays.toString(this.getAttributNames()));
        this._selectedAttribute = this.getAttributNames()[this.getAttributCount() - 1];
        this.updateAllTable(this);
    }

    public List<List<String>> getCompleteTable() {
        return this._table;
    }

    public Object[] getRows() {
        ArrayList<List<String>> rows = new ArrayList<List<String>>();
        for (List<String> row : this._table) {
            rows.add(row);
        }
        if (rows.size() != 0) {
            rows.remove(0);
        }
        return rows.toArray();
    }

    public int getAttributCount() {
        if (this._table.size() == 0) {
            return 0;
        }
        return this._table.get(0).size();
    }

    public void updateLine(int pIndex, List<String> pNewList) {
        int column = 0;
        for (String cell : pNewList) {
            this.internUpdateCellValueFromIndex(pIndex, column, cell);
            ++column;
        }
        this.updateAllTable(this);
    }

    public void setSelectedAttribute(String pSelectedAttribute) {
        this._selectedAttribute = pSelectedAttribute;
        this.updateAllTable(this);
    }

    public void setSelectedAttribute() {
        if (this._table.size() == 0) {
            this.setSelectedAttribute(null);
        } else if (this._table.get(0).size() == 0) {
            this.setSelectedAttribute(null);
        } else {
            this.setSelectedAttribute(this._table.get(0).get(this._table.get(0).size() - 1));
        }
    }

    public String getSelectedAttribute() {
        return this._selectedAttribute;
    }

    public Document toXML() {
        Document document = DocumentHelper.createDocument();
        Element root = document.addElement("table");
        int i = 0;
        while (i < this._table.size()) {
            String cellName;
            String rowName;
            if (i == 0) {
                rowName = "head";
                cellName = "attribute";
            } else {
                rowName = "row";
                cellName = "cell";
            }
            Element row = root.addElement(rowName);
            int j = 0;
            while (j < this._table.get(i).size()) {
                Element cell = row.addElement(cellName);
                cell.addText(this._table.get(i).get(j));
                ++j;
            }
            ++i;
        }
        return document;
    }
}

