/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.dataStructure;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.util.HashMap;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DecisionTreeNode
extends TreeNode {
    private TableData _sourceTable = null;
    private String _targetAttribute = null;
    private String _ownAttribute = null;
    private int _elementCountToTerminate = 1;

    public DecisionTreeNode(TableData pSourceTable, String pOwnAttribute, String pTargetAttribute, int pElementCountToTerminate) {
        this._sourceTable = pSourceTable;
        this.setTargetAttribute(pTargetAttribute);
        this.setOwnAttribute(pOwnAttribute);
        this._elementCountToTerminate = pElementCountToTerminate;
    }

    public DecisionTreeNode(Document pXMLDoc) {
        Element root = pXMLDoc.getRootElement();
        if (root.getName().equals("decisionTree")) {
            Document tableDocument = DocumentHelper.createDocument();
            tableDocument.add(root.element("sourceTable").createCopy());
            this._sourceTable = new TableData(tableDocument);
            this.setTargetAttribute(root.element("targetAttribute").getText());
            this._sourceTable.setSelectedAttribute(this._targetAttribute);
            this.setOwnAttribute(root.element("ownAttribute").getText());
            this._elementCountToTerminate = Integer.parseInt(root.element("elementCountToTerminate").getText());
        }
        this.addChilds(pXMLDoc);
    }

    public void addChilds(Document pXMLDoc) {
        Element root = pXMLDoc.getRootElement();
        for (Element child : root.elements("node")) {
            Document childDocument = DocumentHelper.createDocument();
            childDocument.add(child.createCopy());
            String parentPath = child.element("parentPathName").getText();
            String ownAttribut = child.element("ownAttribute").getText();
            if (!this.isChildValid(parentPath, ownAttribut)) continue;
            this.addChild(parentPath, ownAttribut);
            ((DecisionTreeNode)this._childs.get(parentPath)).addChilds(childDocument);
        }
    }

    private TableData createNewChildTable(String pHoldAttributValue) {
        TableData childTable = this._sourceTable.createDublicateTableWithReferecedRows();
        int i = childTable.getRowCount() - 1;
        while (i > 0) {
            if (!pHoldAttributValue.equals(childTable.getValueFromRowAndAttributName(i, this._ownAttribute))) {
                childTable.deleteRow(i);
            }
            --i;
        }
        return childTable;
    }

    private boolean isChildValid(String pAttributValue, String pChildOwnAttribut) {
        boolean condition5;
        boolean condition1 = this._sourceTable.attributContainsValue(this._ownAttribute, pAttributValue);
        boolean condition2 = pChildOwnAttribut.equals(this._targetAttribute) || !pChildOwnAttribut.equals(this._ownAttribute);
        boolean condition3 = pChildOwnAttribut.equals(this._targetAttribute) || this._sourceTable.containsAttribut(pChildOwnAttribut);
        boolean condition4 = pChildOwnAttribut.equals(this._targetAttribute) || this.createNewChildTable(pAttributValue).getCountOfDifferentValuesFromAttributName(pChildOwnAttribut) > 1;
        boolean bl = condition5 = !this._ownAttribute.equals(this._targetAttribute);
        return condition1 && condition2 && condition3 && condition4 && condition5;
    }

    public void addChild(String pAttributValue, String pChildOwnAttribut) {
        if (this.isChildValid(pAttributValue, pChildOwnAttribut)) {
            DecisionTreeNode child = new DecisionTreeNode(this.createNewChildTable(pAttributValue), pChildOwnAttribut, this._targetAttribute, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
            super.addChild(pAttributValue, child);
        }
    }

    private boolean canTerminateGeneratingOptimizedTree() {
        boolean condition3;
        boolean condition1 = true;
        String[] stringArray = this._sourceTable.getAttributNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String attribute = stringArray[n2];
            if (!attribute.equals(this._targetAttribute) && this._sourceTable.getCountOfDifferentValuesFromAttributName(attribute) > 1) {
                condition1 = false;
            }
            ++n2;
        }
        boolean condition2 = this.getCountOfElements() <= this._elementCountToTerminate;
        boolean bl = condition3 = this._sourceTable.getCountOfDifferentValuesFromAttributName(this._targetAttribute) == 1;
        return condition1 || condition2 || condition3;
    }

    public int getCountOfElements() {
        return this._sourceTable.getRowCount() - 1;
    }

    public double calculateEntropy() {
        double entropy = 0.0;
        Map<String, Integer> countsOfDifferentTargetValues = this._sourceTable.getValueCountsForAttributName(this._targetAttribute);
        for (String attributValue : countsOfDifferentTargetValues.keySet()) {
            double x = countsOfDifferentTargetValues.get(attributValue).intValue();
            double y = this.getCountOfElements();
            double partOfEntropy = -(x / y) * (Math.log(x / y) / Math.log(2.0));
            entropy += partOfEntropy;
        }
        return entropy;
    }

    public double calculateWeightedEntropy() {
        double weightedEntropy = 0.0;
        for (String attributValue : this._childs.keySet()) {
            DecisionTreeNode child = (DecisionTreeNode)this._childs.get(attributValue);
            double x = child.getCountOfElements();
            double y = this.getCountOfElements();
            double z = child.calculateEntropy();
            double partOfWeightedEntropy = x / y * z;
            weightedEntropy += partOfWeightedEntropy;
        }
        return weightedEntropy;
    }

    public void generateOptimizedTree() {
        DecisionTreeNode smallestNode = null;
        if (!this.canTerminateGeneratingOptimizedTree()) {
            String[] stringArray = this._sourceTable.getAttributNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribut = stringArray[n2];
                if (!attribut.equals(this._targetAttribute) && this._sourceTable.getCountOfDifferentValuesFromAttributName(attribut) > 1) {
                    DecisionTreeNode actualNode = new DecisionTreeNode(this._sourceTable, attribut, this._targetAttribute, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
                    if (smallestNode == null) {
                        smallestNode = actualNode;
                    } else if (actualNode.calculateWeightedEntropy() < smallestNode.calculateWeightedEntropy()) {
                        smallestNode = actualNode;
                    }
                }
                ++n2;
            }
            this.setOwnAttribute(smallestNode.getOwnAttribute());
            if (!this._ownAttribute.equals(this._targetAttribute)) {
                for (String attribute : this._childs.keySet()) {
                    ((DecisionTreeNode)this._childs.get(attribute)).generateOptimizedTree();
                }
            }
        } else {
            this.setOwnAttribute(this._targetAttribute);
        }
    }

    public TableData getSourceTable() {
        return this._sourceTable;
    }

    public String getTargetAttribute() {
        return this._targetAttribute;
    }

    public void setTargetAttribute(String pTargetAttribute) {
        this._targetAttribute = pTargetAttribute;
    }

    public String getOwnAttribute() {
        return this._ownAttribute;
    }

    public void setOwnAttribute(String pOwnAttribute) {
        int n;
        int n2;
        String[] stringArray;
        if (pOwnAttribute == null) {
            stringArray = this._sourceTable.getAttributNames();
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String attribut = stringArray[n];
                if (!attribut.equals(this._targetAttribute)) {
                    pOwnAttribute = attribut;
                    break;
                }
                ++n;
            }
        }
        this._ownAttribute = pOwnAttribute;
        this.setNodeName(this._ownAttribute);
        this._childs = new HashMap();
        if (!this._ownAttribute.equals(this._targetAttribute)) {
            Logger.log((LogLevel)LogLevel.INFO, (String)this._sourceTable.toString());
            stringArray = this._sourceTable.getDifferentValuesFromAttributName(this._ownAttribute);
            n2 = stringArray.length;
            n = 0;
            while (n < n2) {
                String attributValue = stringArray[n];
                this.addChild(attributValue, this._targetAttribute);
                ++n;
            }
        } else {
            this.updatetAllTree(this);
        }
    }

    public int getElementCountToTerminate() {
        return this._elementCountToTerminate;
    }

    @Override
    public Document toXML() {
        Document document = super.toXML();
        Element root = document.getRootElement();
        if (this.isRoot()) {
            root.setName("decisionTree");
        }
        Element ownAttribut = root.addElement("ownAttribute");
        ownAttribut.addText(this._ownAttribute);
        if (this.isRoot()) {
            Element sourceTable = this.getSourceTable().toXML().getRootElement();
            sourceTable.setName("sourceTable");
            root.add(sourceTable);
            Element targetAttribut = root.addElement("targetAttribute");
            targetAttribut.addText(this._targetAttribute);
            Element elementCountToTerminate = root.addElement("elementCountToTerminate");
            elementCountToTerminate.addText("" + this._elementCountToTerminate);
        }
        return document;
    }
}

