/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.controller.connectors;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.controller.connectors.FileType;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import weka.core.Attribute;
import weka.core.Instances;
import weka.core.converters.ConverterUtils;

public abstract class TableFileConnector {
    public static TableData readTableFile(File pFile) {
        return TableFileConnector.readTableFile(pFile, FileType.getFileType(pFile));
    }

    public static TableData readTableFile(File pFile, FileType fileType) {
        if (!pFile.exists() || pFile.getName().equals("")) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Die Datei: " + pFile + " existiert nicht"));
            return null;
        }
        if (fileType == FileType.CSV) {
            return TableFileConnector.readCsvFormat(pFile);
        }
        if (fileType == FileType.ARFF) {
            return TableFileConnector.readArffFormat(pFile);
        }
        if (fileType == FileType.XLS) {
            return TableFileConnector.readExcelFormat(pFile, true);
        }
        if (fileType == FileType.XLSX) {
            return TableFileConnector.readExcelFormat(pFile, false);
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Das angegbene Format konnte nicht verarbeitet werden: " + (Object)((Object)fileType)));
        return null;
    }

    private static TableData readExcelFormat(File pFile, boolean isOldFormat) {
        try {
            FileInputStream fis = new FileInputStream(pFile);
            if (isOldFormat) {
                HSSFWorkbook xlsWorkbook = new HSSFWorkbook((InputStream)fis);
                HSSFSheet sheet = xlsWorkbook.getSheetAt(0);
                return TableFileConnector.buildTableDataFromSheet((Sheet)sheet);
            }
            XSSFWorkbook xlsxWorkbook = new XSSFWorkbook((InputStream)fis);
            XSSFSheet sheet = xlsxWorkbook.getSheetAt(0);
            return TableFileConnector.buildTableDataFromSheet((Sheet)sheet);
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Konnte das Excel Format nicht lesen! " + pFile + "Altes Format:" + isOldFormat));
            e.printStackTrace();
            return null;
        }
    }

    private static TableData buildTableDataFromSheet(Sheet pSheet) {
        TableData tableData = new TableData();
        ArrayList<List<String>> rowList = new ArrayList<List<String>>();
        int i = 0;
        while (i <= pSheet.getLastRowNum()) {
            ArrayList<String> cellList = new ArrayList<String>();
            int j = 0;
            while (j < pSheet.getRow(i).getLastCellNum()) {
                if (pSheet.getRow(i).getCell(j) == null) {
                    Logger.log((LogLevel)LogLevel.ERROR, (String)"Die Tabelle besitzt nicht-ausgef\u00fcllte Zellen!");
                    return null;
                }
                String cellValue = pSheet.getRow(i).getCell(j).getStringCellValue();
                if (cellValue == null) {
                    return null;
                }
                cellList.add(cellValue);
                ++j;
            }
            rowList.add(cellList);
            ++i;
        }
        tableData.setCompleteTable(rowList);
        Logger.log((LogLevel)LogLevel.INFO, (String)("Habe insgesamt: " + rowList.size() + " Zeilen ausgelesen"));
        return tableData;
    }

    private static TableData readCsvFormat(File pFile) {
        String separator = ConfigConstants.CSV_SEPERATOR;
        Logger.log((LogLevel)LogLevel.DEBUG, (String)("Es wurde das Zeichen f\u00fcr das Separieren gesetzt: >" + separator + "<"));
        TableData tableData = new TableData();
        int rowCount = 0;
        if (pFile.exists()) {
            try {
                String tempLine;
                BufferedReader br = new BufferedReader(new FileReader(pFile));
                ArrayList<List<String>> rowList = new ArrayList<List<String>>();
                while ((tempLine = br.readLine()) != null && !tempLine.equals("")) {
                    Logger.log((LogLevel)LogLevel.DEBUG, (String)("Lese in Zeile: >" + rowCount + "< Habe diese Zellen gefunden: " + tempLine.split(separator).length));
                    ArrayList<String> cellList = new ArrayList<String>();
                    int i = 0;
                    while (i < tempLine.split(separator).length) {
                        cellList.add(tempLine.split(separator)[i]);
                        ++i;
                    }
                    rowList.add(cellList);
                    ++rowCount;
                }
                tableData.setCompleteTable(rowList);
                return tableData;
            }
            catch (Exception e) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Konnte die CSV-Datei nicht lesen von: " + pFile));
                e.printStackTrace();
                return null;
            }
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Die CSV-Datei wurde nicht gefunden: " + pFile));
        return null;
    }

    private static TableData readArffFormat(File pFile) {
        TableData tableData = new TableData();
        if (pFile.exists()) {
            try {
                ArrayList<List<String>> rowList = new ArrayList<List<String>>();
                ConverterUtils.DataSource source = new ConverterUtils.DataSource(pFile.getPath());
                Instances data = source.getDataSet();
                if (data.classIndex() == -1) {
                    data.setClassIndex(data.numAttributes() - 1);
                }
                ArrayList<String> attributes = new ArrayList<String>();
                int j = 0;
                while (j < data.numAttributes()) {
                    attributes.add(data.attribute(j).name());
                    ++j;
                }
                rowList.add(attributes);
                int i = 0;
                while (i < data.numInstances()) {
                    ArrayList<String> cellList = new ArrayList<String>();
                    int j2 = 0;
                    while (j2 < data.numAttributes()) {
                        cellList.add(data.instance(i).toString(j2));
                        ++j2;
                    }
                    rowList.add(cellList);
                    ++i;
                }
                tableData.setCompleteTable(rowList);
                return tableData;
            }
            catch (Exception e) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Konnte die ARFF-Datei nicht lesen von: " + pFile));
                e.printStackTrace();
                return null;
            }
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Die ARFF-Datei wurde nicht gefunden: " + pFile));
        return null;
    }

    public static boolean writeTableFile(File pFile, TableData pTableData) {
        return TableFileConnector.writeTableFile(pFile, FileType.getFileType(pFile), pTableData);
    }

    public static boolean writeTableFile(File pFile, FileType pFileType, TableData pTableData) {
        if (pFileType == FileType.CSV) {
            return TableFileConnector.writeCSVFile(pFile, pTableData);
        }
        if (pFileType == FileType.ARFF) {
            return TableFileConnector.writeArffFile(pFile, pTableData);
        }
        if (pFileType == FileType.XLS) {
            return TableFileConnector.writeExcelFile(pFile, true, pTableData);
        }
        if (pFileType == FileType.XLSX) {
            return TableFileConnector.writeExcelFile(pFile, false, pTableData);
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Das angegbene Format konnte f\u00fcr den Export nicht verarbeitet werden: " + (Object)((Object)pFileType)));
        return false;
    }

    private static boolean writeExcelFile(File pFile, boolean isOldFileFormat, TableData pTableData) {
        if (pFile == null || pTableData == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"writeExcelFile: Ein Parameter war null");
            return false;
        }
        if (isOldFileFormat) {
            HSSFWorkbook xlsWorkbook = new HSSFWorkbook();
            HSSFSheet sheet = xlsWorkbook.createSheet();
            int i = 0;
            while (i < pTableData.getRowCount()) {
                HSSFRow tempRow = sheet.createRow(i);
                int j = 0;
                while (j < pTableData.getColumnCount()) {
                    HSSFCell tempCell = tempRow.createCell(j);
                    tempCell.setCellValue(pTableData.getValueFromIndex(i, j));
                    ++j;
                }
                ++i;
            }
            try {
                FileOutputStream out = new FileOutputStream(pFile);
                xlsWorkbook.write((OutputStream)out);
            }
            catch (IOException e) {
                e.printStackTrace();
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Fehler beim Schreiben des alten Excel Formats in die Datei: " + pFile));
                return false;
            }
            return true;
        }
        XSSFWorkbook xlsxWorkbook = new XSSFWorkbook();
        XSSFSheet sheet = xlsxWorkbook.createSheet();
        int i = 0;
        while (i < pTableData.getRowCount()) {
            XSSFRow tempRow = sheet.createRow(i);
            int j = 0;
            while (j < pTableData.getColumnCount()) {
                XSSFCell tempCell = tempRow.createCell(j);
                tempCell.setCellValue(pTableData.getValueFromIndex(i, j));
                ++j;
            }
            ++i;
        }
        try {
            FileOutputStream out = new FileOutputStream(pFile);
            xlsxWorkbook.write((OutputStream)out);
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Fehler beim Schreiben des neuen Excel Formats in die Datei: " + pFile));
            return false;
        }
        return true;
    }

    private static boolean writeCSVFile(File pFile, TableData pTableData) {
        if (pFile == null || pTableData == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"writeCSVFile: Ein Parameter war null");
            return false;
        }
        String separator = ConfigConstants.CSV_SEPERATOR;
        Logger.log((LogLevel)LogLevel.DEBUG, (String)("Es wurde das Zeichen f\u00fcr das Separieren gesetzt: >" + separator + "<"));
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(pFile, false), true);
            if (pTableData.getRowCount() > 0) {
                int i = 0;
                while (i < pTableData.getRowCount()) {
                    StringBuffer rowAsString = new StringBuffer();
                    int j = 0;
                    while (j < pTableData.getColumnCount()) {
                        rowAsString.append(pTableData.getValueFromIndex(i, j));
                        if (j != pTableData.getColumnCount() - 1) {
                            rowAsString.append(separator);
                        }
                        ++j;
                    }
                    pw.println(rowAsString.toString());
                    Logger.log((LogLevel)LogLevel.DEBUG, (String)("Schreibe Zeile " + i + " des CSV Files"));
                    ++i;
                }
            }
            pw.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Die Datei konnte nicht geschrieben werden: " + pFile));
            return false;
        }
    }

    private static boolean writeArffFile(File pFile, TableData pTableData) {
        if (pFile == null || pTableData == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"writeARFFFile: Ein Parameter war null");
            return false;
        }
        try {
            PrintWriter pw = new PrintWriter((Writer)new FileWriter(pFile, false), true);
            ArrayList<Attribute> atts = new ArrayList<Attribute>();
            String[] stringArray = pTableData.getAttributNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                atts.add(new Attribute(attribute, null));
                ++n2;
            }
            Instances data = new Instances(pFile.getName(), atts, 0);
            pw.print(data);
            int row = 1;
            while (row < pTableData.getRowCount()) {
                String vals = "";
                int column = 0;
                while (column < pTableData.getColumnCount()) {
                    if (column > 0) {
                        vals = String.valueOf(vals) + ",";
                    }
                    vals = String.valueOf(vals) + pTableData.getValueFromIndex(row, column);
                    ++column;
                }
                pw.println(vals);
                ++row;
            }
            pw.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Die Datei konnte nicht geschrieben werden: " + pFile));
            return false;
        }
    }
}

