/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.controller.connectors;

import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.io.File;

public enum FileType {
    XLS("xls"),
    XLSX("xlsx"),
    CSV("csv"),
    ARFF("arff"),
    XML("xml"),
    JPEG("jpg"),
    PNG("png"),
    SVG("svg");

    String _name = "";

    private FileType(String pName) {
        this._name = pName;
    }

    public String toString() {
        return this._name;
    }

    public static FileType getFileType(File pFile) {
        if (pFile == null || pFile.getName().trim().equals("")) {
            Logger.log((LogLevel)LogLevel.INFO, (String)"getTableFileType: Es wurde keine Datei \u00fcbergeben");
            return null;
        }
        String[] splitName = pFile.getName().split("\\.");
        if (splitName.length > 1) {
            String extension = splitName[splitName.length - 1];
            if (extension.equals(XLS.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das XLS Format erkannt");
                return XLS;
            }
            if (extension.equals(XLSX.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das XLSX Format erkannt");
                return XLSX;
            }
            if (extension.equals(CSV.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das CSV Format erkannt");
                return CSV;
            }
            if (extension.equals(ARFF.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das ARFF Format erkannt");
                return ARFF;
            }
            if (extension.equals(XML.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das XML Format erkannt");
                return XML;
            }
            if (extension.equals(JPEG.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das JPEG Format erkannt");
                return JPEG;
            }
            if (extension.equals(PNG.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das PNG Format erkannt");
                return PNG;
            }
            if (extension.equals(SVG.toString())) {
                Logger.log((LogLevel)LogLevel.DEBUG, (String)"Habe das SVG Format erkannt");
                return SVG;
            }
            Logger.log((LogLevel)LogLevel.INFO, (String)("Es konnte nicht festgestellt werden um welches Format es sich handelt: " + pFile));
            return null;
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Es konnte nicht festgestellt werden um welches Format es sich handelt, es wurde keine Endung festgestellt: " + pFile));
        return null;
    }
}

