/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.controller;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.controller.connectors.FileType;
import de.hwrBerlin.dataMining.controller.connectors.TableFileConnector;
import de.hwrBerlin.dataMining.controller.connectors.TreeFileReaderWriter;
import de.hwrBerlin.dataMining.controller.observer.Observer;
import de.hwrBerlin.dataMining.dataStructure.DecisionTreeNode;
import de.hwrBerlin.dataMining.dataStructure.Model;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.dataMining.dataStructure.TreeNode;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class Controller
implements Observer {
    private Model _model;

    public Controller(Model pModel) {
        this._model = pModel;
        this._model.addObserver(this);
    }

    public boolean loadTable(String pPath) {
        Logger.log((LogLevel)LogLevel.DEBUG, (String)("loadTable: \u00dcbergebener Pfad:" + pPath));
        if (pPath != null) {
            TableData tData = TableFileConnector.readTableFile(new File(pPath));
            return this.loadTable(tData);
        }
        return false;
    }

    public boolean loadTable(TableData pTable) {
        Logger.log((LogLevel)LogLevel.DEBUG, (String)"loadTable");
        if (pTable != null) {
            if (!this.isTableValid(pTable, true)) {
                return false;
            }
            this._model.setTable(pTable);
            DecisionTreeNode automaticTreeNode = null;
            DecisionTreeNode interactiveTreeNode = null;
            if (pTable != null && pTable.getColumnCount() != 0) {
                String targetAttribut = pTable.getSelectedAttribute();
                automaticTreeNode = new DecisionTreeNode(pTable, targetAttribut, targetAttribut, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
                automaticTreeNode.generateOptimizedTree();
                interactiveTreeNode = new DecisionTreeNode(pTable, targetAttribut, targetAttribut, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
            }
            this._model.setAutomaticTree(automaticTreeNode);
            this._model.setInteractiveTree(interactiveTreeNode);
            return true;
        }
        return false;
    }

    public boolean saveTable(String pPath) {
        Logger.log((LogLevel)LogLevel.DEBUG, (String)("saveTable: \u00dcbergebener Pfad:" + pPath));
        if (pPath != null && !pPath.equals("")) {
            TableFileConnector.writeTableFile(new File(pPath), this._model.getTable());
            return true;
        }
        return false;
    }

    public boolean saveTree(DecisionTreeNode pTree, String pPath) {
        if (this._model.getInteractiveTree() != null && pPath != null && !pPath.equals("")) {
            File file = new File(pPath);
            FileType fileType = FileType.getFileType(file);
            if (fileType == FileType.JPEG || fileType == FileType.PNG) {
                TreeFileReaderWriter.writeTreeToImageFile(pTree, new File(pPath));
                return true;
            }
            if (fileType == FileType.SVG) {
                TreeFileReaderWriter.writeTreeToSVGFile(pTree, new File(pPath));
                return true;
            }
            if (fileType != FileType.XML) {
                pPath = String.valueOf(pPath) + ".xml";
            }
            TreeFileReaderWriter.writeTreeToTextFile(pTree, new File(pPath));
            return true;
        }
        return false;
    }

    public boolean saveInteractiveTree(String pPath) {
        return this.saveTree((DecisionTreeNode)this._model.getInteractiveTree(), pPath);
    }

    public boolean saveAutomaticTree(String pPath) {
        return this.saveTree((DecisionTreeNode)this._model.getAutomaticTree(), pPath);
    }

    public boolean openInteractiveTree(String pPath) {
        if (pPath != null && !pPath.equals("")) {
            DecisionTreeNode tree = TreeFileReaderWriter.getDecisionTreeFromFile(new File(pPath));
            return this.openInteractiveTree(tree);
        }
        return false;
    }

    public boolean openInteractiveTree(DecisionTreeNode pTree) {
        if (pTree != null) {
            TableData table = pTree.getSourceTable();
            if (!this.isTableValid(table, true)) {
                return false;
            }
            this._model.setTable(table);
            this._model.setInteractiveTree(pTree);
            return true;
        }
        return false;
    }

    public void addObserverToModel(Observer pObserver) {
        this._model.addObserver(pObserver);
    }

    public void removeObserverToModel(Observer pObserver) {
        this._model.removeObserver(pObserver);
    }

    public Model getModel() {
        return this._model;
    }

    public boolean addLineToTable(List<String> pNewList) {
        for (String value : pNewList) {
            if (!value.equals("")) continue;
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Kein Wert eines Datensatzes darf leer sein");
            return false;
        }
        this._model.getTable().addRowToEnd(pNewList);
        return true;
    }

    public void removeLine(int pI) {
        this._model.getTable().deleteRow(pI + 1);
    }

    public boolean updateLineInTable(int pIndex, List<String> pNewList) {
        for (String value : pNewList) {
            if (!value.equals("")) continue;
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Kein Wert eines Datensatzes darf leer sein!");
            return false;
        }
        this._model.getTable().updateLine(pIndex, pNewList);
        return true;
    }

    public boolean addAttribute(String pName, String pDefaultValue) {
        if (pName.equals("")) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Attributname darf nicht leer sein!");
            return false;
        }
        if (this._model.getTable().getRowCount() > 1 && pDefaultValue.equals("")) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Die Standardwert des Attributes darf nicht leer sein, wenn schon Datens\u00e4tze existieren!");
            return false;
        }
        if (this._model.getTable().containsAttribut(pName)) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Das Attribut \"" + pName + "\" existiert bereits."));
            return false;
        }
        ArrayList<String> input = new ArrayList<String>();
        input.add(pName);
        int i = 1;
        while (i < this._model.getTable().getRowCount()) {
            input.add(pDefaultValue);
            ++i;
        }
        this._model.getTable().addColumnToEnd(input);
        return true;
    }

    public void removeAtrribute(String pName) {
        this._model.getTable().deleteColumnByName(pName);
    }

    public boolean editAtrribute(int pIndex, String pName) {
        if (!this._model.getTable().getValueFromIndex(0, pIndex).equals(pName) && this._model.getTable().containsAttribut(pName)) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Es existiert bereits ein Attribut mit dem selben Namen!");
            return false;
        }
        this._model.getTable().updateCellValueFromIndex(0, pIndex, pName);
        return true;
    }

    public void setTargetAttribute(String pSelection) {
        this._model.getTable().setSelectedAttribute(pSelection);
    }

    @Override
    public void updateAllTable(TableData pTableData) {
        DecisionTreeNode automatcTreeNode = null;
        DecisionTreeNode interactiveTreeNode = null;
        if (this.isTableTreeable(pTableData)) {
            if (pTableData.getSelectedAttribute() == null) {
                pTableData.setSelectedAttribute();
            }
            String targetAttribut = pTableData.getSelectedAttribute();
            automatcTreeNode = new DecisionTreeNode(pTableData, targetAttribut, targetAttribut, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
            automatcTreeNode.generateOptimizedTree();
            interactiveTreeNode = new DecisionTreeNode(pTableData, targetAttribut, targetAttribut, ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
        }
        this._model.setAutomaticTree(automatcTreeNode);
        this._model.setInteractiveTree(interactiveTreeNode);
    }

    @Override
    public void updateTree(TreeNode pTree) {
    }

    @Override
    public void updateAllInteractiveTree(TreeNode pTree) {
    }

    @Override
    public void updateAllAutomaticTree(TreeNode pTree) {
    }

    public void updateTrees() {
        if (this._model.getAutomaticTree() != null) {
            this._model.getAutomaticTree().update();
            this._model.getInteractiveTree().update();
        }
    }

    public boolean isTableTreeable() {
        return this.isTableTreeable(this._model.getTable());
    }

    public boolean isTableValid(TableData pTable, boolean pLogError) {
        if (pTable == null) {
            if (pLogError) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)"Tabelle ist NULL!");
            }
            return false;
        }
        if (pTable.getRowCount() - 1 > ConfigConstants.MAX_ROWS) {
            if (pLogError) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Tabelle hat zu viele Datens\u00e4tze! (hat " + (pTable.getRowCount() - 1) + "; darf " + ConfigConstants.MAX_ROWS + ")"));
            }
            return false;
        }
        if (pTable.getColumnCount() > ConfigConstants.MAX_ATTRIBUTES) {
            if (pLogError) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Tabelle hat zu viele Attribute! (hat " + pTable.getColumnCount() + "; darf " + ConfigConstants.MAX_ATTRIBUTES + ")"));
            }
            return false;
        }
        if (pTable.contains("")) {
            if (pLogError) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)"Tabelle enth\u00e4lt leere Zellen!");
            }
            return false;
        }
        ArrayList<String> catchedAttributes = new ArrayList<String>();
        String[] stringArray = pTable.getAttributNames();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            if (catchedAttributes.contains(value)) {
                if (pLogError) {
                    Logger.log((LogLevel)LogLevel.ERROR, (String)"Tabelle hat doppelte Attribute!");
                }
                return false;
            }
            catchedAttributes.add(value);
            ++n2;
        }
        return true;
    }

    public boolean isTableTreeable(TableData pTableData) {
        if (!this.isTableValid(pTableData, false)) {
            return false;
        }
        return pTableData.getColumnCount() >= 1 && pTableData.getRowCount() >= 2;
    }
}

