/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.widgets.combo;

import de.hwrBerlin.dataMining.view.widgets.combo.ComboShower;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;

public class ExtendedComboBox {
    private Combo _combo;
    private List<Object> _items;
    private ComboShower _shower;
    private boolean _nullSelection;

    public ExtendedComboBox(Composite pParent, int pStyle, boolean pNullSelection, ComboShower pComboShower) {
        this._nullSelection = pNullSelection;
        this._combo = new Combo(pParent, pStyle);
        this._items = new ArrayList<Object>();
        this._shower = pComboShower;
    }

    public ExtendedComboBox(Composite pParent, int pStyle, boolean pNullSelection) {
        this._nullSelection = pNullSelection;
        this._combo = new Combo(pParent, pStyle);
        this._items = new ArrayList<Object>();
        this._shower = new ComboShower(){

            @Override
            public String getStringFromObject(Object pObject) {
                return pObject.toString();
            }
        };
    }

    public void setInput(Object[] pItems) {
        this._items = new ArrayList<Object>();
        Object[] objectArray = pItems;
        int n = pItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            this._items.add(object);
            ++n2;
        }
        this._combo.removeAll();
        this.sortList();
        for (Object item : this._items) {
            String itemString = this._shower.getStringFromObject(item);
            this._combo.add(itemString);
        }
        if (this._nullSelection) {
            this._combo.add("[Keine Auswahl]");
        }
        this._combo.redraw();
    }

    public void remove(Object pObject) {
        if (pObject != null && this._items.contains(pObject)) {
            int removeIndex = this._items.indexOf(pObject);
            this._items.remove(pObject);
            this._combo.remove(removeIndex);
        }
    }

    public void add(Object pObject) {
        this._items.add(pObject);
        this.sortList();
        this._combo.add(this._shower.getStringFromObject(pObject));
    }

    public Object getSelection() {
        int selectionIndex = this._combo.getSelectionIndex();
        if (selectionIndex == -1) {
            return null;
        }
        if (selectionIndex >= this._items.size()) {
            return null;
        }
        return this._items.get(selectionIndex);
    }

    public void setSetlection(Object pObject) {
        int selectionIndex = this._items.indexOf(pObject);
        this._combo.select(selectionIndex);
    }

    public void addSelectionListener(SelectionListener pSelectionListener) {
        this._combo.addSelectionListener(pSelectionListener);
    }

    public void removeSelectionListener(SelectionListener pSelectionListener) {
        this._combo.removeSelectionListener(pSelectionListener);
    }

    public void redraw() {
        this.setInput(this._items.toArray(new Object[0]));
    }

    private void sortList() {
        ArrayList<Object> sortedList = new ArrayList<Object>();
        while (this._items.size() != 0) {
            Object smallestItem = null;
            for (Object item : this._items) {
                if (smallestItem == null) {
                    smallestItem = item;
                    continue;
                }
                if (this._shower.getStringFromObject(smallestItem).compareTo(this._shower.getStringFromObject(item)) <= 0) continue;
                smallestItem = item;
            }
            this._items.remove(smallestItem);
            sortedList.add(smallestItem);
        }
        this._items = sortedList;
    }

    public void setLayoutData(Object pLayoutData) {
        this._combo.setLayoutData(pLayoutData);
    }

    public Combo getCombo() {
        return this._combo;
    }
}

