/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.vImage.figures;

import de.hwrBerlin.dataMining.view.vImage.figures.FilledFigure;
import org.dom4j.Document;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class Text
extends FilledFigure {
    public String text = "";
    private String _fontName;
    private int _fontSize;

    public Text(String pText, int pX, int pY) {
        this.x = pX;
        this.y = pY;
        this.text = pText;
    }

    @Override
    public void paintImage(GC pGc) {
        this.setValuesToGc(pGc);
        pGc.drawText(this.text, this.x, this.y);
    }

    @Override
    public Rectangle getBounds() {
        return new Rectangle(0, 0, this._fontSize, this._fontSize * this.text.length());
    }

    @Override
    public void paintSVG(Document pDocument) {
        Element root = pDocument.getRootElement();
        Element oval = root.addElement("text");
        this.setValuesToSVGElement(oval);
        oval.addAttribute("x", "" + this.x);
        oval.addAttribute("y", "" + (this.y + this._fontSize));
        oval.addText(this.text);
    }

    @Override
    protected void setValuesToGc(GC pGc) {
        super.setValuesToGc(pGc);
        pGc.getFont().dispose();
        pGc.setFont(new Font(null, this._fontName, this._fontSize, 0));
    }

    @Override
    protected void setValuesToSVGElement(Element pElement) {
        String value = "";
        value = String.valueOf(value) + "fill:#" + this.colorToHex(this._foreground) + ";";
        value = String.valueOf(value) + "font-family:" + this._fontName + ", sans-serif;";
        value = String.valueOf(value) + "font-size:" + this._fontSize + "px;";
        pElement.addAttribute("style", value);
    }

    public void setFontName(String pFontName) {
        this._fontName = pFontName;
    }

    public String getFontName() {
        return this._fontName;
    }

    public void setFontSize(int pFontSize) {
        this._fontSize = pFontSize;
    }

    public int getFontSize() {
        return this._fontSize;
    }
}

