/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.vImage;

import de.hwrBerlin.dataMining.view.vImage.figures.Figure;
import de.hwrBerlin.dataMining.view.vImage.figures.Line;
import de.hwrBerlin.dataMining.view.vImage.figures.Oval;
import de.hwrBerlin.dataMining.view.vImage.figures.Rectangle;
import de.hwrBerlin.dataMining.view.vImage.figures.Text;
import java.util.ArrayList;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;

public class VImage {
    ArrayList<Figure> figures = new ArrayList();
    private Device _device = null;
    private int _width = 0;
    private int _height = 0;
    private Color _foreground = null;
    private Color _background = null;
    private int _lineWidth = 1;
    private String _fontName = "Arial";
    private int _fontSize = 5;
    private int _antialias = 1;

    public VImage(Device pDevice, int pWidth, int pHeight) {
        this._device = pDevice;
        this._width = pWidth;
        this._height = pHeight;
    }

    public void paintImage(GC pGc) {
        pGc.setFont(new Font(null, this._fontName, this._fontSize, 0));
        for (Figure figure : this.figures) {
            figure.paintImage(pGc);
        }
    }

    public Image toImage() {
        Image image = new Image(this._device, this._width, this._height);
        GC gc = new GC((Drawable)image);
        this.paintImage(gc);
        return image;
    }

    public void paintSVG(Document pDocument) {
        for (Figure figure : this.figures) {
            figure.paintSVG(pDocument);
        }
    }

    public Document toSVG() {
        Document document = DocumentHelper.createDocument();
        document.addDocType("svg", "-//W3C//DTD SVG 1.1//EN", "http://www.w3.org/Graphics/SVG/1.1/DTD/svg11.dtd");
        Element root = document.addElement("svg", "http://www.w3.org/2000/svg");
        root.addAttribute("width", "" + this._width);
        root.addAttribute("height", "" + this._height);
        this.paintSVG(document);
        return document;
    }

    public void drawLine(int pX1, int pY1, int pX2, int pY2) {
        Line line = new Line(pX1, pY1, pX2, pY2);
        line.setForeground(this._foreground);
        line.setLineWidth(this._lineWidth);
        line.setAntialias(this._antialias);
        this.figures.add(line);
    }

    public void drawRectangle(int pX, int pY, int pWidth, int pHeight) {
        Rectangle ractangle = new Rectangle(pX, pY, pWidth, pHeight);
        ractangle.setForeground(this._foreground);
        ractangle.setBackground(this._background);
        ractangle.setLineWidth(this._lineWidth);
        ractangle.setAntialias(this._antialias);
        this.figures.add(ractangle);
    }

    public void drawOval(int pX, int pY, int pWidth, int pHeight) {
        Oval oval = new Oval(pX, pY, pWidth, pHeight);
        oval.setForeground(this._foreground);
        oval.setBackground(this._background);
        oval.setLineWidth(this._lineWidth);
        oval.setAntialias(this._antialias);
        this.figures.add(oval);
    }

    public void drawText(String pText, int pX, int pY) {
        Text text = new Text(pText, pX, pY);
        text.setForeground(this._foreground);
        text.setBackground(this._background);
        text.setLineWidth(this._lineWidth);
        text.setAntialias(this._antialias);
        text.setFontName(this._fontName);
        text.setFontSize(this._fontSize);
        this.figures.add(text);
    }

    public void setForeground(Color pColor) {
        this._foreground = pColor;
    }

    public Color getForeground() {
        return this._foreground;
    }

    public void setBackground(Color pColor) {
        this._background = pColor;
    }

    public Color getBackground() {
        return this._background;
    }

    public void setLineWidth(int pWidth) {
        this._lineWidth = pWidth;
    }

    public int getLineWidth() {
        return this._lineWidth;
    }

    public void setFontName(String pFontName) {
        this._fontName = pFontName;
    }

    public String getFontName() {
        return this._fontName;
    }

    public void setFontSize(int pFontSize) {
        this._fontSize = pFontSize;
    }

    public int getFontSize() {
        return this._fontSize;
    }

    public void setAntialias(int pAntialias) {
        this._antialias = pAntialias;
    }

    public int getAntialias() {
        return this._antialias;
    }
}

