/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view.dialog;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.constants.Images;
import de.hwrBerlin.dataMining.controller.Controller;
import de.hwrBerlin.dataMining.view.TableView;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;

public class ConfigurationDialog
extends Dialog {
    private int _returnValue = 256;
    private Controller _controller;
    private TableView _tableView;
    private Shell _shell;
    private Display _display;
    private TabFolder _tabFolder;

    public ConfigurationDialog(Shell parent, int style, Controller pController, TableView pTableView) {
        super(parent, style);
        this._controller = pController;
        this._tableView = pTableView;
    }

    public int open() {
        Shell parent = this.getParent();
        this._display = parent.getDisplay();
        this._shell = new Shell(parent, 67696);
        this._shell.setText("Optionen...");
        this._shell.setImages(Images.LOGO_ICONS);
        GridLayout layout = new GridLayout(1, true);
        this._shell.setLayout((Layout)layout);
        GridData dataForRightSide = new GridData(4, 128, true, false);
        dataForRightSide.horizontalSpan = 2;
        dataForRightSide.minimumWidth = 50;
        dataForRightSide.horizontalAlignment = 4;
        dataForRightSide.grabExcessHorizontalSpace = true;
        GridData dataForFarRightSide = new GridData(4, 128, true, false);
        dataForFarRightSide.horizontalSpan = 1;
        dataForFarRightSide.horizontalAlignment = 4;
        dataForFarRightSide.grabExcessHorizontalSpace = true;
        GridData dataForLeftSide = new GridData(4, 128, true, false);
        dataForLeftSide.minimumWidth = 225;
        Button setDefault = new Button((Composite)this._shell, 8);
        setDefault.setText("Standarteinstellungen wiederherstellen");
        setDefault.setLayoutData((Object)new GridData(4, 4, true, true));
        this._tabFolder = new TabFolder((Composite)this._shell, 0);
        this._tabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        TabItem generalConfigGroupItem = new TabItem(this._tabFolder, 0);
        generalConfigGroupItem.setText("Allgemein");
        Composite generalConfigGroup = new Composite((Composite)this._tabFolder, 0);
        generalConfigGroup.setLayout((Layout)new GridLayout(3, false));
        generalConfigGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        generalConfigGroupItem.setControl((Control)generalConfigGroup);
        Label csvSeperatorLabel = new Label(generalConfigGroup, 0);
        csvSeperatorLabel.setText("Trennzeichen f\u00fcr *.csv Dateien:");
        csvSeperatorLabel.setLayoutData((Object)dataForLeftSide);
        final Text csvSeperator = new Text(generalConfigGroup, 2048);
        csvSeperator.setSize(800, 80);
        csvSeperator.setTextLimit(10);
        csvSeperator.setLayoutData((Object)dataForRightSide);
        Label sureToExitLabel = new Label(generalConfigGroup, 0);
        sureToExitLabel.setText("Beim Schlie\u00dfen keine Warnung anzeigen: ");
        sureToExitLabel.setLayoutData((Object)dataForLeftSide);
        final Button sureToExitCheckBox = new Button(generalConfigGroup, 32);
        sureToExitCheckBox.setLayoutData((Object)dataForRightSide);
        sureToExitCheckBox.setSelection(ConfigConstants.SURE_TO_EXIT);
        Label logLevelLabel = new Label(generalConfigGroup, 0);
        logLevelLabel.setText("LOG-Level des Programms (1-3):");
        logLevelLabel.setLayoutData((Object)dataForLeftSide);
        final Text logLevel = new Text(generalConfigGroup, 2048);
        logLevel.setSize(800, 80);
        logLevel.setTextLimit(1);
        logLevel.setText("" + ConfigConstants.LOGLEVEL);
        logLevel.setLayoutData((Object)dataForRightSide);
        TabItem tableGroupItem = new TabItem(this._tabFolder, 0);
        tableGroupItem.setText("Tabellen");
        Composite tableGroup = new Composite((Composite)this._tabFolder, 0);
        tableGroup.setLayout((Layout)new GridLayout(3, false));
        tableGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        tableGroupItem.setControl((Control)tableGroup);
        Label maxAttributeLabel = new Label(tableGroup, 0);
        maxAttributeLabel.setText("Maximale Anzahl an Attributen:");
        maxAttributeLabel.setLayoutData((Object)dataForLeftSide);
        final Text maxAttribute = new Text(tableGroup, 2048);
        maxAttribute.setLayoutData((Object)dataForRightSide);
        Label maxLinesLabel = new Label(tableGroup, 0);
        maxLinesLabel.setText("Maximale Anzahl an Datens\u00e4tzen:");
        maxLinesLabel.setLayoutData((Object)dataForLeftSide);
        final Text maxLines = new Text(tableGroup, 2048);
        maxLines.setLayoutData((Object)dataForRightSide);
        Label targetAttributeColorLabel = new Label(tableGroup, 0);
        targetAttributeColorLabel.setText("Farbe des Zielattributes:");
        targetAttributeColorLabel.setLayoutData((Object)dataForLeftSide);
        final Label targetAttributeColorDemo = new Label(tableGroup, 8);
        targetAttributeColorDemo.setLayoutData((Object)dataForRightSide);
        targetAttributeColorDemo.addMouseListener(this.newMouseListenerForColorDemo(targetAttributeColorDemo));
        TabItem treeGroupItem = new TabItem(this._tabFolder, 0);
        treeGroupItem.setText("B\u00e4ume");
        Composite treeGroup = new Composite((Composite)this._tabFolder, 0);
        treeGroup.setLayout((Layout)new GridLayout(3, false));
        treeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        treeGroupItem.setControl((Control)treeGroup);
        Label backgroundColorTreeLabel = new Label(treeGroup, 0);
        backgroundColorTreeLabel.setText("Hintergrundfarbe des Baumes:");
        backgroundColorTreeLabel.setLayoutData((Object)dataForLeftSide);
        final Label backgroundColorTreeDemo = new Label(treeGroup, 8);
        backgroundColorTreeDemo.setLayoutData((Object)dataForRightSide);
        backgroundColorTreeDemo.addMouseListener(this.newMouseListenerForColorDemo(backgroundColorTreeDemo));
        Label backgroundColorNodeLabel = new Label(treeGroup, 0);
        backgroundColorNodeLabel.setText("Hintergrundfarbe bei Knoten:");
        backgroundColorNodeLabel.setLayoutData((Object)dataForLeftSide);
        final Label backgroundColorNodeDemo = new Label(treeGroup, 8);
        backgroundColorNodeDemo.setLayoutData((Object)dataForRightSide);
        backgroundColorNodeDemo.addMouseListener(this.newMouseListenerForColorDemo(backgroundColorNodeDemo));
        Label foregroundColorNodeLabel = new Label(treeGroup, 0);
        foregroundColorNodeLabel.setText("Schrift und Rahmenfarbe bei Knoten:");
        foregroundColorNodeLabel.setLayoutData((Object)dataForLeftSide);
        final Label foregroundColorNodeDemo = new Label(treeGroup, 8);
        foregroundColorNodeDemo.setLayoutData((Object)dataForRightSide);
        foregroundColorNodeDemo.addMouseListener(this.newMouseListenerForColorDemo(foregroundColorNodeDemo));
        Label backgroundColorLeafLabel = new Label(treeGroup, 0);
        backgroundColorLeafLabel.setText("Hintergrundfarbe bei Bl\u00e4ttern:");
        backgroundColorLeafLabel.setLayoutData((Object)dataForLeftSide);
        final Label backgroundColorLeafDemo = new Label(treeGroup, 8);
        backgroundColorLeafDemo.setLayoutData((Object)dataForRightSide);
        backgroundColorLeafDemo.addMouseListener(this.newMouseListenerForColorDemo(backgroundColorLeafDemo));
        Label foregroundColorLeafLabel = new Label(treeGroup, 0);
        foregroundColorLeafLabel.setText("Schrift und Rahmenfarbe bei Bl\u00e4ttern:");
        foregroundColorLeafLabel.setLayoutData((Object)dataForLeftSide);
        final Label foregroundColorLeafDemo = new Label(treeGroup, 8);
        foregroundColorLeafDemo.setLayoutData((Object)dataForRightSide);
        foregroundColorLeafDemo.addMouseListener(this.newMouseListenerForColorDemo(foregroundColorLeafDemo));
        Label backgroundColorSelectedLabel = new Label(treeGroup, 0);
        backgroundColorSelectedLabel.setText("Hintergrundfarbe bei Auswahl:");
        backgroundColorSelectedLabel.setLayoutData((Object)dataForLeftSide);
        final Label backgroundColorSelectedDemo = new Label(treeGroup, 8);
        backgroundColorSelectedDemo.setLayoutData((Object)dataForRightSide);
        backgroundColorSelectedDemo.addMouseListener(this.newMouseListenerForColorDemo(backgroundColorSelectedDemo));
        Label foregroundColorSelectedLabel = new Label(treeGroup, 0);
        foregroundColorSelectedLabel.setText("Schrift und Rahmenfarbe bei Auswahl:");
        foregroundColorSelectedLabel.setLayoutData((Object)dataForLeftSide);
        final Label foregroundColorSelectedDemo = new Label(treeGroup, 8);
        foregroundColorSelectedDemo.setLayoutData((Object)dataForRightSide);
        foregroundColorSelectedDemo.addMouseListener(this.newMouseListenerForColorDemo(foregroundColorSelectedDemo));
        TabItem optimalTreeGroupItem = new TabItem(this._tabFolder, 0);
        optimalTreeGroupItem.setText("Automatischer Baum");
        Composite optimalTreeGroup = new Composite((Composite)this._tabFolder, 0);
        optimalTreeGroup.setLayout((Layout)new GridLayout(3, false));
        optimalTreeGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        optimalTreeGroupItem.setControl((Control)optimalTreeGroup);
        Label maxDataInLeafLabel = new Label(optimalTreeGroup, 0);
        maxDataInLeafLabel.setText("Maximale Elementezahl f\u00fcr Bl\u00e4tter:");
        maxDataInLeafLabel.setLayoutData((Object)dataForLeftSide);
        final Text maxDataInLeaf = new Text(optimalTreeGroup, 2048);
        maxDataInLeaf.setLayoutData((Object)dataForRightSide);
        Button acceptButton = new Button((Composite)this._shell, 8);
        acceptButton.setLayoutData((Object)new GridData(4, 4, true, true));
        acceptButton.setText("\u00dcbernehmen");
        acceptButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                ConfigConstants.CSV_SEPERATOR = csvSeperator.getText();
                ConfigConstants.MAX_ATTRIBUTES = Integer.parseInt(maxAttribute.getText());
                ConfigConstants.MAX_ROWS = Integer.parseInt(maxLines.getText());
                ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR = targetAttributeColorDemo.getBackground().getRGB();
                ConfigConstants.ELEMENT_COUNT_TO_TERMINATE = Integer.parseInt(maxDataInLeaf.getText());
                ConfigConstants.TREE_BACKGROUND_COLOR = backgroundColorTreeDemo.getBackground().getRGB();
                ConfigConstants.TREE_NODE_BACKGROUND_COLOR = backgroundColorNodeDemo.getBackground().getRGB();
                ConfigConstants.TREE_NODE_FOREGROUND_COLOR = foregroundColorNodeDemo.getBackground().getRGB();
                ConfigConstants.TREE_LEAF_BACKGROUND_COLOR = backgroundColorLeafDemo.getBackground().getRGB();
                ConfigConstants.TREE_LEAF_FOREGROUND_COLOR = foregroundColorLeafDemo.getBackground().getRGB();
                ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR = backgroundColorSelectedDemo.getBackground().getRGB();
                ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR = foregroundColorSelectedDemo.getBackground().getRGB();
                ConfigConstants.SURE_TO_EXIT = sureToExitCheckBox.getSelection();
                try {
                    ConfigConstants.LOGLEVEL = Integer.parseInt(logLevel.getText());
                }
                catch (NumberFormatException e) {
                    ConfigConstants.LOGLEVEL = 1;
                }
                switch (ConfigConstants.LOGLEVEL) {
                    case 1: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.DEBUG);
                        break;
                    }
                    case 2: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.INFO);
                        break;
                    }
                    case 3: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.ERROR);
                        break;
                    }
                    default: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.DEBUG);
                    }
                }
                ConfigConstants.saveConstants();
                ConfigurationDialog.this._controller.updateTrees();
                if (ConfigurationDialog.this._controller.getModel().getTable() != null) {
                    ConfigurationDialog.this._tableView.updateAllTable(ConfigurationDialog.this._controller.getModel().getTable());
                }
            }
        });
        Button okButton = new Button((Composite)this._shell, 8);
        okButton.setLayoutData((Object)new GridData(4, 4, true, true));
        okButton.setText("OK");
        okButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                ConfigConstants.CSV_SEPERATOR = csvSeperator.getText();
                ConfigConstants.MAX_ATTRIBUTES = Integer.parseInt(maxAttribute.getText());
                ConfigConstants.MAX_ROWS = Integer.parseInt(maxLines.getText());
                ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR = targetAttributeColorDemo.getBackground().getRGB();
                ConfigConstants.ELEMENT_COUNT_TO_TERMINATE = Integer.parseInt(maxDataInLeaf.getText());
                ConfigConstants.TREE_BACKGROUND_COLOR = backgroundColorTreeDemo.getBackground().getRGB();
                ConfigConstants.TREE_NODE_BACKGROUND_COLOR = backgroundColorNodeDemo.getBackground().getRGB();
                ConfigConstants.TREE_NODE_FOREGROUND_COLOR = foregroundColorNodeDemo.getBackground().getRGB();
                ConfigConstants.TREE_LEAF_BACKGROUND_COLOR = backgroundColorLeafDemo.getBackground().getRGB();
                ConfigConstants.TREE_LEAF_FOREGROUND_COLOR = foregroundColorLeafDemo.getBackground().getRGB();
                ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR = backgroundColorSelectedDemo.getBackground().getRGB();
                ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR = foregroundColorSelectedDemo.getBackground().getRGB();
                ConfigConstants.SURE_TO_EXIT = sureToExitCheckBox.getSelection();
                try {
                    ConfigConstants.LOGLEVEL = Integer.parseInt(logLevel.getText());
                }
                catch (NumberFormatException e) {
                    ConfigConstants.LOGLEVEL = 1;
                }
                switch (ConfigConstants.LOGLEVEL) {
                    case 1: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.DEBUG);
                        break;
                    }
                    case 2: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.INFO);
                        break;
                    }
                    case 3: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.ERROR);
                        break;
                    }
                    default: {
                        Logger.setCurrentLogLevel((LogLevel)LogLevel.DEBUG);
                    }
                }
                ConfigConstants.saveConstants();
                ConfigurationDialog.this._returnValue = 32;
                ConfigurationDialog.this._shell.close();
            }
        });
        Button cancelButton = new Button((Composite)this._shell, 8);
        cancelButton.setLayoutData((Object)new GridData(4, 4, true, true));
        cancelButton.setText("Abbrechen");
        cancelButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent pE) {
                ConfigurationDialog.this._shell.close();
            }
        });
        setDefault.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                csvSeperator.setText(",");
                maxAttribute.setText("10");
                maxLines.setText("100");
                targetAttributeColorDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TARGET_ATTRIBUTE_COLUMN_COLOR));
                maxDataInLeaf.setText("1");
                backgroundColorTreeDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_BACKGROUND_COLOR));
                backgroundColorNodeDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_NODE_BACKGROUND_COLOR));
                foregroundColorNodeDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_NODE_FOREGROUND_COLOR));
                backgroundColorLeafDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_LEAF_BACKGROUND_COLOR));
                foregroundColorLeafDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_LEAF_FOREGROUND_COLOR));
                backgroundColorSelectedDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_SELECTED_BACKGROUND_COLOR));
                foregroundColorSelectedDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, ConfigConstants.DEFAULT_TREE_SELECTED_FOREGROUND_COLOR));
                sureToExitCheckBox.setSelection(false);
                logLevel.setText("" + ConfigConstants.DEFAULT_LOGLEVEL);
            }
        });
        csvSeperator.setText(ConfigConstants.CSV_SEPERATOR);
        maxAttribute.setText("" + ConfigConstants.MAX_ATTRIBUTES);
        maxLines.setText("" + ConfigConstants.MAX_ROWS);
        targetAttributeColorDemo.setBackground(new Color((Device)this._display, ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR));
        maxDataInLeaf.setText("" + ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
        backgroundColorTreeDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_BACKGROUND_COLOR));
        backgroundColorNodeDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_NODE_BACKGROUND_COLOR));
        foregroundColorNodeDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_NODE_FOREGROUND_COLOR));
        backgroundColorLeafDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_LEAF_BACKGROUND_COLOR));
        foregroundColorLeafDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_LEAF_FOREGROUND_COLOR));
        backgroundColorSelectedDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR));
        foregroundColorSelectedDemo.setBackground(new Color((Device)this._display, ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR));
        sureToExitCheckBox.setSelection(ConfigConstants.SURE_TO_EXIT);
        logLevel.setText("" + ConfigConstants.LOGLEVEL);
        this._shell.pack();
        this._shell.open();
        while (!this._shell.isDisposed()) {
            if (this._display.readAndDispatch()) continue;
            this._display.sleep();
        }
        return this._returnValue;
    }

    private MouseListener newMouseListenerForColorDemo(final Label pColorDemo) {
        return new MouseListener(){

            public void mouseDoubleClick(MouseEvent arg0) {
            }

            public void mouseDown(MouseEvent arg0) {
            }

            public void mouseUp(MouseEvent arg0) {
                RGB rgb = new ColorDialog(ConfigurationDialog.this._shell, 0).open();
                if (rgb != null) {
                    pColorDemo.setBackground(new Color((Device)ConfigurationDialog.this._display, rgb));
                }
            }
        };
    }
}

