/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.view;

import de.hwrBerlin.dataMining.constants.ConfigConstants;
import de.hwrBerlin.dataMining.dataStructure.DecisionTreeNode;
import de.hwrBerlin.dataMining.view.ListTableShower;
import de.hwrBerlin.dataMining.view.widgets.combo.ExtendedComboBox;
import de.hwrBerlin.dataMining.view.widgets.table.ExtendedTable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public class TreeDetails
extends Composite {
    private ExtendedTable _table;
    private ExtendedComboBox _devideAtribute;
    private Label _dataContValue;
    private List<Label> _labelsForAttributeValues = new ArrayList<Label>();
    private DecisionTreeNode _selectedNode;

    public TreeDetails(Composite pParent, int pStyle, final boolean pEditable) {
        super(pParent, pStyle);
        this.setLayout((Layout)new GridLayout(2, false));
        GridData spanGridData = new GridData(4, 4, true, true);
        spanGridData.horizontalSpan = 2;
        GridData spanGridData2 = new GridData(4, 4, true, false);
        spanGridData2.horizontalSpan = 2;
        Label nextDevideByAttributeName = new Label((Composite)this, 0);
        nextDevideByAttributeName.setLayoutData((Object)spanGridData2);
        nextDevideByAttributeName.setText("N\u00e4chste ebene unterteilen nach (Attribut + gewichtete Entropie): ");
        this._devideAtribute = new ExtendedComboBox(this, 8, true);
        this._devideAtribute.setLayoutData(spanGridData2);
        this._devideAtribute.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (pEditable && TreeDetails.this._selectedNode != null) {
                    if (TreeDetails.this._devideAtribute.getSelection() == null) {
                        TreeDetails.this._selectedNode.setOwnAttribute(TreeDetails.this._selectedNode.getTargetAttribute());
                    } else {
                        TreeDetails.this._selectedNode.setOwnAttribute(((String)TreeDetails.this._devideAtribute.getSelection()).split(" \\(")[0]);
                    }
                }
            }
        });
        if (!pEditable) {
            this._devideAtribute.getCombo().setEnabled(false);
        }
        new Label((Composite)this, 0).setLayoutData((Object)spanGridData2);
        this._table = new ExtendedTable(this, 67584, new ListTableShower());
        this._table.setLayoutData(spanGridData);
        this._table.getTable().setHeaderVisible(true);
        this._table.getTable().setLinesVisible(true);
        Label dataCont = new Label((Composite)this, 0);
        dataCont.setText("Anzahl der Datens\u00e4tze:");
        this._dataContValue = new Label((Composite)this, 0);
        this._dataContValue.setLayoutData((Object)new GridData(131072, 4, false, false));
        this._dataContValue.setText("0");
        new Label((Composite)this, 0).setLayoutData((Object)spanGridData2);
        Label targetAttributeValues = new Label((Composite)this, 0);
        targetAttributeValues.setLayoutData((Object)spanGridData2);
        targetAttributeValues.setText("Werte der Zielattribute:");
    }

    public void setInput(DecisionTreeNode node) {
        this._selectedNode = node;
        if (node != null) {
            this._dataContValue.setText(String.valueOf(node.getCountOfElements()));
            this._table.setHeader(node.getSourceTable().getAttributNames());
            int selectedColumn = -1;
            int i = 0;
            while (node.getSourceTable().getAttributNames().length > i) {
                if (node.getSourceTable().getAttributNames()[i].equals(node.getTargetAttribute())) {
                    selectedColumn = i;
                    break;
                }
                ++i;
            }
            this._table.setInput(node.getSourceTable().getRows(), selectedColumn);
            for (Label label : this._labelsForAttributeValues) {
                label.dispose();
            }
            this._labelsForAttributeValues.clear();
            Map<String, Integer> values = node.getSourceTable().getValueCountsForAttributName(node.getTargetAttribute());
            for (String key : values.keySet()) {
                Label seperator = new Label((Composite)this, 258);
                GridData spanGridData = new GridData(4, 4, true, false);
                spanGridData.horizontalSpan = 2;
                seperator.setLayoutData((Object)spanGridData);
                this._labelsForAttributeValues.add(seperator);
                Label attributeValueName = new Label((Composite)this, 0);
                attributeValueName.setLayoutData((Object)new GridData(16384, 4, false, false));
                attributeValueName.setText("      - " + key);
                this._labelsForAttributeValues.add(attributeValueName);
                Label attributeValueCount = new Label((Composite)this, 0);
                attributeValueCount.setLayoutData((Object)new GridData(131072, 4, false, false));
                attributeValueCount.setText(values.get(key) + " / " + node.getCountOfElements());
                this._labelsForAttributeValues.add(attributeValueCount);
            }
            this._devideAtribute.setInput(new Object[0]);
            ArrayList<String> strings = new ArrayList<String>();
            String[] stringArray = node.getSourceTable().getAttributNames();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String attribute = stringArray[n2];
                if (!attribute.equals(node.getTargetAttribute())) {
                    DecisionTreeNode testNode = new DecisionTreeNode(node.getSourceTable(), attribute, node.getTargetAttribute(), ConfigConstants.ELEMENT_COUNT_TO_TERMINATE);
                    strings.add(String.valueOf(attribute) + " (" + testNode.calculateWeightedEntropy() + ")");
                }
                ++n2;
            }
            this._devideAtribute.setInput(strings.toArray(new Object[0]));
            if (node.getOwnAttribute() != node.getTargetAttribute()) {
                this._devideAtribute.setSetlection(String.valueOf(node.getOwnAttribute()) + " (" + node.calculateWeightedEntropy() + ")");
            }
        } else {
            this._dataContValue.setText("0");
            this._table.setHeader(new String[0]);
            this._table.setInput(new String[0]);
            for (Label label : this._labelsForAttributeValues) {
                label.dispose();
            }
            this._labelsForAttributeValues.clear();
            this._devideAtribute.setInput(new Object[0]);
        }
        this.layout();
    }
}

