/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.controller.connectors;

import de.hwrBerlin.dataMining.controller.connectors.FileType;
import de.hwrBerlin.dataMining.dataStructure.DecisionTreeNode;
import de.hwrBerlin.dataMining.view.TreePainter;
import de.hwrBerlin.dataMining.view.dialog.TreeExportZoom;
import de.hwrBerlin.tools.logger.LogLevel;
import de.hwrBerlin.tools.logger.Logger;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import org.dom4j.Document;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.widgets.Shell;

public abstract class TreeFileReaderWriter {
    public static boolean writeTreeToTextFile(DecisionTreeNode pTreeNode, File pFile) {
        if (pTreeNode == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Es kann kein null-Object als Baum abgespeichert werden");
            return false;
        }
        if (pFile == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Der Baum kann nicht abgespeichert werden, die Datei ist fehlerhaft");
            return false;
        }
        try {
            OutputFormat format = OutputFormat.createPrettyPrint();
            format.setEncoding(System.getProperty("file.encoding"));
            XMLWriter writer = new XMLWriter((Writer)new FileWriter(pFile), format);
            writer.write(pTreeNode.toXML());
            writer.close();
            return true;
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Fehler beim Schreiben einer Text-Baumdatei: " + pFile));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeTreeToImageFile(DecisionTreeNode pTreeNode, File pFile) {
        if (pTreeNode == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Es kann kein null-Object als Baum abgespeichert werden");
            return false;
        }
        if (pFile == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Der Baum kann nicht abgespeichert werden, die Datei ist fehlerhaft");
            return false;
        }
        try {
            Shell shell = new Shell();
            TreeExportZoom treeExportZoom = new TreeExportZoom(shell, 0);
            TreePainter treePainter = treeExportZoom.open(pTreeNode);
            if (treePainter != null) {
                int format = FileType.getFileType(pFile) == FileType.JPEG ? 4 : 5;
                ImageLoader iLoader = new ImageLoader();
                iLoader.data = new ImageData[]{treePainter.toImage().getImageData()};
                iLoader.save(pFile.getAbsolutePath(), format);
                shell.dispose();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Fehler beim Schreiben einer Bild-Baumdatei: " + pFile));
            e.printStackTrace();
            return false;
        }
    }

    public static boolean writeTreeToSVGFile(DecisionTreeNode pTreeNode, File pFile) {
        if (pTreeNode == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Es kann kein null-Object als Baum abgespeichert werden");
            return false;
        }
        if (pFile == null) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)"Der Baum kann nicht abgespeichert werden, die Datei ist fehlerhaft");
            return false;
        }
        try {
            Shell shell = new Shell();
            TreeExportZoom treeExportZoom = new TreeExportZoom(shell, 0);
            TreePainter treePainter = treeExportZoom.open(pTreeNode);
            if (treePainter != null) {
                OutputFormat format = OutputFormat.createPrettyPrint();
                format.setEncoding(System.getProperty("file.encoding"));
                XMLWriter writer = new XMLWriter((Writer)new FileWriter(pFile), format);
                writer.write(treePainter.toSVG());
                writer.close();
                return true;
            }
            return false;
        }
        catch (Exception e) {
            Logger.log((LogLevel)LogLevel.ERROR, (String)("Fehler beim Schreiben einer Text-Baumdatei: " + pFile));
            e.printStackTrace();
            return false;
        }
    }

    public static DecisionTreeNode getDecisionTreeFromFile(File pFile) {
        if (pFile.exists()) {
            try {
                SAXReader reader = new SAXReader();
                Document document = reader.read(pFile);
                return new DecisionTreeNode(document);
            }
            catch (Exception e) {
                Logger.log((LogLevel)LogLevel.ERROR, (String)("Konnte die BaumXML nicht lesen von: " + pFile + " - Encoding muss " + System.getProperty("file.encoding") + " sein."));
                e.printStackTrace();
                return null;
            }
        }
        Logger.log((LogLevel)LogLevel.ERROR, (String)("Die BaumXML wurde nicht gefunden: " + pFile));
        return null;
    }
}

