/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.controller.connectors;

import de.hwrBerlin.dataMining.controller.connectors.FileType;
import de.hwrBerlin.dataMining.controller.connectors.TableFileConnector;
import de.hwrBerlin.dataMining.dataStructure.TableData;
import de.hwrBerlin.tools.logger.Logger;
import java.io.File;
import java.util.ArrayList;
import junit.framework.TestCase;
import org.junit.Test;

public class TestTableFileConnector
extends TestCase {
    @Test
    public void testReadTableFileFile() {
        Logger.setGraphicalLog((boolean)false);
        TestTableFileConnector.assertEquals((String)"Keine Datei gefunden", null, (Object)TableFileConnector.readTableFile(new File("Bla.xlsx"), FileType.XLSX));
        TestTableFileConnector.assertEquals((String)"Keine Datei angegeben", null, (Object)TableFileConnector.readTableFile(new File(""), FileType.CSV));
        TestTableFileConnector.assertEquals((String)"Falsches DateiFormat angegeben", null, (Object)TableFileConnector.readTableFile(new File("ressource\\Excel 2010 Format.xlsx"), FileType.XLS));
        TestTableFileConnector.assertEquals((String)"Falsches DateiFormat angegeben", null, (Object)TableFileConnector.readTableFile(new File("ressource\\Excel 2010 Format.xlsx"), FileType.CSV));
        TestTableFileConnector.assertEquals((String)"Falsches DateiFormat angegeben", null, (Object)TableFileConnector.readTableFile(new File("ressource\\Excel 2010 Format.CSV"), FileType.XLSX));
        TestTableFileConnector.assertTrue((String)"Excel 2010 Format importieren", (TableFileConnector.readTableFile(new File("ressource\\Excel 2010 Format.xlsx"), FileType.XLSX).getRowCount() > 0 ? 1 : 0) != 0);
        TestTableFileConnector.assertTrue((String)"Excel 2003 Format importieren", (TableFileConnector.readTableFile(new File("ressource\\Excel 2003 Format.xls"), FileType.XLS).getRowCount() > 0 ? 1 : 0) != 0);
        TestTableFileConnector.assertTrue((String)"CSV Format importieren", (TableFileConnector.readTableFile(new File("ressource\\CSV Format.csv"), FileType.CSV).getRowCount() > 0 ? 1 : 0) != 0);
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testReadTableFileFileTableFileType() {
        Logger.setGraphicalLog((boolean)false);
        TestTableFileConnector.assertEquals((String)"Keine Datei gefunden", null, (Object)TableFileConnector.readTableFile(new File("Bla.xlsx")));
        TestTableFileConnector.assertEquals((String)"Keine Datei angegeben", null, (Object)TableFileConnector.readTableFile(new File("")));
        TestTableFileConnector.assertTrue((String)"Excel 2010 Format importieren", (TableFileConnector.readTableFile(new File("ressource\\Excel 2010 Format.xlsx")).getRowCount() > 0 ? 1 : 0) != 0);
        TestTableFileConnector.assertTrue((String)"Excel 2003 Format importieren", (TableFileConnector.readTableFile(new File("ressource\\Excel 2003 Format.xls")).getRowCount() > 0 ? 1 : 0) != 0);
        TestTableFileConnector.assertTrue((String)"CSV Format importieren", (TableFileConnector.readTableFile(new File("ressource\\CSV Format.csv")).getRowCount() > 0 ? 1 : 0) != 0);
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testWriteTableFileFileTableData() {
        Logger.setGraphicalLog((boolean)false);
        TableData testTable = new TableData();
        ArrayList<String> attributNames = new ArrayList<String>();
        attributNames.add("AttriName 1");
        attributNames.add("AttriName 2");
        attributNames.add("AttriName 3");
        attributNames.add("TESTNAME");
        attributNames.add("AttriName 5");
        ArrayList<String> firstDataRow = new ArrayList<String>();
        firstDataRow.add("AData 23");
        firstDataRow.add("Dsata 34");
        firstDataRow.add("TESTWERT1");
        firstDataRow.add("Datea 231");
        firstDataRow.add("Daeta 24");
        ArrayList<String> secondDataRow = new ArrayList<String>();
        secondDataRow.add("gsdrg");
        secondDataRow.add("dgrdg 45 2");
        secondDataRow.add("Asefsefe 3");
        secondDataRow.add("4534gb sgsegss");
        secondDataRow.add("TESTWERT2");
        testTable.addRowToEnd(attributNames);
        testTable.addRowToEnd(firstDataRow);
        testTable.addRowToEnd(secondDataRow);
        File xlsxFile = new File("testFiles\\bla.xlsx");
        File xlsFile = new File("testFiles\\xbla.xls");
        File csvFile = new File("testFiles\\bla.csv");
        TestTableFileConnector.assertTrue((String)"Excel 2010 Format schreiben", (boolean)TableFileConnector.writeTableFile(xlsxFile, testTable));
        TestTableFileConnector.assertTrue((String)"Excel 2007 Format schreiben", (boolean)TableFileConnector.writeTableFile(xlsFile, testTable));
        TestTableFileConnector.assertTrue((String)"CSV Format schreiben", (boolean)TableFileConnector.writeTableFile(csvFile, testTable));
        TestTableFileConnector.assertTrue((String)"Falsches Format schreiben", (!TableFileConnector.writeTableFile(new File("testFiles\\bla.bla"), testTable) ? 1 : 0) != 0);
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        try {
            xlsFile.deleteOnExit();
            csvFile.deleteOnExit();
            xlsxFile.deleteOnExit();
        }
        catch (Exception e) {
            TestTableFileConnector.assertTrue((boolean)false);
        }
        Logger.setGraphicalLog((boolean)true);
    }

    @Test
    public void testWriteTableFileFileTableFileTypeTableData() {
        Logger.setGraphicalLog((boolean)false);
        TableData testTable = new TableData();
        ArrayList<String> attributNames = new ArrayList<String>();
        attributNames.add("AttriName 1");
        attributNames.add("AttriName 2");
        attributNames.add("AttriName 3");
        attributNames.add("TESTNAME");
        attributNames.add("AttriName 5");
        ArrayList<String> firstDataRow = new ArrayList<String>();
        firstDataRow.add("AData 23");
        firstDataRow.add("Dsata 34");
        firstDataRow.add("TESTWERT1");
        firstDataRow.add("Datea 231");
        firstDataRow.add("Daeta 24");
        ArrayList<String> secondDataRow = new ArrayList<String>();
        secondDataRow.add("gsdrg");
        secondDataRow.add("dgrdg 45 2");
        secondDataRow.add("Asefsefe 3");
        secondDataRow.add("4534gb sgsegss");
        secondDataRow.add("TESTWERT2");
        testTable.addRowToEnd(attributNames);
        testTable.addRowToEnd(firstDataRow);
        testTable.addRowToEnd(secondDataRow);
        File xlsxFile = new File("testFiles\\bla.xlsx");
        File xlsFile = new File("testFiles\\xbla.xls");
        File csvFile = new File("testFiles\\bla.csv");
        TestTableFileConnector.assertTrue((String)"Excel 2010 Format schreiben", (boolean)TableFileConnector.writeTableFile(xlsxFile, FileType.XLSX, testTable));
        TestTableFileConnector.assertTrue((String)"Excel 2007 Format schreiben", (boolean)TableFileConnector.writeTableFile(xlsFile, FileType.XLS, testTable));
        TestTableFileConnector.assertTrue((String)"CSV Format schreiben", (boolean)TableFileConnector.writeTableFile(csvFile, FileType.CSV, testTable));
        File wrongFileName = new File("testFiles\\bla.bla");
        TestTableFileConnector.assertTrue((String)"Falsches Format schreiben", (boolean)TableFileConnector.writeTableFile(wrongFileName, FileType.XLSX, testTable));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsxFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(xlsFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(0, 3).equals("TESTNAME"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(1, 2).equals("TESTWERT1"));
        TestTableFileConnector.assertTrue((boolean)TableFileConnector.readTableFile(csvFile).getValueFromIndex(2, 4).equals("TESTWERT2"));
        try {
            xlsFile.deleteOnExit();
            csvFile.deleteOnExit();
            xlsxFile.deleteOnExit();
            wrongFileName.deleteOnExit();
        }
        catch (Exception e) {
            TestTableFileConnector.assertTrue((boolean)false);
        }
        Logger.setGraphicalLog((boolean)true);
    }
}

