/*
 * Decompiled with CFR 0.152.
 */
package de.hwrBerlin.dataMining.constants;

import de.hwrBerlin.tools.configManager.ConfigManager;
import org.eclipse.swt.graphics.RGB;

public class ConfigConstants {
    private static final String CSV_SEPARATOR_SIGN_KEY = "csvSeparator";
    private static final String MAX_ATTRIBUTE_KEY = "maxAttribute";
    private static final String MAX_COLUMNS_KEY = "maxColumns";
    private static final String ELEMENT_COUNT_TO_TERMINATE_KEY = "elementCountToTerminate";
    private static final String TARGET_ATTRIBUTE_COLUMN_COLOR_KEY = "targetAttributeColumnColor";
    private static final String TREE_BACKGROUND_COLOR_KEY = "treeBackgroundColor";
    private static final String TREE_NODE_BACKGROUND_COLOR_KEY = "treeNodeBackgroundColor";
    private static final String TREE_NODE_FOREGROUND_COLOR_KEY = "treeNodeForegroundColor";
    private static final String TREE_LEAF_BACKGROUND_COLOR_KEY = "treeLeafBackgroundColor";
    private static final String TREE_LEAF_FOREGROUND_COLOR_KEY = "treeLeafForegroundColor";
    private static final String TREE_SELECTED_BACKGROUND_COLOR_KEY = "treeSelectedBackgroundColor";
    private static final String TREE_SELECTED_FOREGROUND_COLOR_KEY = "treeSelectedForegroundColor";
    private static final String SURE_TO_EXIT_KEY = "sureToExit";
    private static final String LOGLEVEL_KEY = "logLevel";
    public static final String DEFAULT_CSV_SEPERATOR = ",";
    public static final int DEFAULT_MAX_ATTRIBUTES = 10;
    public static final int DEFAULT_MAX_ROWS = 100;
    public static final int DEFAULT_ELEMENT_COUNT_TO_TERMINATE = 1;
    public static final RGB DEFAULT_TARGET_ATTRIBUTE_COLUMN_COLOR = new RGB(255, 200, 200);
    public static final RGB DEFAULT_TREE_BACKGROUND_COLOR = new RGB(240, 240, 255);
    public static final RGB DEFAULT_TREE_NODE_BACKGROUND_COLOR = new RGB(200, 200, 255);
    public static final RGB DEFAULT_TREE_NODE_FOREGROUND_COLOR = new RGB(100, 100, 255);
    public static final RGB DEFAULT_TREE_LEAF_BACKGROUND_COLOR = new RGB(200, 200, 255);
    public static final RGB DEFAULT_TREE_LEAF_FOREGROUND_COLOR = new RGB(100, 100, 255);
    public static final RGB DEFAULT_TREE_SELECTED_BACKGROUND_COLOR = new RGB(255, 200, 200);
    public static final RGB DEFAULT_TREE_SELECTED_FOREGROUND_COLOR = new RGB(255, 100, 100);
    public static final boolean DEFAULT_SURE_TO_EXIT = false;
    public static int DEFAULT_LOGLEVEL = 1;
    public static String CSV_SEPERATOR = ",";
    public static int MAX_ATTRIBUTES = 10;
    public static int MAX_ROWS = 100;
    public static int ELEMENT_COUNT_TO_TERMINATE = 1;
    public static RGB TARGET_ATTRIBUTE_COLUMN_COLOR = DEFAULT_TARGET_ATTRIBUTE_COLUMN_COLOR;
    public static RGB TREE_BACKGROUND_COLOR = DEFAULT_TREE_BACKGROUND_COLOR;
    public static RGB TREE_NODE_BACKGROUND_COLOR = DEFAULT_TREE_NODE_BACKGROUND_COLOR;
    public static RGB TREE_NODE_FOREGROUND_COLOR = DEFAULT_TREE_NODE_FOREGROUND_COLOR;
    public static RGB TREE_LEAF_BACKGROUND_COLOR = DEFAULT_TREE_LEAF_BACKGROUND_COLOR;
    public static RGB TREE_LEAF_FOREGROUND_COLOR = DEFAULT_TREE_LEAF_FOREGROUND_COLOR;
    public static RGB TREE_SELECTED_BACKGROUND_COLOR = DEFAULT_TREE_SELECTED_BACKGROUND_COLOR;
    public static RGB TREE_SELECTED_FOREGROUND_COLOR = DEFAULT_TREE_SELECTED_FOREGROUND_COLOR;
    public static boolean SURE_TO_EXIT = false;
    public static int LOGLEVEL = DEFAULT_LOGLEVEL;

    public static void readConstants() {
        CSV_SEPERATOR = ConfigManager.getValueFromKey((String)CSV_SEPARATOR_SIGN_KEY);
        try {
            LOGLEVEL = Integer.parseInt(ConfigManager.getValueFromKey((String)LOGLEVEL_KEY));
        }
        catch (NumberFormatException e) {
            LOGLEVEL = DEFAULT_LOGLEVEL;
        }
        try {
            MAX_ATTRIBUTES = Integer.parseInt(ConfigManager.getValueFromKey((String)MAX_ATTRIBUTE_KEY));
        }
        catch (NumberFormatException e) {
            MAX_ATTRIBUTES = 10;
        }
        try {
            MAX_ROWS = Integer.parseInt(ConfigManager.getValueFromKey((String)MAX_COLUMNS_KEY));
        }
        catch (NumberFormatException e) {
            MAX_ROWS = 100;
        }
        try {
            ELEMENT_COUNT_TO_TERMINATE = Integer.parseInt(ConfigManager.getValueFromKey((String)ELEMENT_COUNT_TO_TERMINATE_KEY));
        }
        catch (NumberFormatException e) {
            ELEMENT_COUNT_TO_TERMINATE = 1;
        }
        try {
            SURE_TO_EXIT = Boolean.parseBoolean(ConfigManager.getValueFromKey((String)SURE_TO_EXIT_KEY));
        }
        catch (NumberFormatException e) {
            SURE_TO_EXIT = false;
        }
        TARGET_ATTRIBUTE_COLUMN_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TARGET_ATTRIBUTE_COLUMN_COLOR_KEY));
        TREE_BACKGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_BACKGROUND_COLOR_KEY));
        TREE_NODE_BACKGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_NODE_BACKGROUND_COLOR_KEY));
        TREE_NODE_FOREGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_NODE_FOREGROUND_COLOR_KEY));
        TREE_LEAF_BACKGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_LEAF_BACKGROUND_COLOR_KEY));
        TREE_LEAF_FOREGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_LEAF_FOREGROUND_COLOR_KEY));
        TREE_SELECTED_BACKGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_SELECTED_BACKGROUND_COLOR_KEY));
        TREE_SELECTED_FOREGROUND_COLOR = ConfigConstants.getRGB(ConfigManager.getValueFromKey((String)TREE_SELECTED_FOREGROUND_COLOR_KEY));
        ConfigConstants.checkForInvalidValues();
    }

    private static RGB getRGB(String colorString) {
        if (colorString != null && colorString.matches("[0-2]?[0-9]?[0-9],[0-2]?[0-9]?[0-9],[0-2]?[0-9]?[0-9]")) {
            String[] splitted = colorString.split(DEFAULT_CSV_SEPERATOR);
            int r = Integer.parseInt(splitted[0]);
            int g = Integer.parseInt(splitted[1]);
            int b = Integer.parseInt(splitted[2]);
            if (r > 255 || g > 255 || b > 255) {
                return null;
            }
            return new RGB(r, g, b);
        }
        return null;
    }

    private static void checkForInvalidValues() {
        if (CSV_SEPERATOR == null || CSV_SEPERATOR == "") {
            CSV_SEPERATOR = DEFAULT_CSV_SEPERATOR;
        }
        if (MAX_ATTRIBUTES == 0) {
            MAX_ATTRIBUTES = 10;
        }
        if (MAX_ROWS == 0) {
            MAX_ROWS = 100;
        }
        if (ELEMENT_COUNT_TO_TERMINATE == 0) {
            ELEMENT_COUNT_TO_TERMINATE = 1;
        }
        if (TARGET_ATTRIBUTE_COLUMN_COLOR == null) {
            TARGET_ATTRIBUTE_COLUMN_COLOR = DEFAULT_TARGET_ATTRIBUTE_COLUMN_COLOR;
        }
        if (TREE_BACKGROUND_COLOR == null) {
            TREE_BACKGROUND_COLOR = DEFAULT_TREE_BACKGROUND_COLOR;
        }
        if (TREE_NODE_BACKGROUND_COLOR == null) {
            TREE_NODE_BACKGROUND_COLOR = DEFAULT_TREE_NODE_BACKGROUND_COLOR;
        }
        if (TREE_NODE_FOREGROUND_COLOR == null) {
            TREE_NODE_FOREGROUND_COLOR = DEFAULT_TREE_NODE_FOREGROUND_COLOR;
        }
        if (TREE_LEAF_BACKGROUND_COLOR == null) {
            TREE_LEAF_BACKGROUND_COLOR = DEFAULT_TREE_LEAF_BACKGROUND_COLOR;
        }
        if (TREE_LEAF_FOREGROUND_COLOR == null) {
            TREE_LEAF_FOREGROUND_COLOR = DEFAULT_TREE_LEAF_FOREGROUND_COLOR;
        }
        if (TREE_SELECTED_BACKGROUND_COLOR == null) {
            TREE_SELECTED_BACKGROUND_COLOR = DEFAULT_TREE_SELECTED_BACKGROUND_COLOR;
        }
        if (TREE_SELECTED_FOREGROUND_COLOR == null) {
            TREE_SELECTED_FOREGROUND_COLOR = DEFAULT_TREE_SELECTED_FOREGROUND_COLOR;
        }
    }

    public static void resetConstants() {
        CSV_SEPERATOR = DEFAULT_CSV_SEPERATOR;
        MAX_ATTRIBUTES = 10;
        MAX_ROWS = 100;
        ELEMENT_COUNT_TO_TERMINATE = 1;
        TARGET_ATTRIBUTE_COLUMN_COLOR = DEFAULT_TARGET_ATTRIBUTE_COLUMN_COLOR;
        TREE_BACKGROUND_COLOR = DEFAULT_TREE_BACKGROUND_COLOR;
        TREE_NODE_BACKGROUND_COLOR = DEFAULT_TREE_NODE_BACKGROUND_COLOR;
        TREE_NODE_FOREGROUND_COLOR = DEFAULT_TREE_NODE_FOREGROUND_COLOR;
        TREE_LEAF_BACKGROUND_COLOR = DEFAULT_TREE_LEAF_BACKGROUND_COLOR;
        TREE_LEAF_FOREGROUND_COLOR = DEFAULT_TREE_LEAF_FOREGROUND_COLOR;
        TREE_SELECTED_BACKGROUND_COLOR = DEFAULT_TREE_SELECTED_BACKGROUND_COLOR;
        TREE_SELECTED_FOREGROUND_COLOR = DEFAULT_TREE_SELECTED_FOREGROUND_COLOR;
        SURE_TO_EXIT = false;
    }

    public static void saveConstants() {
        if (ConfigManager.getValueFromKey((String)CSV_SEPARATOR_SIGN_KEY) != null) {
            ConfigManager.editConfigValue((String)CSV_SEPARATOR_SIGN_KEY, (String)CSV_SEPERATOR);
        } else {
            ConfigManager.addConfigValue((String)CSV_SEPARATOR_SIGN_KEY, (String)CSV_SEPERATOR);
        }
        if (ConfigManager.getValueFromKey((String)MAX_ATTRIBUTE_KEY) != null) {
            ConfigManager.editConfigValue((String)MAX_ATTRIBUTE_KEY, (String)String.valueOf(MAX_ATTRIBUTES));
        } else {
            ConfigManager.addConfigValue((String)MAX_ATTRIBUTE_KEY, (String)String.valueOf(MAX_ATTRIBUTES));
        }
        if (ConfigManager.getValueFromKey((String)MAX_COLUMNS_KEY) != null) {
            ConfigManager.editConfigValue((String)MAX_COLUMNS_KEY, (String)String.valueOf(MAX_ROWS));
        } else {
            ConfigManager.addConfigValue((String)MAX_COLUMNS_KEY, (String)String.valueOf(MAX_ROWS));
        }
        if (ConfigManager.getValueFromKey((String)ELEMENT_COUNT_TO_TERMINATE_KEY) != null) {
            ConfigManager.editConfigValue((String)ELEMENT_COUNT_TO_TERMINATE_KEY, (String)String.valueOf(ELEMENT_COUNT_TO_TERMINATE));
        } else {
            ConfigManager.addConfigValue((String)ELEMENT_COUNT_TO_TERMINATE_KEY, (String)String.valueOf(ELEMENT_COUNT_TO_TERMINATE));
        }
        if (ConfigManager.getValueFromKey((String)TARGET_ATTRIBUTE_COLUMN_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TARGET_ATTRIBUTE_COLUMN_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TARGET_ATTRIBUTE_COLUMN_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TARGET_ATTRIBUTE_COLUMN_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_BACKGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_BACKGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_BACKGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_NODE_BACKGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_NODE_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_NODE_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_BACKGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_NODE_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_NODE_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_BACKGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_NODE_FOREGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_NODE_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_NODE_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_FOREGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_NODE_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_NODE_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_NODE_FOREGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_LEAF_BACKGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_LEAF_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_LEAF_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_BACKGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_LEAF_FOREGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_LEAF_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_LEAF_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_LEAF_FOREGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_SELECTED_BACKGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_SELECTED_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_SELECTED_BACKGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_BACKGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)TREE_SELECTED_FOREGROUND_COLOR_KEY) != null) {
            ConfigManager.editConfigValue((String)TREE_SELECTED_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.blue));
        } else {
            ConfigManager.addConfigValue((String)TREE_SELECTED_FOREGROUND_COLOR_KEY, (String)(String.valueOf(ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.red) + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.green + DEFAULT_CSV_SEPERATOR + ConfigConstants.TREE_SELECTED_FOREGROUND_COLOR.blue));
        }
        if (ConfigManager.getValueFromKey((String)SURE_TO_EXIT_KEY) != null) {
            ConfigManager.editConfigValue((String)SURE_TO_EXIT_KEY, (String)String.valueOf(SURE_TO_EXIT));
        } else {
            ConfigManager.addConfigValue((String)SURE_TO_EXIT_KEY, (String)String.valueOf(SURE_TO_EXIT));
        }
        if (ConfigManager.getValueFromKey((String)LOGLEVEL_KEY) != null) {
            ConfigManager.editConfigValue((String)LOGLEVEL_KEY, (String)String.valueOf(LOGLEVEL));
        } else {
            ConfigManager.addConfigValue((String)LOGLEVEL_KEY, (String)String.valueOf(LOGLEVEL));
        }
    }
}

