package spielewiese;
import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.util.Date;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.ScrollPaneConstants;

import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;

public class TestClient {

    JPanel loginPanel;
    JPanel mainPanel;
    JFrame frame;
    JTextArea messageBox;
    JTextField sendMessage;
    JLabel LserverIP;
    JTextField TFserverIP;
    JLabel Lport;
    JTextField TFport;
    JLabel Lname;
    JTextField TFname;
    BufferedReader reader;
    ObjectOutputStream writer;
    Socket socket;
    
    
    String name;
    
    public static void main(String[] args) {
        TestClient client = new TestClient();
        client.run();
    }
    
    public void run(){
        //GUI fr den Login
        frame = new JFrame("N-Chat");
        loginPanel = new JPanel();
        LserverIP = new JLabel("Server IP:  ");
        TFserverIP = new JTextField(26);
        Lport = new JLabel("Port:           ");
        TFport = new JTextField(26);
        Lname = new JLabel("Name:        ");
        TFname = new JTextField(26);
        JButton Blogin = new JButton("<->-<->-<-> Login <->-<->-<->");
        Blogin.addActionListener(new LoginButtonListener());
        loginPanel.add(LserverIP);
        loginPanel.add(TFserverIP);
        loginPanel.add(Lport);
        loginPanel.add(TFport);
        loginPanel.add(Lname);
        loginPanel.add(TFname);
        loginPanel.add(Blogin);
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(400,500);
        frame.setVisible(true);
        frame.getContentPane().add(BorderLayout.CENTER, loginPanel);
    }
    
    //Login Button
    public class LoginButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent ev){
            if(TFserverIP.getText().equals("")){
                JOptionPane.showMessageDialog(frame, "Bitte eine Server IP angeben!", "Fehler", JOptionPane.ERROR_MESSAGE);
            }
            else if(TFport.getText().equals("")){
                JOptionPane.showMessageDialog(frame, "Bitte einen Port angeben!", "Fehler", JOptionPane.ERROR_MESSAGE);
            }
            else if(TFname.getText().equals("")){
                JOptionPane.showMessageDialog(frame, "Bitte einen Namen angeben!", "Fehler", JOptionPane.ERROR_MESSAGE);
            }
            else{
                if(joinNetwork(TFserverIP.getText(),TFport.getText())){
                    name = TFname.getText();
                    setMainPanel();
                }
                else{
                    JOptionPane.showMessageDialog(frame, "Verbindung konnte nicht hergestellt werden, bitte berprfen sie die angegebenen Daten!", "Fehler", JOptionPane.ERROR_MESSAGE);
                }
            }
        }
    }
    
    //Beitritt in den Chatroom
    private boolean joinNetwork(String pIP, String pPort){
        try{
            //Verbindung zum Server
            socket  = new Socket(pIP, Integer.valueOf(pPort));
            InputStreamReader streamReader = new InputStreamReader(socket.getInputStream());
            reader = new BufferedReader(streamReader);
            writer = new ObjectOutputStream(socket.getOutputStream());
            return true;
        }
        catch(IOException ex){return false;}
    }
    
    
    //Senden Button
    public class SendButtonListener implements ActionListener {
        public void actionPerformed(ActionEvent ev){
            try{
                writer.reset();
                System.out.println("Habe auf senden2 gedrckt");
                User user = new User("hgi", 0, 12);
                TextMessage message = new TextMessage();
                message.setMessage("asfasefsaf");
                Date date = new Date();
                writer.writeObject(message);
                writer.flush();
            }
            catch(Exception ex){}
            sendMessage.setText("");
            sendMessage.requestFocus();
        }
    }
    
    
    private void setMainPanel(){
        loginPanel.setVisible(false);
        mainPanel = new JPanel();
        messageBox = new JTextArea(15,30);
        messageBox.setLineWrap(true);
        messageBox.setWrapStyleWord(true);
        messageBox.setEditable(false);
        JScrollPane scrollBar = new JScrollPane(messageBox);
        scrollBar.setVerticalScrollBarPolicy(ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        scrollBar.setHorizontalScrollBarPolicy(ScrollPaneConstants.HORIZONTAL_SCROLLBAR_ALWAYS);
        sendMessage = new JTextField(20);
        sendMessage.addActionListener(new ActionListener() {
            
            @Override
            public void actionPerformed(ActionEvent e) {
                try{
                    writer.reset();
                    System.out.println("Habe auf senden2 gedrckt");
                    User user = new User("jo", 0, 12);
                    TextMessage message = new TextMessage();
                    message.setMessage("asfasefsaf");
                    Date date = new Date();
                    writer.writeObject(message);
                    writer.flush();
                }
                
                catch(Exception ex){}
                sendMessage.setText("");
                sendMessage.requestFocus();
            }
        });
        JButton sendButton = new JButton("Senden");
        sendButton.addActionListener(new SendButtonListener());
        mainPanel.add(scrollBar);
        mainPanel.add(sendMessage);
        mainPanel.add(sendButton);
        
        //Thread zum empfangen von Nachrichten einrichten
        Thread readerThread = new Thread(new IncommingReader());
        readerThread.start();
        
        frame.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
        frame.setSize(400,500);
        frame.setVisible(true);
        frame.getContentPane().add(BorderLayout.CENTER, mainPanel);
        frame.repaint();
        
        //writer.println(name+" hat den Chat betreten!");
//      writer.flush();
    }
    
    //Thread
    public class IncommingReader implements Runnable{
        public void run(){
            String message;
            try{
                while((message = reader.readLine()) != null){
                    messageBox.append(message + "\n");
                }
            }
            catch(Exception ex){}
        }
    }
    
}
