/*
 * Copyright 2011 blackshark productions
 */
package de.hwrBerlin.hwrchat.server.shell.model;

import java.util.ArrayList;
import java.util.List;

import de.hwrBerlin.hwrchat.server.shell.interfaces.ICommandActivate;

/**
 * 
 * @author nsmeenk
 */
public class Command {
    
    /** Commando */
    private final String[] _command;
    
    /** Regulrer Ausdruck */
    private String _regex;
    
    /** Ignoriert gro/kleinschreibung */
    private final boolean _ignoreCase;
    
    /** Weiterleitung fals das Komando aufgerufen wird */
    private final ICommandActivate _commandActivate;
    
    /** Beschribung */
    private final String _description;
    
    private static final String paramNotification = "<[a-z|A-Z|0-9]*>";
    
    private static final String paramRegex = "[a-z|A-Z|0-9|@|\\.]*";
    
    

    /**
     * Erstellt ein Commando
     */
    public Command(String[] pCommand, String pDescription, boolean pIgnoreCase, ICommandActivate pCommandActivate) {
        _command = pCommand;
        _description = pDescription;
        _ignoreCase = pIgnoreCase;
        _commandActivate = pCommandActivate;
        _regex = "";
        for (String commandString : _command) {
            _regex += " ";
            if (commandString.matches(paramNotification)) {
                _regex += paramRegex;
            }
            else {
                if (_ignoreCase) {
                    //XXX
                    _regex += commandString;
                }
                else {
                    _regex += commandString;
                }
            }
        }
        _regex = _regex.substring(1);
    }
    


    /**
     * Prft ob eine Eingabe dieses Komando ist
     */
    public boolean match(String pCommand) {
        // berptrfen ob Form stimmt
        if (pCommand.matches(_regex)) {
            return true;
        }
        return false;
    }
    


    /**
     * Ruft die Aktion im Interface auf
     * 
     * @param pParameter
     * @return
     */
    public String CommandActivate(String[] pCommand) {
        // alle Parameter suchen
        List<String> parameter = new ArrayList<String>();
        int parameterIndex = 0;
        for (int index = 0; index < pCommand.length; index++) {
            if (_command[index].matches(paramNotification)) {
                parameter.add(pCommand[index]);
                parameterIndex++;
            }
        }
        return (_commandActivate.Activate(parameter.toArray()));
    }
    


    @Override
    public String toString() {
        String returnString = "";
        for (String command : _command) {
            returnString += " " + command;
        }
        returnString += " - " + _description;
        if (_ignoreCase) {
            returnString += " (Ignore case)";
        }
        return returnString;
    }
    


    /**
     * Gibt alle Komandos zurck
     * 
     * @return
     */
    public String[] getCommand() {
        return _command;
    }
    


    /**
     * Gibt die Beschreibung zurck
     * 
     * @return
     */
    public String getDescription() {
        return _description;
    }
    


    /**
     * prft ob die gro/klein schreibweise genutzt wird
     * 
     * @return
     */
    public boolean isIgnoreCase() {
        return _ignoreCase;
    }
    
}
