/**
 * 
 */
package de.hwrBerlin.hwrchat.server.shell.commands;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;

import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.AMessage;
import de.hwrBerlin.hwrchat.server.EMailSender;
import de.hwrBerlin.hwrchat.server.Server;
import de.hwrBerlin.hwrchat.server.shell.interfaces.ICommandActivate;

/**
 * @author Nico Smeenk
 * 
 */
public class RegisterUserCommand implements ICommandActivate {
    
    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.server.shell.interfaces.ICommandActivate#Activate(java.lang.Object[])
     */
    @Override
    public String Activate(Object[] pParameter) {
        
        Map<String, String> configs = Server.configs;
        
        // Daten fr den Mail versand
        String username = "";
        String password = "";
        String senderAddress = configs.get("EmailSenderAddress");
        String recipientsAddress = "p.servus.servus@googlemail.com";
        String subject = "Java-Test";
        String smtpHost = configs.get("EmailSmtpHost");
        Boolean needAuth;
        if(configs.get("EmailNeedAuthentication").trim().equals(true)) {
            needAuth = true;
        }
        else {
            needAuth = false;
        }
        
        String returnString = "";
        returnString += "Es wurde ein neuer User angelegt!\n";
        
        
        EMailSender email = new EMailSender();
        
        // Soll ein zuflliges Passwort generiert werden oder nicht?
        String randomPassword;
        User user;
        if(!configs.get("UseDefaultUserPassword").trim().equals("true")) {
           randomPassword = gen(10);
           user = new User((String) pParameter[0], randomPassword.hashCode(), -1);
           returnString += "Das zufllige Passwort lautet:" + randomPassword;
        }
        else {
            user = new User((String) pParameter[0], configs.get("DefaultUserPassword").hashCode(), -1);
        }
        
        
        user.setEMail((String) pParameter[1]);
        int userId = Server.getDataObject().insertUser(user);
        
         //Auerdem erstelle einen OfflineMessage Eintrag
        List<AMessage> dummyList = new ArrayList<AMessage>();
        Server.getOfflineMessages().put(userId, dummyList);
        
        //Wenn nicht das DefaultPassword verwendet werden soll dann sende eine Email
        System.out.println(configs.get("UseDefaultUserPassword"));
        if(!configs.get("UseDefaultUserPassword").trim().equals("true")) {
            try{
                email.sendEMail(smtpHost, username, password, senderAddress, user.getEMail(), subject,"" , needAuth);
            }
            finally {
                returnString += "Konnte leider keine Email senden";
            }
        }
        
        
        
        return returnString;
    }
    
    //Generiert einen zuflligen String
    public static String gen(int length) {
        final String AB = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZ";
        Random rnd = new Random();
        StringBuffer sb = new StringBuffer();
           for( int i = 0; i < length; i++ ) 
              sb.append(AB.charAt( rnd.nextInt(AB.length()) ) );
           return sb.toString();
    }
        
    
}
