/*
 * Copyright 2011 blackshark productions 
 */
package de.hwrBerlin.hwrchat.server.shell;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.blackshark.debugger.Debugger;
import de.hwrBerlin.hwrchat.server.shell.commands.ClearCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.HelpCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.QuitCommand;
import de.hwrBerlin.hwrchat.server.shell.interfaces.ICommandActivate;
import de.hwrBerlin.hwrchat.server.shell.model.Command;

/**
 * 
 * @author nsmeenk
 */
public class CommandShell {

	/** Komandos */
	private List<Command> _commands = new ArrayList<Command>();

	/** Shell */
	private Shell _parent;

	/** vorstehendes Symbol */
	private String _commandStart = "> ";

	/** Logtext */
	private Text _logText;

	/** Geloggter Text */
	private String _log;

	/** Inputtext */
	private Text _inputText;

	/** Speichert ob die Shell von auen geschlossen wurde */
	private boolean _isDisposed;

	/** letzte Kommentare */
	private List<String> _laskInputs = new ArrayList<String>();

	/**
	 * Erzeugt eine Komandokonsole
	 */
	public CommandShell(Shell pParent) {
		_parent = pParent;
		Initialize("");
	}

	/**
	 * Erzeugt eine Komandokonsole
	 * 
	 * @param pTitle
	 */
	public CommandShell(Composite pParent, String pTitle) {
		_parent = (Shell) pParent;
		Initialize(pTitle);
	}

	/**
	 * Erstellt die Grafische Oberflche
	 * 
	 * @param pTitle
	 */
	private void Initialize(String pTitle) {

		Debugger.print(this, "init go"); // ===========================

		// Standartbefehle

		Debugger.print(this, "init commands go"); // ===========================

		String[] help = { "help" };
		defineCommand(help, "Shows all possible commands", false, new HelpCommand(this));
		String[] clear = { "clear" };
		defineCommand(clear, "Clear the log", false, new ClearCommand(this));
		String[] quit = { "quit" };
		defineCommand(quit, "Quit the shell", false, new QuitCommand(this));

		Debugger.print(this, "init commands ok"); // ===========================

		Debugger.print(this, "init view go"); // ===========================

		_parent.setSize(500, 300);

		setTitle(pTitle);
		_parent.setBackground(new Color(_parent.getDisplay(), new RGB(0, 0, 0)));
		GridLayout marginLayout = new GridLayout();
		marginLayout.numColumns = 1;
		marginLayout.marginHeight = 13;
		marginLayout.marginWidth = 10;
		_parent.setLayout(marginLayout);

		_logText = new Text(_parent, SWT.NO_BACKGROUND | SWT.MULTI | SWT.V_SCROLL | SWT.BORDER);
		_logText.setForeground(new Color(_parent.getDisplay(), 255, 255, 255));
		_logText.setBackground(new Color(_parent.getDisplay(), new RGB(0, 0, 0)));
		_logText.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		_logText.setEditable(false);
		_logText.setText(_commandStart);
		_log = _commandStart;

		_inputText = new Text(_parent, SWT.NO_BACKGROUND | SWT.SINGLE | SWT.BORDER);
		_inputText.setForeground(new Color(_parent.getDisplay(), 255, 255, 255));
		_inputText.setBackground(new Color(_parent.getDisplay(), new RGB(0, 0, 0)));
		_inputText.setLayoutData(new GridData(SWT.FILL, SWT.NONE, true, false, 1, 1));
		_inputText.setSize(_parent.getSize().x, 22);
		_inputText.setFocus();

		Debugger.print(this, "init view listener go"); // ===========================

		_inputText.addKeyListener(new KeyListener() {

			@Override
			public void keyReleased(KeyEvent pE) {
				// NOI
			}

			@Override
			public void keyPressed(KeyEvent pE) {
				// bei hoch letzte kommentare
				if (pE.keyCode == 16777217 && _laskInputs.size() > 0) {
					_inputText.setText(_laskInputs.get(_laskInputs.size() - 1));
				}
				// Enter abfangen
				if (pE.keyCode == 13 && _inputText.getText() != "") {
					_laskInputs.add(_inputText.getText());
					_log = _log + _inputText.getText();
					_log = _log + "\n";
					// System.out.println(_log); 
					Command(_inputText.getText());
					// System.out.println("teste2" + _log);
					_log = _log + _commandStart;
					_logText.setText(_log);
					_inputText.setText("");
					// runterscrollen
					_logText.setFocus();
					_logText.setSelection(_log.split("").length * 2);
					_inputText.setFocus();
					if (_isDisposed) {
						_parent.dispose();
					}
				}
			}
		});
		Debugger.print(this, "init view listener ok"); // ===========================
		Debugger.print(this, "init view ok"); // ===========================
	}

	/**
	 * Wird bei Befehlen aufgerufen
	 */
	private void Command(String pCommand) {
		Debugger.print(this, "use command go"); // ===========================
		boolean commandFound = false;
		for (Command command : _commands) {
			if (command.match(pCommand)) {
				String input = command.CommandActivate(pCommand.split(" "));
				_log = _log + input;
				commandFound = true;
			}
		}
		if (!commandFound) {
			Debugger.info(this, "command not found"); // ===========================
			_log = _log + "ERROR - Command not found";
			_log = _log + "\n";
		}
		Debugger.print(this, "use command ok"); // ===========================
	}

	/**
	 * Setzt den Titel
	 * 
	 * @param pTitle
	 */
	public void setTitle(String pTitle) {
		_parent.setText(pTitle);
	}

	/**
	 * Erstellt ein Komando
	 * 
	 * @param pCommand
	 * @param pIgnoreCase
	 * @param pCommandActivate
	 */
	public boolean defineCommand(String pCommand[], String pDescription, boolean pIgnoreCase, ICommandActivate pCommandActivate) {

		Debugger.print(this, "define command go"); // ===========================

		// alles richtig formatiert?
		for (String commandString : pCommand) {
			if (!commandString.matches("[<|>|a-z|A-Z|0-9]*")) {
				System.out.println("Format not valid");
				return false;
			}
		}
		// keine Kommandoberschneidungen
		for (Command command : _commands) {
			boolean equals = true;

			// wenn gleiche anzahl von parametern
			if (pCommand.length == command.getCommand().length) {
				for (int index = 0; index < pCommand.length; index++) {
					// wenn beide Konstanten und ungleich - Kommando erstellen
					if (pCommand[index].matches("[a-z|A-Z|0-9]*") && command.getCommand()[index].matches("[a-z|A-Z|0-9]*") && pCommand[index] != command.getCommand()[index]) {
						// TODO betrachtung der gro und kleinschreibweise
						equals = false;
					}
				}
				if (equals) {
					Debugger.info(this, "command not accept"); // ===========================
					Debugger.print(this, "define command '" + Arrays.toString(pCommand) + "' ok"); // ===========================
					return false;
				}
			}
		}
		_commands.add(new Command(pCommand, pDescription, pIgnoreCase, pCommandActivate));
		Debugger.info(this, "command accept"); // ===========================
		Debugger.print(this, "define command ok"); // ===========================
		return true;
	}

	/**
	 * Lscht den Inhalt des Logs
	 */
	public void clear() {
		_log = "";
		_logText.setText(_log);
	}

	/**
	 * Schliet die Shell
	 */
	public void dispose() {
		_isDisposed = true;
	}

	public List<Command> getCommands() {
		return _commands;
	}
	
	public void write(final String pOut){
	    if (_parent.getDisplay().isDisposed()) {
            return;
        }
        _parent.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                _log = _log + "\n";
                _log = _log + pOut;
                _log = _log + "\n";
                _log = _log + _commandStart;
                _logText.setText(_log);                
            }
        });   
	}
}
