package de.hwrBerlin.hwrchat.server.persistence;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import de.blackshark.debugger.Debugger;
import de.hwrBerlin.hwrchat.clientTest.controller.ConfigManager;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.server.dbconnection.DBConnection;

/**
 * Diese Klasse soll konkrete Methoden beherbergen, die Daten in die Datenbank schreiben und wieder auslesen.
 * 
 * @author Benni
 * 
 */
public class DatabaseServerDAO {
    
    // Tabelle Chat_User
    String userTableName = "`hwr_chat`.`chat_users`";
    String userId = "id";
    String userPassword = "password";
    String userStatusMessage = "status_massage";
    String userCourse = "course";
    String userNickName = "nick_name";
    String userFirstName = "first_name";
    String userLastName = "last_name";
    String userHobby = "hobby";
    String userCity = "city";
    String userMobile = "mobile";
    String userEmail = "e_mail";
    String userProfilePictureLink = "profile_picture_link";
    
    // Tabelle Group
    String groupTableName = "`hwr_chat`.`chat_group`";
    String groupId = "id";
    String groupName = "name";
    String groupFounder = "founder";
    
    // Tabelle attends
    String attendsTableName = "`hwr_chat`.`attends`";
    String attendsUserId = "user_id";
    String attendsGroupId = "group_id";
    
    // Tabelle knows
    String knowsTableName = "`hwr_chat`.`knows`";
    String knowsUserOne = "chat_user_one";
    String knowsUserTwo = "chat_user_two";
    
    DBConnection connection = new DBConnection();
    
    

    public DatabaseServerDAO() {
        // Lese Konfiguration fr die Datenbank aus dem Config-File
        ConfigManager configManager = new ConfigManager(true);
        Map<String, String> configs = configManager.readConfig();
        
        String dbPath = configs.get("DataBasePath");
        String dbUser = configs.get("DataBaseUserName");
        String dbUserPass = configs.get("DataBaseUserPassword");
        
        // Verbinde mit den gefundenen Einstellungen
        connection.connect(dbPath, dbUser, dbUserPass);
        
        Debugger.DEBUG = true;
    }
    


    // ///////////////////////////////USER///////////////////////////////////////////////////////////
    
    /**
     * Diese Methode kann eine gefllt User-Bean in die Datenbankteballe schreiben.
     * 
     * @param user
     *            Eine (gefllte) User-Bean mit allen Inforamtionen ber den User
     * @return Es wird die id bergeben, die fr diesen User in der Datenbank zugeordnet wurde
     */
    public int insertUser(User user) {
        // Lege zwei Arrays an mit den Namen der Spalten und den dazugehrogen Werten
        String[] attributes = { userCity, userCourse, userFirstName, userHobby, userLastName,
                userMobile, userNickName, userPassword, userProfilePictureLink, userStatusMessage,
                userEmail };
        String[] values = { user.getCity(), user.getCourse(), user.getFirstName(), user.getHobby(),
                user.getLastName(), user.getMobile(), user.getName(), "" + user.getPassword(),
                user.getProfilePictureLink(), "" + user.getStatusMessage(), user.getEMail() };
        
        // Generiere aus den beiden Arrays einen SQL-Statement-String
        String sql;
        sql = createSimpleInsertStatement(userTableName, attributes, values);
        
        // Fhre das Statement aus
        connection.queryUpdate(sql);
        
        // Versuche die UserId fr diesen neu angelegten Datensatz herauszufinden
        String sqlGetId = "SELECT " + userId + " FROM " + userTableName + " WHERE " + userNickName
                + " = '" + user.getName() + "'";
        ResultSet rs = connection.queryGet(sqlGetId);
        int userId = -1;
        try {
            while (rs.next()) {
                userId = rs.getInt(this.userId);
            }
        }
        catch (Exception e) {
            Debugger.error(getClass(), "Fehler beim erstellen vom User :" + user.getId());
            e.printStackTrace();
        }
        // Gebe die id zurck
        return userId;
        
    }
    


    /**
     * Diese Methode ndert die Daten eines Users. Es ist wichtig, dass die User-Bean so gefllt ist, wie die Informationen nachher in der Datenbank stehen sollen. Es sollen also nicht nur genderte
     * Werte in dieser Bean stehen, sondern wirklich ALLE
     * 
     * @param user
     *            Eine (gefllte) User-Bean mit allen Informationen ber den User
     */
    public void updateUser(User user) {
        // Lege zwei Arrays an mit den Namen der Spalten und den dazugehrogen Werten
        String[] attributes = { userCity, userCourse, userFirstName, userHobby, userLastName,
                userMobile, userNickName, userPassword, userProfilePictureLink, userStatusMessage,
                userEmail };
        String[] values = { user.getCity(), user.getCourse(), user.getFirstName(), user.getHobby(),
                user.getLastName(), user.getMobile(), user.getName(), "" + user.getPassword(),
                user.getProfilePictureLink(), user.getStatusMessage(), user.getEMail() };
        
        // Generiere aus den beiden Arrays einen SQL-Statement-String
        String sql;
        sql = createSimpleUpdateStatement(userTableName, userId, "" + user.getId(), attributes,
                values);
        
        // Fhre das Statement aus
        connection.queryUpdate(sql);
    }
    


    /**
     * Diese Methode ruft einen User aus der Datenbank ab. Bentigt wird dazu die UserId.
     * 
     * @param userId
     *            Zum finden eines Datensatzes muss eine userId bergeben werden.
     * @return User Es wird eine Bean mit den Informationen zurckgegeben(oder null wenn nicht in DB)
     */
    public User getUser(String userId) {
        if (userId == null || userId.trim().equals("")) {
            Debugger.info(getClass(), "getUser: Keine UserId bekommen");
            return null;
        }
        
        String selectSQL = "SELECT * FROM " + userTableName + "WHERE " + this.userId + "=" + userId;
        
        ResultSet rs = connection.queryGet(selectSQL);
        
        // Nutzer der zurckgegben werden soll
        User userInformation = null;
        
        boolean filledUserBean = false;
        try {
            while (rs.next()) {
                userInformation = createUserFromResultset(rs, userId);
                
                filledUserBean = true;
            }
            // Gebe nur Bean zurck, wenn diese auch gefllt wurde
            if (filledUserBean) {
                return userInformation;
            }
            else {
                return null;
            }
            
        }
        catch (SQLException e) {
            Debugger.error(getClass(), "Fehler beim lesen eines Users :" + userId);
            e.printStackTrace();
            return null;
        }
    }
    


    /**
     * Prft ob ein User in der Datenbank ist.
     * 
     * @param userId
     *            Der User der in der DB sein soll.
     * @return true, wenn er in der DB vorhanden ist, false wenn nicht
     */
    public boolean userIsInDataBase(String userId) {
        // Benutze Methode getUser
        if (getUser(userId) != null) {
            return true;
        }
        else {
            return false;
        }
    }
    


    /**
     * Lscht einen USer anhand der Id aus der Datenbank
     * 
     * @param userId
     *            Eine UserId muss angegeben werden
     */
    public void deleteUser(String userId) {
        // Lsche zunchst alle Beziehungen fr Benutzer kennt Benutzer
        removeAllRelationsForUser(userId);
        
        // Lsche alle Gruppen Beziehung fr den Benutzer
        removeUserFromAttendsRelation(userId);
        
        // Dann den eigentlichen User
        // SQL Statement
        String sql;
        sql = "DELETE FROM " + userTableName + " WHERE " + this.userId + " =" + userId;
        
        // Versuche es auszufhren
        try {
            connection.queryUpdate(sql);
        }
        catch (Exception e) {
            Debugger.error(getClass(), "User konnte nicht gelscht werden :" + userId);
            e.printStackTrace();
        }
    }
    


    /**
     * Diese Methode ruft alle Benutzer aus der Datenbank ab (ohne die BenutzerListe die der Nutzer kennt)
     * 
     * @return Eine Liste von allen Usern die in der Datenbankgespeichert sind.
     */
    public List<User> getAllUsers() {
        // SQL Statement
        String sqlAllUserIds;
        sqlAllUserIds = "SELECT * FROM " + userTableName;
        
        // Fhre aus und erstelle Resultset
        ResultSet rs = connection.queryGet(sqlAllUserIds);
        
        // Erstelle eine ArrayList mit Usern
        List<User> knownUser = new ArrayList<User>();
        
        try {
            while (rs.next()) {
                
                // Erstelle User Bean vom Resultset
                User userInformation = createUserFromResultset(rs, null);
                
                // Fge der Liste hinzu
                knownUser.add(userInformation);
            }
        }
        catch (Exception e) {
            Debugger.error(getClass(), "getAllUsers : Konnte keine Userliste erstellen");
            e.printStackTrace();
            return null;
        }
        
        return knownUser;
    }
    


    /**
     * Diese Methode speichert die "kennt" Beziehung zwischen zwei Usern. Momentan ist diese Methode so gestaltet, dass in eine Richtungen die Beziheung eingetragen wird, also wenn user1 user2 kennt,
     * dann kennt user2 nicht unbedingt auch user1
     * 
     * @param userIdOne
     * @param UserIdTwo
     */
    public void addUserKnowsUserRelation(String userIdOne, String UserIdTwo) {
        if (userIdOne.equals(UserIdTwo)) {
            Debugger.error(getClass(), " Kann keine Beziehung erstellen die auf sich selbst zeigt "
                    + userIdOne);
            return;
        }
        // Spalten und die Werte definieren
        String[] knowsTableAttributes = { knowsUserOne, knowsUserTwo };
        String[] knowsTableValuesFirstDirection = { userIdOne, UserIdTwo };
        
        String sqlFirstUserRelation = createSimpleInsertStatement(knowsTableName,
                knowsTableAttributes, knowsTableValuesFirstDirection);
        
        // Fhre Statement aus
        connection.queryUpdate(sqlFirstUserRelation);
        
        //
        // //Drehe die Verbindung um, dass beidseitig die Beziehung vorhanden ist.
        // String[] knowsTableValuesSecondDirection = {UserIdTwo, userIdOne};
        //
        // String sqlSecondUserRelation = createSimpleInsertStatement(knowsTableName,knowsTableAttributes, knowsTableValuesSecondDirection);
        //
        // //Fhre zweites Statment aus
        // connection.queryUpdate(sqlSecondUserRelation);
        
    }
    


    /**
     * Diese Methode gibt anhan der bergebenen UserId alle Benutzer zurck die der Benutzer mit dieser Id kennt.
     * 
     * @param userId
     *            Id von dessen Benutzer die bekannten Nutzer herausgesucht werden sollen.
     * @return
     */
    public List<User> getAllUserRelationsForOneUser(String userId) {
        if (userId == null || userId.trim().equals("")) {
            Debugger.info(getClass(), "getAllUserRelationsForOneUser: Keine UserId bekommen");
            return null;
        }
        List<User> returnUsers = new ArrayList<User>();
        
        // ber einen SQL-JOIN wird eine USerListe erstellt, die der angegebene Benutzer mit der id kennt.
        String getAllUserFromRelation = "SELECT hwr_chat.chat_users.* FROM " + knowsTableName + ","
                + userTableName + " WHERE " + knowsUserTwo + " = " + this.userId + " AND "
                + knowsUserOne + "=" + userId;
        
        // Schicke Statement ab
        ResultSet rs = connection.queryGet(getAllUserFromRelation);
        try {
            while (rs.next()) {
                // Erstelle fr alle gefundenen Benutzer eine Bean und reihe sie in die Liste ein
                User tempUser = createUserFromResultset(rs, null);
                returnUsers.add(tempUser);
            }
        }
        catch (SQLException e) {
            Debugger.error(getClass(),
                    "getAllUserRelationsForOneUser: Konnte Relationen nicht verarbeiten id1"
                            + userId);
            e.printStackTrace();
        }
        
        return returnUsers;
    }
    


    /**
     * Diese Methode lscht eine Beziehung zwischen zwei Benutzern und zwar in beide Richtungen
     * 
     * @param userIdOne
     * @param userIdTwo
     */
    public void removeUserKnowsUserRelation(String userIdOne, String userIdTwo) {
        if (userIdOne == null || userIdTwo == null) {
            Debugger.info(getClass(), "removeUserKnowsUserRelation: Keine UserId bekommen");
            return;
        }
        
        // Die Beziehung zwischen den Benutzern muss beidseitig gelscht werden
        String deleteKnowsRelation = "DELETE FROM " + knowsTableName + " WHERE " + knowsUserOne
                + " =" + userIdOne + " AND " + knowsUserTwo + " =" + userIdTwo + " OR "
                + knowsUserOne + " =" + userIdTwo + " AND " + knowsUserTwo + " =" + userIdOne;
        
        // Fhre Statement aus
        connection.queryUpdate(deleteKnowsRelation);
        
    }
    


    /**
     * Diese Methode lscht alle Beziehungen die ein Benutzer hat. Die Beziehung wird beidseitig gelscht. Der User taucht also in keiner Relation mehr auf.
     * 
     * @param id
     */
    public void removeAllRelationsForUser(String userId) {
        if (userId == null || userId.trim().equals("")) {
            Debugger.info(getClass(), "removeAllRelationsForUser: Keine UserId bekommen");
            return;
        }
        
        String deleteAllKnowsRelations = "DELETE FROM " + knowsTableName + " WHERE " + knowsUserOne
                + " =" + userId + " OR " + knowsUserTwo + " =" + userId;
        
        // Fhre Statement aus
        connection.queryUpdate(deleteAllKnowsRelations);
    }
    


    // ///////////////////////////////////GRUPPEN//////////////////////////////////////
    
    /**
     * Diese Methode kann eine gefllt Group-Bean in die Datenbankteballe schreiben.
     * 
     * @param group
     *            Eine (gefllte) Group-Bean mit allen Inforamtionen ber die Gruppe
     * @return Es wird die vergebene id der Gruppe zurckgegen
     */
    public int insertGroup(Group group) {
        if (group == null) {
            Debugger.info(getClass(), "insertGroup: Es wurde keine Gruppe angegeben");
            return -1;
        }
        String[] groupTableAttributes = { groupName, groupFounder };
        String[] groupTableValues = { group.getName(), "" + group.getFounder().getId() };
        // Es mssen zweierlei tabellen benutzt werden.
        
        // Zum einen die Gruppe selbst
        String sqlInsertGroup = createSimpleInsertStatement(groupTableName, groupTableAttributes,
                groupTableValues);
        
        // Fhre das Statement aus
        connection.queryUpdate(sqlInsertGroup);
        
        // Die von der Datenbank vergebene id dieser Gruppe muss noch fr die Attends Eintrge gefunden werden
        String findGroupEntryId = "SELECT " + groupId + " FROM " + groupTableName + " WHERE "
                + groupName + " LIKE '" + group.getName() + "'";
        
        ResultSet rs = connection.queryGet(findGroupEntryId);
        
        try {
            while (rs.next()) {
                group.setId(rs.getInt(groupId));
            }
        }
        catch (SQLException e) {
            Debugger.error(getClass(), "insertGroup: Konnte keine id wiederfinden");
            e.printStackTrace();
        }
        
        // Zum anderen muss fr jeden Benutzer der Gruppe ein Eintrag in der Realtion attends geschehen
        // Aber nur wenn berhaupt schon benutzer in der Gruppe sind
        if ((group.getUser() != null) && (group.getUser().size() != 0)) {
            
            // Speichere einen Eintrag fr jeden User aus der Group Bean in der Tabelle attends
            for (User groupUser : group.getUser()) {
                
                attendGroup("" + groupUser.getId(), "" + group.getId());
                
            }
            
        }
        
        // Gebe verwendete Id wieder aus
        return group.getId();
    }
    


    /**
     * Diese Methode kann eine gefllt Group-Bean aus der Datenbank herausholen.
     * 
     * @param groupId
     *            es Muss eine GroupId angegben werden.
     */
    public Group getGroup(String groupId) {
        if (groupId == null) {
            Debugger.info(getClass(), "insertGroup: Es wurde keine GruppenId angegeben");
            return null;
        }
        
        // Erstelle eine leere Gruppe, die zurckgegeben werden soll
        Group returnGroup = null;
        // Zunchst alle Informationen der Gruppe aus der Gruppe Tabelle holen
        String sqlGetGroup = "SELECT * FROM " + groupTableName + " WHERE " + this.groupId + "="
                + groupId;
        
        // Es muss die Liste von allen Benutzern erstellt werden, die in der Datenbank vorhanden sind
        List<User> allUsers = getAllUsers();
        
        // GruppenInformation ausgeben
        ResultSet rs = connection.queryGet(sqlGetGroup);
        try {
            while (rs.next()) {
                // Suche den Group Founder aus der Liste aller Benutzer
                User groupFounder = null;
                for (User user : allUsers) {
                    if (user.getId() == rs.getInt(this.groupFounder)) {
                        groupFounder = user;
                    }
                }
                // Erstelle die ReturnGroup
                returnGroup = new Group(rs.getString(groupName), groupFounder,
                        rs.getInt(this.groupId));
            }
            
        }
        catch (Exception e) {
            Debugger.error(getClass(), "getGroup: Konnte Group nicht zusammensetzen");
            e.printStackTrace();
        }
        
        // Suche alle Benutzer, die in dieser Gruppe sind und fge Sie der Gruppe hinzu
        List<User> groupUser = getAllUsersInGroup(returnGroup.getId());
        for (User user : groupUser) {
            returnGroup.addUser(user);
        }
        
        return returnGroup;
    }
    


    /**
     * Diese Methode kann eine Beziehung zwischen einem User und einer Gruppe eintragen.
     * 
     * @param userId
     * @param groupId
     */
    public void attendGroup(String userId, String groupId) {
        
        String[] attendsTableAttributes = { attendsUserId, attendsGroupId };
        String[] attendsTableValues = { userId, groupId };
        
        String sqlAttends = createSimpleInsertStatement(attendsTableName, attendsTableAttributes,
                attendsTableValues);
        
        // Fhre das Statement aus
        connection.queryUpdate(sqlAttends);
        
    }
    


    /**
     * Diese Methode gibt alle Benutzer zurck, die in einer Gruppe vorhanden sind. Es wird die attends Beziehung durchsucht
     * 
     * @param groupId
     * @return
     */
    public List<User> getAllUsersInGroup(int groupId) {
        
        List<User> returnUsers = new ArrayList<User>();
        
        // Statement das alle User Informationen zu einer GroupId herausfinden soll. (JOIN)
        // SELECT hwr_chat.chat_users.* FROM `hwr_chat`.`attends`,`hwr_chat`.`chat_users` WHERE user_id = id AND group_id =13
        String sqlGroupAttends = "SELECT hwr_chat.chat_users.* FROM " + attendsTableName + ","
                + userTableName + "WHERE " + attendsUserId + " = " + userId + " AND "
                + attendsGroupId + " = " + groupId;
        // Fhre aus
        ResultSet rs = connection.queryGet(sqlGroupAttends);
        // Werte Resultset aus und ordne der ReturnListe alle User zu die mithilfe des Resultsets erstellt werden konnten
        try {
            while (rs.next()) {
                returnUsers.add(createUserFromResultset(rs, null));
            }
        }
        catch (Exception e) {
            Debugger.error(getClass(),
                    "getAllUsersInGroup: Fehler beim Zuordnen der Benutzer in Gruppe: " + groupId);
            e.printStackTrace();
        }
        
        return returnUsers;
    }
    


    /**
     * Diese Methode gibt alle Gruppen zurck, die der Benutzer kennt
     * 
     * @param userId
     * @return
     */
    public List<Group> getAllGroupsForUser(int userId) {
        
        List<Group> returnGroups = new ArrayList<Group>();
        
        // Erstelle eine leere Gruppe, die zurckgegeben werden soll
        Group returnGroup = null;
        
        // Es muss die Liste von allen Benutzern erstellt werden, die in der Datenbank vorhanden sind
        List<User> allUsers = getAllUsers();
        
        // Statement das alle Gruppen Informationen zu einer UserId herausfinden soll. (JOIN)
        // SELECT hwr_chat.chat_users.* FROM `hwr_chat`.`attends`,`hwr_chat`.`chat_users` WHERE user_id = id AND group_id =13
        String sqlGroupAttends = "SELECT hwr_chat.chat_group.* FROM " + attendsTableName + ","
                + groupTableName + "WHERE " + attendsUserId + " = " + userId + " AND "
                + attendsGroupId + " = " + groupId;
        // Fhre aus
        ResultSet rs = connection.queryGet(sqlGroupAttends);
        // Werte Resultset aus und ordne der ReturnListe alle User zu die mithilfe des Resultsets erstellt werden konnten
        try {
            while (rs.next()) {
                // Suche den Group Founder aus der Liste aller Benutzer
                User groupFounder = null;
                for (User user : allUsers) {
                    if (user.getId() == rs.getInt(this.groupFounder)) {
                        groupFounder = user;
                    }
                }
                // Erstelle die ReturnGroup
                returnGroup = new Group(rs.getString(groupName), groupFounder,
                        rs.getInt(this.groupId));
                returnGroups.add(returnGroup);
            }
        }
        catch (Exception e) {
            Debugger.error(getClass(),
                    "getAllUsersInGroup: Fehler beim Zuordnen der Benutzer in Gruppe: " + groupId);
            e.printStackTrace();
        }
        
        return returnGroups;
    }
    


    /**
     * Diese Methode lscht eine Gruppe aus der Datenbank, es werden auch die Eintrge der attends Beziehung gelscht.
     * 
     * @param groupId
     */
    public void removeGroup(String groupId) {
        // Lsche zuerst die User ist in Gruppe Beziehung
        removeGroupFromAttendsRelation(groupId);
        
        // Lsche nun die Gruppe aus der Gruppentabelle
        String deleteGroup = "DELETE FROM " + groupTableName + " WHERE " + this.groupId + " ="
                + groupId;
        
        // Fhre aus
        connection.queryUpdate(deleteGroup);
        
    }
    


    /**
     * Diese Methode lscht alle User kennt Gruppe Relationen fr eine GruppenId
     * 
     * @param groupId
     */
    public void removeGroupFromAttendsRelation(String groupId) {
        // Lsche die Gruppe aus der Attends Beziehung
        String deleteUserAttendsGroup = "DELETE FROM " + attendsTableName + " WHERE "
                + attendsGroupId + " =" + groupId;
        
        // Fhre aus
        connection.queryUpdate(deleteUserAttendsGroup);
        
    }
    


    /**
     * Diese Methode lscht alle User kennt Gruppe Relationen fr eine UserId
     * 
     * @param userId
     */
    public void removeUserFromAttendsRelation(String userId) {
        // Lsche den User aus der Attends Beziehung
        String deleteUserAttendsGroup = "DELETE FROM " + attendsTableName + " WHERE "
                + attendsUserId + " =" + userId;
        
        // Fhre aus
        connection.queryUpdate(deleteUserAttendsGroup);
        
    }
    


    /**
     * Diese Methode gibt alle Gruppen aus der Datenbank aus. (ohne User, die dieser Gruppe zugehrig sind) Und einer dummy UserBean im founder Attribut, in der nur die UserID zu finden ist.
     * 
     * @return
     */
    public List<Group> getAllGroups() {
        // Statement fr alle Gruppen
        String sqlGetAllGroups = "SELECT * FROM " + groupTableName;
        
        // Leere Liste
        List<Group> knownGroups = new ArrayList<Group>();
        
        // Schicke ab
        ResultSet rs = connection.queryGet(sqlGetAllGroups);
        
        try {
            
            while (rs.next()) {
                // Ordne den Werten aus dem Resultset die Werte der Gruppe zu, erstelle Dummy User Bean
                Group group = new Group(rs.getString(groupName), new User("Dummy User", 0,
                        rs.getInt(groupFounder)), rs.getInt(groupId));
                knownGroups.add(group);
            }
            
        }
        catch (Exception e) {
            Debugger.error(getClass(), "getAllGroups: Fehler beim zurodenen der Gruppen");
            e.printStackTrace();
            return null;
        }
        
        // Alles hat geklappt return
        return knownGroups;
        
    }
    


    // //////////////////////Hilfsmethoden///////////////////////////////
    
    /**
     * Diese Methode erstellt ein Insert Statement das MysQL konform ist. Die Anzahl der Werte und Attribute die mitgegeben werden muss gleich sein.
     * 
     * @param tablenName
     *            Der Tabellenname
     * @param attributes
     *            Alle Attribute die hinzugefgt werden sollen.
     * @param values
     *            Alle Werte die eingefgt werden sollen
     * @return
     */
    public String createSimpleInsertStatement(String tableName, String attributes[],
            String values[]) {
        if (attributes.length != values.length) {
            return null;
        }
        
        // Erstelle einen String-Buffer um dynamisch Zeilen hinzufgen zu knnen.
        StringBuffer sql = new StringBuffer();
        
        // Statment Anfang
        sql.append("INSERT INTO " + tableName + "( ");
        // schreibe alle Attribute
        for (int i = 0; i < attributes.length; i++) {
            sql.append("`" + attributes[i] + "` ");
            // Schreibe nur ein Komma wenn nicht letztes Attribut
            if (i != attributes.length - 1)
                sql.append(" ,");
        }
        sql.append(")");
        
        // Schreibe alle Werte
        sql.append("VALUES (");
        for (int i = 0; i < values.length; i++) {
            // Wenn Wert nicht null ist
            if (values[i] != null) {
                sql.append("'" + values[i] + "' ");
            }
            else {
                sql.append(" NULL");
            }
            // Schreibe nur ein Komma wenn nicht letztes Attribut
            if (i != values.length - 1)
                sql.append(" ,");
        }
        
        // Schliee Statement
        sql.append(")");
        
        return sql.toString();
    }
    


    /**
     * Diese Methode erstellt ein Update Statement das MysQL konform ist. Die Anzahl der Werte und Attribute die mitgegeben werden muss gleich sein. Auerdem muss die Reihenfolge der Attribute und der
     * Werte im String gleich sein!
     * 
     * @param tablenName
     *            Der Tabellenname
     * @param updateCritera
     *            Der Spaltenname anhand dessen die Daten gendert werden sollen (berlicherweise id)
     * @param updateValue
     *            Der Wert fr den Spaltennamen anhand dessen die Informationen gendert werden
     * @param attributes
     *            Alle Attribute die hinzugefgt werden sollen.
     * @param values
     *            Alle Werte die eingefgt werden sollen
     * @return
     */
    public String createSimpleUpdateStatement(String tableName, String updateCritera,
            String updateValue, String attributes[], String values[]) {
        if (attributes.length != values.length) {
            return null;
        }
        
        // Erstelle einen String-Buffer um dynamisch Zeilen hinzufgen zu knnen.
        StringBuffer sql = new StringBuffer();
        
        // Statment Anfang
        sql.append("UPDATE " + tableName + " SET ");
        // schreibe alle Attribute und die zubernehmenden Werte
        for (int i = 0; i < attributes.length; i++) {
            sql.append("`" + attributes[i] + "` = '" + values[i] + "' ");
            // Schreibe nur ein Komma wenn nicht letztes Attribut
            if (i != attributes.length - 1)
                sql.append(" ,");
        }
        sql.append("WHERE ");
        
        // Verarbeite Bedingung
        sql.append("`" + updateCritera + "` =" + updateValue);
        
        return sql.toString();
    }
    


    /**
     * Diese Methode kann aus einem Resultset eine User-Bean erstellen
     * 
     * @param rs
     * @param userId
     *            Der Parameter kann bereits bergeben werden (falls z.B) ein User anhand einer Id gefunden wurde, wird null bergeben wird die BenutzerId aus dem Resultset bernommen.
     * @return Eine gefllte User-Bean
     */
    public User createUserFromResultset(ResultSet rs, String userId) {
        // Erstelle UserBean
        User userInformation = null;
        // bernehme UserId oder nicht?
        try {
            
            if (userId != null) {
                userInformation = new User(rs.getString(userNickName), rs.getInt(userPassword),
                        Integer.parseInt(userId));
            }
            else {
                userInformation = new User(rs.getString(userNickName), rs.getInt(userPassword),
                        rs.getInt(this.userId));
            }
            
            // Flle UserBean
            userInformation.setCity(rs.getString(userCity));
            userInformation.setCourse(rs.getString(userCourse));
            userInformation.setFirstName(rs.getString(userFirstName));
            userInformation.setHobby(rs.getString(userHobby));
            userInformation.setLastName(rs.getString(userLastName));
            userInformation.setMobile(rs.getString(userMobile));
            userInformation.setEMail(rs.getString(userEmail));
            userInformation.setProfilePictureLink(rs.getString(userProfilePictureLink));
            userInformation.setStatusMessage(rs.getString(userStatusMessage));
            
        }
        catch (Exception e) {
            // TODO: handle exception
        }
        
        return userInformation;
    }
    
}
