package de.hwrBerlin.hwrchat.server.dbconnection;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 * @author Nico Smeenk
 * 
 * Diese Klasse stellt verschiedene Methoden bereit,
 * um sich mit einer Datenbank zu verbinden und Abfragen auszufhren.
 * 
 */
public class DBConnection {
    
    /** Verbindung bereitstellen*/
    private Connection _connection;
    
    //Default-Konstanten
    static final String DEFAULT_PATH = "//localhost/dbmanage";
    static final String DEFAULT_USERNAME = "root";
    static final String DEFAULT_USERPASSWORD = "admin";
    
    /**
     * Erstellt die Verbindung, mit dem Passwort "admin",
     * dem default-Username und zum default-Pfad.
     * @return true, wenn erfolgreich verbunden, false wenn nicht.
     */
    public boolean connect() {
        return (connect(DEFAULT_USERPASSWORD));
    }
    


    /**
     * Erstellt die Verbindung, mit dem Default-Username
     * und zum default-Pfad.
     * @param pPassword
     *            Passwort mit dem sich zu der Datenbank verbunden werden soll.
     * @return true, wenn erfolgreich verbunden, false wenn nicht.
     */
    public boolean connect(String pPassword) {
        return (connect(DEFAULT_PATH, DEFAULT_USERNAME, pPassword));
    }
    


    /**
     * Erstellt die Verbindung mit konfigurierbarem
     * Passwort, Benutzernamen und Pfad
     * 
     * @param pPassword
     *            Passwort mit dem sich zu der Datenbank verbunden werden soll.
     
     * @param pPath
     *            Pfad zur Datenbank
     * @param pUser
     *          Username mit dem sich zu der Datenbank verbunden werden soll.
     * @return true, wenn erfolgreich verbunden, false wenn nicht.
     * 
     */
    public boolean connect(String pPath, String pUser, String pPassword) {
        try {
            Class.forName("org.gjt.mm.mysql.Driver").newInstance();
        }
        catch (Exception e) {
            // sollte nie ausgelst werden
            System.out.println(this.getClass() + "No driver package available");
            e.printStackTrace();
            return false;
        }
        try {
            _connection = DriverManager.getConnection("jdbc:mysql://" + pPath, pUser, pPassword);
            System.out.println(this.getClass() + "Connected to data base '" + pPath + "' with the user '" + pUser + "'");
            return true;
        }
        catch (SQLException e) {
            // Verbindung nicht mglich
            System.out.println(this.getClass() + "Can not connect to DB with the given parameters");
            e.printStackTrace();
            return false;
        }
    }
    


    /**
     * Erstellt eine Abfrage an die DB (Select-Statements etc.)
     * 
     * @param pQuary
     *            Abfrage
     * @return Ergebnisse
     */
    public ResultSet queryGet(String pQuary) {
        if (_connection == null) {
            return null;
        }
        System.out.println(this.getClass() + "Quary: " + pQuary);
        try {
            return _connection.createStatement().executeQuery(pQuary);
        }
        catch (SQLException e) {
            System.out.println(this.getClass() + "SQL query is not valid!");
            e.printStackTrace();
            return null;
        }
    }
    


    /**
     * Erstellt ein Update an die DB (Insert-Statements, Updates, etc.)
     * 
     * @param pQuary
     *            Abfrage
     */
    public void queryUpdate(String pQuary) {
        if (_connection != null) {
            System.out.println(this.getClass() + "Quary: " + pQuary);
            try {
                _connection.createStatement().executeUpdate(pQuary);
            }
            catch (SQLException e) {
                System.out.println(this.getClass() + "SQL query is not valid!");
                e.printStackTrace();
            }
        }
    }
    


    /**
     * Gibt zurck ob eine Verbindung besteht
     */
    public boolean isConnected() {
        if (_connection == null) {
            return false;
        }
        return true;
    }
}
