package de.hwrBerlin.hwrchat.server;

//import java.awt.BorderLayout;
import java.io.ObjectOutputStream;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import de.hwrBerlin.hwrchat.clientTest.controller.ConfigManager;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.AMessage;
import de.hwrBerlin.hwrchat.server.data.ServerDataDAO;
import de.hwrBerlin.hwrchat.server.shell.CommandShell;
import de.hwrBerlin.hwrchat.server.shell.commands.ListGroupCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.ListUserCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.RegisterUserCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.RemoveGroupCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.RemoveUserCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.ResetPasswordCommand;
import de.hwrBerlin.hwrchat.server.shell.commands.UserInformationCommand;

/**
 * Dieser Server soll die Basis des HWR-Chats bilden. Es sollen Clienten aufgenommen und verwaltet werden. Textnachrichten sollen vom Sender zum Empfnger geleitet werden
 * 
 * @author Benni
 * 
 */
public class Server {
    
    /*
     * Diese Map soll eine Zuordnung zwischen User Id und einem OutputStream realisieren um spter ganz einfach Nachrichten zu versenden
     */
    private Map<Integer, ObjectOutputStream> _clientWriter;
    
    // Die KommandoShell
    private CommandShell _commandShell;
    
    // Serverport
    static public int _port;
    
    // Datenstruktur
    private static ServerDataDAO _dataObject;
    
    //Hier werden Nutzern eine Liste von OfflineNachrichten zugeordnet
    private static Map<Integer, List<AMessage>> _offlineMessages;
    
    public static Map<String, String> configs;
    
    
    

   



    public static void main(String[] args) {
        try {
            // Lese den Server-Port aus der Config
            ConfigManager configManager = new ConfigManager(true);
            configs = configManager.readConfig();
            String serverPort = configs.get("ServerPort");
            _port = Integer.parseInt(serverPort);
            
            try {
                // Starte die interne Datenverarbeitung
                _dataObject = new ServerDataDAO();
                
                 //Flle die Offline Messages Map mit leeren Listen
                _offlineMessages = new HashMap<Integer, List<AMessage>>();
                for (User knownUser : _dataObject.getKnownUserList()) {
                    List<AMessage> dummyList = new ArrayList<AMessage>();
                    System.out.println("Erstelle Offline Platz fr :"+knownUser.getId());
                    _offlineMessages.put(knownUser.getId(), dummyList);
                }
                
                // Starte die Server-Routine
                new Server();
            }
            catch (Exception e) {
                e.printStackTrace();
                Display display = new Display();
                Shell shell = new Shell(display);
                MessageBox msgBox = new MessageBox(shell, SWT.ICON_ERROR);
                msgBox.setMessage("Beim Verbinden mit der Datenbank kam es zu einem Fehler, bitte Einstellungen berprfen");
                msgBox.setText("Datenbankfehler");
                msgBox.open();
                
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Display display = new Display();
            Shell shell = new Shell(display);
            MessageBox msgBox = new MessageBox(shell, SWT.ICON_ERROR);
            msgBox.setMessage("Beim einlesen der Konfiguration ist etwas schief gelaufen, bitte berprfen Sie die server.conf");
            e.printStackTrace();
            msgBox.setText("Konfigurationsfehler");
            msgBox.open();
        }
    }
    


    /**
     * Konstruktor
     */
    public Server() {
        
        // Initialisiere Konsole
        Display display = new Display();
        Shell shell = new Shell(display);
        
        
        
        
        // Starte den Server Thread
        Thread serverThread = new Thread(new Runnable() {
            @Override
            public void run() {
                runServer();
            }
        });
        serverThread.start();
        
        // Es werden die Commands fr die Shell definiert.
        _commandShell = new CommandShell(shell);
        String[] list = { "listUsers" };
        _commandShell.defineCommand(list, "Lists all users from the model.", false,
                new ListUserCommand());
        String[] register = { "register", "<name>", "<email>" };
        _commandShell.defineCommand(register, "Register a User to Database", false,
                new RegisterUserCommand());
        String[] getUser = { "getUser", "<id>" };
        _commandShell.defineCommand(getUser, "Shows the user with the given id.", false,
                new UserInformationCommand());
        String[] listGroups = { "listGroups" };
        _commandShell.defineCommand(listGroups, "Shows all groups from the model.", false,
                new ListGroupCommand());
        String[] resetPassword = { "resetPassword", "<id>" };
        _commandShell.defineCommand(resetPassword, "Resets password for the given user id", false,
                new ResetPasswordCommand());
        String[] removeUser = { "removeUser", "<id>" };
        _commandShell.defineCommand(removeUser, "Removes User for the given user id", false,
                new RemoveUserCommand());
        String[] removeGroup = { "removeGroup", "<id>" };
        _commandShell.defineCommand(removeGroup, "Removes Group for the given group id", false,
                new RemoveGroupCommand());
        shell.open();
        
        while (!shell.isDisposed()) {
            if (!display.readAndDispatch()) {
                display.sleep();
            }
        }
        display.dispose();
        System.out.println("Beende den Thread");
        System.exit(0);
    }
    


    // Diese Methode luft die ganze Zeit
    public void runServer() {
        
        // Initalisiere Hashmap fr OnlineHAndlung        
        _clientWriter = new HashMap<Integer, ObjectOutputStream>();
        
        try {
            // Initialisiere den eigenen ServerSocket
            ServerSocket serverSock = new ServerSocket(_port);
            
            // Warte auf Verbindung (endlos)
            while (true) {
                // Kann die Verbindung hergestellt werden? Blocke bis Verbindung aktiv
                Socket clientSocket = serverSock.accept();
                
                // Wenn Verbindung erhalten dann erffne einen neuen Thread fr den Benutzer
                Thread t = new Thread(new ClientHandler(clientSocket, this));
                t.start();
                
                // Gebe Nachricht auf Konsole aus
                _commandShell.write("Es wurde eine Verbindung festgestellt: "
                        + clientSocket.getInetAddress());
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
    


   



    // /////////////////Getter/Setter////////////////////////
    public Map<Integer, ObjectOutputStream> getClientWriter() {
        return _clientWriter;
    }
    


    public CommandShell getCommandShell() {
        return _commandShell;
    }
    


    public static int getPort() {
        return _port;
    }
    


    public static ServerDataDAO getDataObject() {
        return _dataObject;
    }
    
        
    public static Map<Integer, List<AMessage>> getOfflineMessages() {
        return _offlineMessages;
    }
    
}
