package de.hwrBerlin.hwrchat.server;

import java.util.Properties;

import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
 
/**
 * @author zeja
 */
public class EMailSender {
    
    public void sendEMail(String pSmtpHost, String pUsername, String pPassword, String pSenderAddress, String pRecipientsAddress, String pSubject, String pText, Boolean pNeedAuth){
        MailAuthenticator auth = new MailAuthenticator(pUsername, pPassword);
 
        Properties properties = new Properties();
 
        // ServerAdresse wird den Properties hinzugefgt
        properties.put("mail.smtp.host", pSmtpHost);
 
        // Falls der SMTP-Server eine Authentifizierung verlangt
        String needAuthString;
        if(pNeedAuth){
            needAuthString = "true";
        }
        else{
            needAuthString = "false";
        }
        properties.put("mail.smtp.auth", needAuthString);
 
        // Session erzeugt
        Session session = Session.getDefaultInstance(properties, auth);
 
        try {
            // Message erzeugen
            Message msg = new MimeMessage(session);
 
            // Absender- und Empfngeradressen gesetzt
            msg.setFrom(new InternetAddress(pSenderAddress));
            msg.setRecipients(Message.RecipientType.TO, InternetAddress.parse(pRecipientsAddress, false));
 
            // Betreff und Body der Message werden gesetzt
            msg.setSubject(pSubject);
            msg.setText(pText);
 
            // Mail verschickt
            Transport.send(msg);
 
        }
        catch (Exception e) {
            e.printStackTrace( );
        }
    }
    
    class MailAuthenticator extends Authenticator {
 
        /**
         * Ein String, der den Usernamen nach der Erzeugung eines
         * Objektes<br>
         * dieser Klasse enthalten wird.
         */
        private final String user;
 
        /**
         * Ein String, der das Passwort nach der Erzeugung eines
         * Objektes<br>
         * dieser Klasse enthalten wird.
         */
        private final String password;
 
        /**
         * Der Konstruktor erzeugt ein MailAuthenticator Objekt<br>
         * aus den beiden Parametern user und passwort.
         * 
         * @param user
         *            String, der Username fuer den Mailaccount.
         * @param password
         *            String, das Passwort fuer den Mailaccount.
         */
        public MailAuthenticator(String user, String password) {
            this.user = user;
            this.password = password;
        }
 
        /**
         * Diese Methode gibt ein neues PasswortAuthentication
         * Objekt zurueck.
         * 
         * @see javax.mail.Authenticator#getPasswordAuthentication()
         */
        protected PasswordAuthentication getPasswordAuthentication() {
            return new PasswordAuthentication(this.user, this.password);
        }
    }
    
    public static void main(String[] args) {

        String username = "";
        String password = "";
        String senderAddress ="servus@lisa-debian-server.dyndns.org";
        String recipientsAddress = "p.servus.servus@googlemail.com";
        String subject = "Java-Test";
        String text = "text";
        String smtpHost = "lisa-debian-server.dyndns.org";
        Boolean needAuth = false;
        
        new EMailSender().sendEMail(smtpHost, username, password, senderAddress, recipientsAddress, subject, text, needAuth);
    }
}