package de.hwrBerlin.hwrchat.server;

//import java.awt.BorderLayout;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import com.sun.mail.handlers.message_rfc822;

import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.Status;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.AMessage;
import de.hwrBerlin.hwrchat.model.messages.ChangeStatusMessage;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FindGroupRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GetAllGroupsRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GetAllUsersRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.OpenGroupMessage;
import de.hwrBerlin.hwrchat.model.messages.RegisterRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;
import de.hwrBerlin.hwrchat.server.data.ServerDataDAO;
import de.hwrBerlin.hwrchat.server.shell.CommandShell;

/**
 * Der ClientHandler soll repsentativ fr eine Client Verbindug stehen
 * 
 * @author Benni
 * 
 */

public class ClientHandler implements Runnable {
    
    // Der Inputstream fr Objekte
    ObjectInputStream objectInputStream;
    
    // Ouput Stream um wieder an den Clieneten zurckzuschreiben
    ObjectOutputStream writer;
    Socket socket;
    
    // Das Server Object und dessen Attribute um diese einfach zu benutzen
    Server server;
    
    private CommandShell _commandShell;
    
    // Serverport
    private int _port;
    
    // Datenstruktur
    private ServerDataDAO _dataObject;
    
    //Zuordnuung die einem User einen Writer zuordnet, damit gezielt an diesen Benutzen geschrieben werden kann.
    private Map<Integer, ObjectOutputStream> _clientWriter;
    
    // Die UserId mit dem dieser Socket verknpft ist
    int myUserId = -1;
    
    //Hier werden Nutzern eine Liste von OfflineNachrichten zugeordnet
    private Map<Integer, List<AMessage>> _offlineMessages;
    
    
    
    /**
     * Der Konstuktor bernimmt die Server instanz und den socket den er bearbeiten soll.
     * 
     * @param clientSocket
     * @param pServer
     */
    public ClientHandler(Socket clientSocket, Server pServer) {
        
        server = pServer;
        _commandShell = server.getCommandShell();
        _port = server.getPort();
        _dataObject = server.getDataObject();
        _clientWriter = server.getClientWriter();
        _offlineMessages = server.getOfflineMessages();
        
        
        
        // bernehme den Socket und den Server
        try {
            socket = clientSocket;
            writer = new ObjectOutputStream(socket.getOutputStream());
            // Mache den InputStream auf
            objectInputStream = new ObjectInputStream(socket.getInputStream());
        }
        catch (Exception ex) {
            _commandShell.write("Verbindung wurde unterbrochen");
        }
    }
    
    
    
    // Diese Routine luft immer durchm hier knnen Objekte empfangen werden
    public void run() { 
        try {
            if (!socket.isClosed()) {
                
                // lese vom Input Steam
                Object receivedObject = null;
                
                while ((receivedObject = objectInputStream.readObject()) != null) {
                    
                    
                    // Wurde ein login-Versuch unternommen?
                    if (receivedObject instanceof ConnectionRequestMessage) {
                        loginHandler((ConnectionRequestMessage) receivedObject);                        
                    }
                    
                    
                    // Wurde eine Textnachricht versand? 
                    else if (receivedObject instanceof TextMessage) {
                        TextMessage message = (TextMessage) receivedObject;
                        TextMessageHandler(message);
                    }
                    
                    
                    // Wird eine Freundschaftsanfrage gestellt / beantwortet ?
                    else if (receivedObject instanceof FriendshipRequestMessage) {
                        FriendshipRequestMessage message = (FriendshipRequestMessage) receivedObject;
                        friendshipRequestHandler(message);
                    }
                    
                    // Wird versucht die client seitigen Kontaktdaten(oder auch das Passwort) zu ndern?
                    else if (receivedObject instanceof UpdatedAdressMessage) {
                        UpdatedAdressMessage message = (UpdatedAdressMessage) receivedObject;
                        // Wurden eigentlich Daten bergeben? Das Empfnger Attribut enthlt die neue User Bean
                        if (message.getCurrentAdress() != null) {
                            _dataObject.updateUser((User) message.getCurrentAdress());
                            
                            // Setze online Freunde ber eine nderung in Kenntnis
                            updateFriends(myUserId);
                        }
                    }
                    
                    
                    // Soll der Status gendet werden? Offline = close
                    // socket!
                    else if (receivedObject instanceof ChangeStatusMessage) {
                        ChangeStatusMessage message = (ChangeStatusMessage) receivedObject;
                        _dataObject.getUserById(myUserId).setStatus(message.getStatus());
                        // Setze online Freunde ber eine nderung in Kenntnis
                        updateFriends(myUserId);
                        if (message.getStatus().equals(Status.OFFLINE)) {
                            _dataObject.getUserById(myUserId).setStatus(Status.OFFLINE.toValue());
                            _clientWriter.remove(myUserId);
                            Thread.currentThread().stop();
                            socket.close();
                        }
                    }
                    
                    // Soll eine neue Gruppe erstellt werden? Founder =
                    // Sender
                    else if (receivedObject instanceof OpenGroupMessage) {
                        OpenGroupMessage message = (OpenGroupMessage) receivedObject;
                        // Trage die Gruppe ein, wenn der Sender nicht leer
                        // ist
                        if ((message.getSender() != null) && (message.getGroup() != null)) {
                            Group group = message.getGroup();
                            group.setFounder((User) message.getSender());
                            // Trage Gruppe ein und sage dass der Founder auch in die Gruppe gehrt
                            int groupId = _dataObject.insertGroup(message.getGroup());
                            _dataObject.attendGroup(message.getSender().getId(), groupId);
                            
                            updateGroupUsers(groupId);
                        }
                    }
                    
                    // Wird eine Anfrage gestellt ob ein Nutzer einer Gruppe beitreten will?
                    else if (receivedObject instanceof GroupAttendRequestMessage) {
                        GroupAttendRequestMessage message = (GroupAttendRequestMessage) receivedObject;
                        groupAttendHandler(message);
                    }
                    
                    // Wird eine Suchanfrage fr einen Nutzer gestellt?
                    else if (receivedObject instanceof FindUserRequestMessage) {
                        FindUserRequestMessage message = (FindUserRequestMessage) receivedObject;
                        // Suche die User, setze gleich in die Message ein und schicke zurck
                        message.setFoundUser(_dataObject.searchForUsers(message.getSearchUserName()));
                        // Woher kam die Message, an die Adresse soll die auch zurckgehen
                        int recieverId = message.getSender().getId();
                        
                        // Leite die gefllte message einfach weiter
                        if (_clientWriter.containsKey(recieverId)) {
                            _clientWriter.get(recieverId).writeObject(message);
                        }
                        
                    }
                    
                    
                    // Wird eine Anfrage zum Dateitransfer verschickt?
                    else if (receivedObject instanceof FileTransferRequestMessage) {
                        FileTransferRequestMessage message = (FileTransferRequestMessage) receivedObject;                        
                        fileTransferRequestHandler(message);
                        
                    }
                    
                    
                    /////////////////////////////////Methoden die nicht benutzt werden//////////////////////////
                    // Wurde ein Registrierungsversuch unternommen?
                    else if (receivedObject instanceof RegisterRequestMessage) {
                        
                        // Checke Registerversch
                        RegisterRequestMessage serverRegisterStatusMessage = registerHandler((RegisterRequestMessage) receivedObject);
                        
                        // Schreibe wieder zurck (wenn erfolgreich dann mit
                        // User und Userid und ohne Fehlermeldung
                        writeObjectToSocket(serverRegisterStatusMessage);
                    }
                    
                    // Wird eine Suchanfrage fr eine Gruppe gestellt?
                    else if (receivedObject instanceof FindGroupRequestMessage) {
                        FindGroupRequestMessage message = (FindGroupRequestMessage) receivedObject;
                        // Suche die Gruppe, setze gleich in die Message ein und schicke zurck
                        message.setFoundGroup(_dataObject.searchForGroups(message.getSearchGroupName()));
                        // Woher kam die Message, an die Adresse soll die auch zurckgehen
                        int recieverId = message.getSender().getId();
                        
                        // Leite die gefllte message einfach weiter
                        if (_clientWriter.containsKey(recieverId)) {
                            _clientWriter.get(recieverId).writeObject(message);
                        }                        
                    }
                    
                    // Wurde eine Auflistung aller User verlangt?
                    else if (receivedObject instanceof GetAllUsersRequestMessage) {
                        GetAllUsersRequestMessage message = (GetAllUsersRequestMessage) receivedObject;
                        // Kopiere alle bekannten User da rein
                        message.setAllUsers(_dataObject.getKnownUserList());
                        // sende die Message wieder zurck an den Client
                        writeObjectToSocket(message);
                    }
                    
                    // Werden Gruppen verlangt?
                    else if (receivedObject instanceof GetAllGroupsRequestMessage) {
                        GetAllGroupsRequestMessage message = (GetAllGroupsRequestMessage) receivedObject;
                        // Hole alle Gruppen und Sende zurck
                        message.setAllGroups(_dataObject.getKnownGroupList());
                        writeObjectToSocket(message);
                    }
                    /////////////////////////////////Ende des Messages auswerten//////////////////////////
                }
                
                receivedObject = null;
            }
            
        }
        // Der Socket schmiert ab, weil der Client einfach reinhaut
        catch (Exception e) {
            //e.printStackTrace();
            _commandShell.write("Verbindung wurde unterbrochen");
            /*
             * Setze den UserStatus auf Offline (wenn User erfolgreich eingeloggt wurde) und entferne aus der writerListe,
             * benachrichtige auch die Freunde
             */
            if (myUserId != -1) {
                _dataObject.getUserById(myUserId).setStatus(Status.OFFLINE.toValue());
                updateFriends(myUserId);
                _clientWriter.remove(myUserId);
                Thread.currentThread().stop();
            }
            
            try {
                socket.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        
//        catch (NullPointerException e) {
//
//        }
//        
//        catch (ClassNotFoundException e) {
//
//        }
//        
//        catch (IOException e) {
//
//        }
        
    }



    /**
     * Bearbeitet eine Dateiversandanfrage
     * @param message
     * @throws IOException
     */
    private void fileTransferRequestHandler(FileTransferRequestMessage message) throws IOException {
        int recieverId = message.getAddressee().getId();
        
        // Die Anfrage ist inital, leite einfach weiter, wenn fileName nicht null ist!
        if (!message.isReverseRelation()) {
            if (message.getRequestFile().getName() != null) {
                if (_clientWriter.containsKey(recieverId)) {
                    _clientWriter.get(recieverId).writeObject(message);
                }
                
            }
        }
        // Die Anfrage kommt vom angfragten Client zurck
        else {
            // Ist die Anfrage angenommen worden?
            if (message.isValidated()) {
                // Wenn ja dann schicke die Nachricht an den ursprnglichen User und zwar mit der Ip, die der Sender dieser Message hat
                // und die ist ja ber den socket bekannt
                message.setIpAdressFromOriginalReciever(socket.getInetAddress());
                _commandShell.write(message.getSender()+"will eine Datei verschicken an die Ip:"+message.getIpAdressFromOriginalReciever()+" mit dem Port: " + message.getFileTransferPort());
                if (_clientWriter.containsKey(recieverId)) {
                    _clientWriter.get(recieverId).writeObject(message);
                }
            }
        }
    }



    /**
     * Bearbeitet das Hinzufgen in eine Gruppe
     * @param message
     * @throws IOException
     */
    private void groupAttendHandler(GroupAttendRequestMessage message) throws IOException {
       
        int requesterId = message.getSender().getId();
        
        // Wenn die Anfrage gestellt wird dann leite einfach weiter!
        if (!message.isReverseRelation()) {
            int recipientId = message.getAddressee().getId();
            // Prfe ob der Nutzer schon in der Gruppe ist, wenn nicht dann sende anfrage
            if (!_dataObject.userIsInGroup(recipientId, message.getGroup().getId())) {
                if (_clientWriter.containsKey(recipientId)) {
                    _clientWriter.get(recipientId).reset();
                    _clientWriter.get(recipientId).writeObject(message);
                    _commandShell.write(message.getSender().getName() + "sendet weiter an id: " + recipientId);
                }
                // User ist offline
                else {
                    _offlineMessages.get(recipientId).add(message);
                }
            }
        }
        // Die Anfrage kommt wieder zurck
        else {
            _commandShell.write(message.getSender().getName() +"hat zurckgeschrieben:");
            // Es wurde angenommen
            if (message.isValidated()) {                
                _dataObject.attendGroup(requesterId, message.getGroup().getId());
                // Informiere Gruppenmitglieder
                updateGroupUsers(message.getGroup().getId());
            }
        }
    }
    
    
    
    /** Diese Methode verschickt die TextNachrichten     * 
     * @param message
     * @throws IOException
     */
    private void TextMessageHandler(TextMessage message) throws IOException {
        // An wen soll die gehen?
        int recieverId = message.getAddressee().getId();
        
        // Unterscheide, ob die Message an einen User oder eine Gruppe gehen soll
        if (message.getAddressee() instanceof Group) {
            Group sendToGroup = _dataObject.getGroupById(recieverId);
            for (User groupUser : sendToGroup.getUser()) {
                // Leite an den GroupUser wenn online und wenn nicht der Sender
                if (_clientWriter.containsKey(groupUser.getId()) && groupUser.getId() != message.getSender().getId()) {
                    _clientWriter.get(groupUser.getId()).writeObject(message);
                }
            }
        }
        else {
            // Leite Sie einfach an den User weiter, wenn online wenn nicht speichere Offline Message
            if (_clientWriter.containsKey(recieverId)) {
                _clientWriter.get(recieverId).writeObject(message);
            }
            else {
                _offlineMessages.get(recieverId).add(message);
            }
        }
    }
    
    
    
    /**
     * Methode handelt eine Freundschaftsanfrage und erkennt,
     * ob es eine echte Anfrage ist, oder es sich um eine Antwort auf
     * diese handelt.
     * 
     * @param message
     * @throws IOException
     */
    private void friendshipRequestHandler(FriendshipRequestMessage message) throws IOException {
        int requesterId = message.getSender().getId();
        int recipientId = message.getAddressee().getId();
        // Die Message kommt vom Anfragenden, trage umgehend Relation in eine Richtung ein
        if (!message.isReverseRelation()) {
            
            // trage nur ein, wenn die sich nicht kennen!
            if (!_dataObject.userKnowsUser(requesterId, recipientId)) {
                _dataObject.addUserKnowsUserRelation(requesterId, recipientId);
                // Sende weiter
                if (_clientWriter.containsKey(recipientId)) {
                    _clientWriter.get(recipientId).writeObject(message);
                }
                // User ist offline oder ihn gibts garnicht
                else {
                    _offlineMessages.get(recipientId).add(message);
                }
            }
        }
        // Die Message kommt vom Angefragten und hlt nun eine Antwort bereit
        else {
            // Der USer hat akzeptiert, trage Relation ein (Sender und Empfnger sind nun umgedreht)
            if (message.isValidated()) {
                _dataObject.addUserKnowsUserRelation(requesterId, recipientId);
                // Aktualisere die Freunde an beide
                updateFriends(recipientId);
                updateFriends(requesterId);
                
            }
            // Anfrage wurde abgelehnt, entferne die umgekehrte Relation, weil diese ja bereits eingetragen wurde
            else {
                _dataObject.removeUserKnowsUserRelation(recipientId, requesterId);
            }
        }
    }
    
    
    
    /**
     * Diese Methode versucht den Login vorzunehmen Ist der UserName und Passwort korrekt, wird eine neue ConnectionReuestMessage zurckgegeben und zwar mit dem gefundenen User-Object als
     * Empfnger
     * 
     * @param loginMessage
     * @return ConnectionRequestMessage
     */
    private void loginHandler(ConnectionRequestMessage loginMessage) {
        // Hole Daten aus der Message
        User userData = (User) loginMessage.getSender();
        String nickname = userData.getName();
        int password = userData.getPassword();
        
        // Message die Spter zurckggeben wird
        ConnectionRequestMessage connectionMessage = new ConnectionRequestMessage();
        
        // Versuche den Nutzernamen zu finden
        User loginUser = _dataObject.getUserByName(nickname);
        // Es wurde ein Benutzer gefunden
        if (loginUser != null) {
            
            // Passwort ist auch richtig
            if (loginUser.checkPassword(password)) {
                // Ist der Benutzer bereits online?
                if (_dataObject.getUserById(loginUser.getId()).getStatus().equals(Status.ONLINE.toValue()) || _dataObject.getUserById(loginUser.getId()).getStatus().equals(Status.AWAY.toValue())) {
                    // Erstelle message mit dem alten User, Ein User ist bereits eingeloggt
                    connectionMessage.setAddressee(null);
                    connectionMessage.setErrorMessage("User ist bereits eingeloggt");
                }
                else {
                    // Erstelle message mit dem gefundenen User
                    connectionMessage.setAddressee(loginUser);
                    // Setze status aus Online
                    loginUser.setStatus(Status.ONLINE.toValue());
                    _commandShell.write("User " + loginUser.getName() + " ist online");
                    // Ordne die UserId in den Clientwriter ein und lese User aus um Id zu bekommen
                    
                    // Ordne die UserId in den Clientwriter ein und lese User aus um Id zu bekommen
                    User foundUser = (User) connectionMessage.getAddressee();
                    // Setze die id, damit der thread wei welche id er hat!
                    myUserId = foundUser.getId();
                    _clientWriter.put(myUserId, writer);
                    
                    // Setze online Freunde ber eine nderung in Kenntnis
                    updateFriends(myUserId);
                }
                
            }
            else {
                // Erstelle message mit dem alten User
                connectionMessage.setAddressee(null);
                connectionMessage.setErrorMessage("Passwort falsch");
            }
        }
        // Es gibt keinen User mit diesem Namen
        else {
            // Erstelle message mit dem alten User
            connectionMessage.setAddressee(null);
            connectionMessage.setErrorMessage("Nutzername gibt es nicht");
        }
        
        // Gebe Message wieder aus
        writeObjectToSocket(connectionMessage);
        
        //Komplette Offline Nachrichtensammlung senden
        if(_offlineMessages.containsKey(myUserId)) {
            for(AMessage offlineMessage : _offlineMessages.get(myUserId)) {
                try {
                    Thread.currentThread().sleep(50);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                
                try {
                    _clientWriter.get(myUserId).reset();
                    _clientWriter.get(myUserId).writeObject(offlineMessage);
                }
                catch (IOException e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
            }
        }
        
        //Neue (leere) OfflineMessage Liste erstellen und einreihen
        List<AMessage> offlineMessagesList = new ArrayList<AMessage>();             
        _offlineMessages.remove(myUserId);
        _offlineMessages.put(myUserId, offlineMessagesList);
    }
    
    
    
    /**
     * Diese Methode verwaltet einen Registerversuch
     * 
     * @param receivedObject
     * @return
     */
    private RegisterRequestMessage registerHandler(RegisterRequestMessage registerMessage) {
        // Hole Daten aus der Message
        User userData = (User) registerMessage.getSender();
        String nickname = userData.getName();
        
        // Message die Spter zurckggeben wird
        RegisterRequestMessage returnMessage;
        
        // Versuche den Nutzernamen zu finden, falls nicht vergeben trage in
        // die Datenbank ein
        User loginUser = _dataObject.getUserByName(nickname);
        // Es wurde kein Benutzer gefunden
        if (loginUser == null) {
            // Trage Bean in die Datenstruktur ein und bernehme Id
            int id = _dataObject.insertUser(userData);
            userData.setId(id);
            returnMessage = new RegisterRequestMessage();
            returnMessage.setAddressee(userData);
        }
        
        else {
            // Username vergeben, setze error Message
            returnMessage = new RegisterRequestMessage();
            returnMessage.setAddressee(null);
            returnMessage.set_errorMessage("Username ist bereits vergeben");
        }
        
        // Gebe Message wieder aus
        return returnMessage;
        
    }
    
    
    
    /*
     * Diese Methode aktualisiert die Freundesliste des eigenen Users wenn irgendeine nderung
     * geschehen ist, die andere User sehen sollten
     */
    private void updateFriends(int userId) {
        if (userId < 0) {
            // mache einfach garnix
            return;
        }
        // Hole erstmal eigenen User
        User ownUser = _dataObject.getUserById(userId);
        // sende an jeden User eine Alive Message mit dem User der sich gendert hat
        UpdatedAdressMessage message = new UpdatedAdressMessage();
        message.setCurrentAdress(ownUser);
        
        for (User friendUser : ownUser.getKnowingUsers()) {
            // sende an den User wenn er online ist
            if (_clientWriter.containsKey(friendUser.getId())) {
                try {
                    _clientWriter.get(friendUser.getId()).reset();
                    _clientWriter.get(friendUser.getId()).writeObject(message);                   
                }
                catch (IOException e) {
                    System.out.println("Senden an einen Freund fehlgeschlagen des Users: " + ownUser.getName());
                    e.printStackTrace();
                }
            }
            
        }
        
    }
    
    
    
    /*
     * Diese Methode aktualisiert die Gruppenteilnehmer.
     */
    private void updateGroupUsers(int groupId) {
        if (groupId < 0) {
            // mache einfach garnix
            return;
        }
        // Hole erstmal die Gruppe
        Group ownGroup = _dataObject.getGroupById(groupId);
        // sende an jeden User der zu dieser Gruppe gehrt die Aktuelle Gruppe
        
        UpdatedAdressMessage message = new UpdatedAdressMessage();
        message.setCurrentAdress(ownGroup);
        
        for (User attendsUser : ownGroup.getUser()) {
            // sende an den User wenn er online ist
            if (_clientWriter.containsKey(attendsUser.getId())) {
                try {
                    _clientWriter.get(attendsUser.getId()).reset();
                    _clientWriter.get(attendsUser.getId()).writeObject(message);
                    _commandShell.write("Es wurde die Gruppe " + ownGroup.getId() + " gendert");
                }
                catch (IOException e) {
                    System.out.println("Senden an einen Teilnehmer der Gruppe fehlgeschlagen : " + ownGroup.getName());
                    e.printStackTrace();
                }
            }
            
        }
        
    }
    
    
    
    /*
     * Diese Methode schreibt ein Object an den ClientSocket
     */
    private void writeObjectToSocket(Object object) {
        try {
            writer.reset();
            writer.writeObject(object);
            writer.flush();
            // writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            System.out.println("Konnte das Objekt nicht senden");
        }
        
    }
    
}
