/**
 * 
 */
package de.hwrBerlin.hwrchat.model.messages;

import java.util.ArrayList;
import java.util.List;

import de.hwrBerlin.hwrchat.model.User;

/**
 * @author Benjamin Pfeiffer
 * 
 *        Diese Message wird zum suchen von Usern benutzt,
 *        wurden Nutzer am Server gefunden werden diese in foundUser eingereit.
 *         
 */
public class FindUserRequestMessage extends AMessage {
    
	private String _searchUserName;

	private List<User> foundUser = new ArrayList<User>();

	// stellt fest, ob die Nachricht vom angefragten Client zurckgesendet wurde
	private boolean _isReverseRelation;

	
	
	public boolean isReverseRelation() {
		return _isReverseRelation;
	}

	public void setReverseRelation(boolean isReverseRelation) {
		this._isReverseRelation = isReverseRelation;
	}

	public List<User> getFoundUser() {
		return foundUser;
	}

	public void setFoundUser(List<User> foundUser) {
		this.foundUser = foundUser;
	}

	public void addFoundUser(User pUser) {
		foundUser.add(pUser);
	}

	public String getSearchUserName() {
		return _searchUserName;
	}

	public void setSearchUserName(String pSearchUserName) {
		_searchUserName = pSearchUserName;
	}


	@Override
	public boolean toServer() {
		// TODO Auto-generated method stub
		return true;
	}
	
    
}
