/**
 * 
 */
package de.hwrBerlin.hwrchat.model.messages;

import java.util.ArrayList;
import java.util.List;

import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.User;

/**
 * @author Benjamin Pfeiffer
 * 
 *         Diese Message wird zum Suchen einer Gruppe benutzt.
 *         Gefundene Gruppen werden in einer Liste gespeichert.
 *         
 */
public class FindGroupRequestMessage extends AMessage {
    
	private String _searchGroupName;

	private List<Group> foundGroup = new ArrayList<Group>();

	// stellt fest, ob die Nachricht vom angefragten Client zurckgesendet wurde
	private boolean _isReverseRelation;

	
	
	public boolean isReverseRelation() {
		return _isReverseRelation;
	}

	public void setReverseRelation(boolean isReverseRelation) {
		this._isReverseRelation = isReverseRelation;
	}

	public List<Group> getFoundGroup() {
		return foundGroup;
	}

	public void setFoundGroup(List<Group> foundGroup) {
		this.foundGroup = foundGroup;
	}

	public void addFoundGroup(Group pGroup) {
		foundGroup.add(pGroup);
	}

	public String getSearchGroupName() {
		return _searchGroupName;
	}

	public void setSearchGroupName(String pSearchGroupName) {
		_searchGroupName = pSearchGroupName;
	}


	@Override
	public boolean toServer() {
		// TODO Auto-generated method stub
		return true;
	}
	
    
}
