/**
 * 
 */
package de.hwrBerlin.hwrchat.model.messages;

import java.io.File;
import java.net.InetAddress;

/**
 * @author Benjamin Pfeiffer
 * 
 *         Diese Message soll eine Anfrage stellen um eine Datei zu senden.
 *         Die Anfrage enthlt noch nicht die Datei selbst, sondern "nur"
 *         den Namen und die Dateigre.
 *         Wird die Message angenommen, also validiert, wird vom angefragten
 *         die IP-Adresse mit genommen und ein Port. Fr die Dateibertragung
 *         wird dann direkt eine Peer to Peer Verbindung hergestellt. Aber natrlich nur
 *         wenn die Message auch angenommen wurde.
 *         
 */
public class FileTransferRequestMessage extends AMessage {
    
	//File
    File _requestFile;
    
    //Diese Information gibt den Status der Anfrage wieder (true, wenn angenommen)
	private boolean _isValidated;
	
	//stellt fest, ob die Nachricht vom angefragten Client zurckgesendet wurde
	private boolean _isReverseRelation;
	
	//Portverbindung, die nachher zum Filetransfer benutzt werden soll
	int _fileTransferPort;
	
	//Internetadresse vom ursprngliche Empfnger damit der ursprngliche sende eine neue Socket verbindung aufmachen kann
	InetAddress _ipAdressFromOriginalReciever;

	public File getRequestFile() {
	    return _requestFile;
	}
	
	
	
	public void setRequestFile(File pRequestFile) {
	    _requestFile = pRequestFile;
	}
	

	public InetAddress getIpAdressFromOriginalReciever() {
        return _ipAdressFromOriginalReciever;
    }



    public void setIpAdressFromOriginalReciever(InetAddress pInetAddress) {
        _ipAdressFromOriginalReciever = pInetAddress;
    }






    public int getFileTransferPort() {
        return _fileTransferPort;
    }



    public void setFileTransferPort(int pFileTransferPort) {
        _fileTransferPort = pFileTransferPort;
    }



   



    public boolean isValidated() {
		return _isValidated;
	}



	public void setValidated(boolean isValidated) {
		this._isValidated = isValidated;
	}



	public boolean isReverseRelation() {
		return _isReverseRelation;
	}



	public void setReverseRelation(boolean isReverseRelation) {
		this._isReverseRelation = isReverseRelation;
	}
	
	




	@Override
	public boolean toServer() {
		// TODO Auto-generated method stub
		return true;
	}
	
    
}
