package de.hwrBerlin.hwrchat.model;

import java.util.ArrayList;
import java.util.List;

public class User extends Address {
    
    /** Passwort doppelt Hash verschlsselt */
    private int _password;
    
    /** Status des Nutzers */
    private String _status;
    
    /** Ein Studiengang des Nutzers */
    private String _course;
        
    /** Vorname */
    private String _firstName;
    
    /** Nachname */
    private String _lastName;
    
    /** Ein Hobby */
    private String _hobby;
    
    /** Der Wohnort (Stadt) */
    private String _city;
    
    /** Telefonnummer */
    private String _mobile;
    
    /** E-Mail */
    private String _eMail;
    
    /** ProfilBildLink */
    private String _profilePictureLink;
    
    /** Liste aller Benutzer die dieser User kennt */
    private List<User> _knowingUsers = new ArrayList<User>();
    
    /** Liste aller Gruppen, die dieser Benutzer kennt **/
    private List<Group> _knowingGroups = new ArrayList<Group>();
    
    

    /**
     * Erstellt einen neuen Nutzer mit Nick-Name und Passwort. Dabei muss das Passwort schon einfach verschlsselt sein.
     * 
     * @param pName
     * @param pPasswordHash
     */
    public User(String pName, int pPasswordHash, int pId) {
        super(pId);
        setName(pName);
        _password = (pPasswordHash + "").hashCode();
        _status = Status.OFFLINE.toString();
    }
    


    /**
     * Prft ob ein Passwort richtig ist
     * 
     * @param pPasswordHash
     *            Passwort im einfachen Hash code
     * @return
     */
    public boolean checkPassword(int pPasswordHash) {
        if (_password == (pPasswordHash + "").hashCode()) {
            return true;
        }
        return false;
    }
    



    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(Address pAddress) {
        if (pAddress instanceof User){
            if(getStatus().compareTo(((User) pAddress).getStatus()) == 0){
                return getName().compareTo(pAddress.getName());
            }
            return getStatus().compareTo(((User) pAddress).getStatus());
        }
        return -1;
    }
    
    /**
     * Diese Methode aktualisiert alle Informationen
     * die mit einer UserBean bergeben wurden,
     * die id ndert sich nicht
     * die kennt Beziehung wird auch nicht gendert
     * @param userBean
     */
    public void updateInformations(User pUserBean) {
        setCity(pUserBean.getCity());
        setCourse(pUserBean.getCourse());
        setFirstName(pUserBean.getFirstName());
        setHobby(pUserBean.getHobby());
        setLastName(pUserBean.getLastName());
        setMobile(pUserBean.getMobile());
        setName(pUserBean.getName());
        setPassword(pUserBean.getPassword());
        setProfilePictureLink(pUserBean.getProfilePictureLink());
        setStatus(pUserBean.getStatus());
        setStatusMessage(pUserBean.getStatusMessage());        
        setEMail(pUserBean.getEMail());
    }
    
    
    ////////////////GETTER-SETTER//////////////////////////////////
    
    
    /**
     * get the status
     * 
     * @return
     */
    public String getStatus() {
        return _status;
    }
    

    /**
     * set the status
     * 
     * @param pStatus
     */
    public void setStatus(String pStatus) {
        _status = pStatus;
    }



    public String getCourse() {
        return _course;
    }



    public void setCourse(String pCourse) {
        _course = pCourse;
    }



    public String getFirstName() {
        return _firstName;
    }



    public void setFirstName(String pFirstName) {
        _firstName = pFirstName;
    }



    public String getLastName() {
        return _lastName;
    }



    public void setLastName(String pLastName) {
        _lastName = pLastName;
    }



    public String getHobby() {
        return _hobby;
    }



    public void setHobby(String pHobby) {
        _hobby = pHobby;
    }



    public String getCity() {
        return _city;
    }



    public void setCity(String pCity) {
        _city = pCity;
    }



    public String getMobile() {
        return _mobile;
    }



    public void setMobile(String pMobile) {
        _mobile = pMobile;
    }



    public String getEMail() {
		return _eMail;
	}



	public void setEMail(String pEMail) {
		_eMail = pEMail;
	}



	public String getProfilePictureLink() {
        return _profilePictureLink;
    }



    public void setProfilePictureLink(String pProfilePictureLink) {
        _profilePictureLink = pProfilePictureLink;
    }



    public int getPassword() {
        return _password;
    }
        
        /**
         * set the password
         * 
         * @param pPasswordHash
         *            in einfachem Hashcode
         */
    
    public void setPassword(int pPasswordHash) {
        _password = (pPasswordHash + "").hashCode();
        
    }



    public List<User> getKnowingUsers() {
        return _knowingUsers;
    }
    
    
    
    public void setKnowingUsers(List<User> pKnowingUsers) {
        _knowingUsers = pKnowingUsers;
    }
    
    public void addKnowingUsers(User pKnowingUser) {
        _knowingUsers.add(pKnowingUser);
    }
    
    public void setKnowingGroups(List<Group> pKnowingGroups) {
        _knowingGroups = pKnowingGroups;
    }
    
    public void addKnowingGroup(Group pKnowingGroup) {
    	_knowingGroups.add(pKnowingGroup);
    	
    }
    
    public List<Group> getKnowingGroups() {
        return _knowingGroups;
    }

}
