package de.hwrBerlin.hwrchat.model;

import java.io.Serializable;

/**
 * 
 * @author Nico Smeenk
 * 
 *         Stellt den Status der einzelnen User dar
 * 
 */
public enum Status {
    ONLINE("ONLINE"), AWAY("AWAY"), OFFLINE("OFFLINE");
    
    private final String value;
    
    Status(String value) {  
        this.value = value;  
    } 
    

    public static Status fromValue(String value) {  
        if (value != null) {  
          for (Status status : values()) {  
            if (status.value.equals(value)) {  
              return status;  
            }  
          }  
        } 
        return getDefault(); 
    }
    
    public String toValue() {  
        return value;  
      }  
       
      public static Status getDefault() {  
        return OFFLINE;  
      }  
    
    /*
     * (non-Javadoc)
     * 
     * @see java.lang.Enum#toString()
     */
    public String toString() {
        String output = name().toString();
        output = output.charAt(0) + output.substring(1).toLowerCase();
        
        return output;
    }
    
}
