/**
 * 
 */
package de.hwrBerlin.hwrchat.model;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Nico Smeenk
 * 
 */
public class Group extends Address {
    
    /** Grnder der Gruppe */
    private User _founder;
    
    /** Benutzer die in der Gruppe sind */
    private List<User> _user = new ArrayList<User>();
    
    

    /**
     * Konstruktor fr eine Gruppe
     * 
     * @param pName
     * @param pFounder
     */
    public Group(String pName, User pFounder, int pId) {
        super(pId);
        setName(pName);
        _founder = pFounder;
    }
    


    /**
     * get the founder
     * 
     * @return
     */
    public User getFounder() {
        return _founder;
    }
    


    /**
     * set the founder
     * 
     * @param pFounder
     */
    public void setFounder(User pFounder) {
        _founder = pFounder;
    }
    


    /**
     * get the user
     * 
     * @return
     */
    public List<User> getUser() {
        return _user;
    }
    


    /**
     * add a user
     * 
     * @param pUser
     */
    public void addUser(User pUser) {
        _user.add(pUser);
    }
    


    /**
     * remove a user
     * 
     * @param pUser
     * @return
     */
    public boolean removeUser(User pUser) {
        return _user.remove(pUser);
    }



    /* (non-Javadoc)
     * @see java.lang.Comparable#compareTo(java.lang.Object)
     */
    @Override
    public int compareTo(Address pAdress) {
        if (pAdress instanceof Group){
            return getName().compareTo(pAdress.getName());
        }
        return 1;
    }
    
}
