package de.hwrBerlin.hwrchat.model;

import java.io.Serializable;

/**
 * 
 * @author Nico Smeenk
 * 
 *         Mutterklasse, die sich um alle Mglichkeiten von Adressaten kmmert (User/Gruppe)
 * 
 */
public abstract class Address implements Comparable<Address>,Serializable {
    
    /**
	 * 
	 */
	private static final long serialVersionUID = 2181085103497717982L;

	/** Id des Adressaten */
    private int _id;
    
    /** Name des Adressaten */
    private String _name;
    
    /** Statusmessage */
    private String _statusMessage;
    

    /**
     * Konstruktor fr einen Adressaten
     * 
     * @param pId
     */
    public Address(int pId) {
        _id = pId;
    }
    


    /**
     * get the id
     * 
     * @return id
     */
    public int getId() {
        return _id;
    }
    


    /**
     * set the id
     * 
     * @param pId
     */
    public void setId(int pId) {
        _id = pId;
    }
    


    /**
     * get the name
     * 
     * @return name
     */
    public String getName() {
        return _name;
    }
    


    /**
     * set the name
     * 
     * @param pName
     */
    public void setName(String pName) {
        _name = pName;
    }



    /**
     * 
     * @return
     */
    public String getStatusMessage() {
        return _statusMessage;
    }



    /**
     * 
     * @param pStatusMessage
     */
    public void setStatusMessage(String pStatusMessage) {
        _statusMessage = pStatusMessage;
    }


    /* (non-Javadoc)
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + _id;
        return result;
    }



    /* (non-Javadoc)
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object obj) {
        if (this == obj)
            return true;
        if (obj == null)
            return false;
        if (getClass() != obj.getClass())
            return false;
        Address other = (Address) obj;
        if (_id != other._id)
            return false;
        return true;
    }
    
    

}
