/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view.contactList;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.clientTest.view.ChatView;
import de.hwrBerlin.hwrchat.clientTest.view.ImageColorConstants;
import de.hwrBerlin.hwrchat.model.Address;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.Status;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

/**
 * @author Nico Smeenk
 * 
 *         Anzeige eines einzelnen kontaktes
 * 
 */
public class SingleContactView extends AMessageReceiveAdapter {
    
    /** Controller */
    private Controller _controller;
    /** Speichert die Chattview wenn geffnet */
    private ChatView _chatView = null;
    /** Adresse */
    private Address _address;
    /** Parent */
    private Composite _parent;
    private Text _nameLabel;
    private Label _statusLabel;
    private Composite _contactComposite;
    
    

    /**
     * @param pParent
     * @param pStyle
     * @param pShowStatusBullet
     */
    public SingleContactView(final Composite pParent, int pStyle, final Address pAddress,
            final Controller pController, final ContactListView pList) {
        
        _address = pAddress;
        _controller = pController;
        _controller.addListener(this);
        _parent = pParent;
        
        _contactComposite = new Composite(pParent, pStyle);
        
        _contactComposite.setLayout(new MigLayout("fill", "[min!][]"));
        _contactComposite.setLayoutData("grow, span");
        _contactComposite.setBackground(new Color(pParent.getDisplay(), 255, 255, 255));
        
        // Statusanzeige
        // mit kugeln
        if (_controller.isShowBullet()) {
            
            // Status anzeigen
            _statusLabel = new Label(_contactComposite, SWT.NONE);
            Image statusImage;
            // Wenn user dann den Status der users
            if (_address instanceof User) {
                statusImage = new Image(pParent.getDisplay(),
                        ImageColorConstants.getStatusImage(Status.fromValue(((User) _address)
                                .getStatus())));
                _statusLabel.setToolTipText(((User) _address).getStatus().toString());
            }
            // Wenn gruppe dann Online
            else {
                statusImage = new Image(pParent.getDisplay(),
                        ImageColorConstants.getStatusImage(Status.ONLINE));
                _statusLabel.setToolTipText(Status.ONLINE.toString());
            }
            _statusLabel.setImage(statusImage);
        }
        // mit Farben
        else {
            Color statusColor;
            if (_address instanceof User) {
                statusColor = new Color(pParent.getDisplay(),
                        ImageColorConstants.getStatusRGB(Status.fromValue(((User) _address)
                                .getStatus())));
            }
            // Wenn gruppe dann Online
            else {
                statusColor = new Color(pParent.getDisplay(),
                        ImageColorConstants.getStatusRGB(Status.ONLINE));
            }
            _contactComposite.setBackground(statusColor);
        }
        
        // Name
        _nameLabel = new Text(_contactComposite, SWT.READ_ONLY);
        _nameLabel.setText("  " + _address.getName());
        _nameLabel.setToolTipText(_address.getStatusMessage());
        
        // Nach Klick auf Kontakt View ffnen
        MouseListener mouseListener = new MouseAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.MouseAdapter#mouseUp(org.eclipse.swt.events.MouseEvent)
             */
            @Override
            public void mouseUp(MouseEvent pE) {
                if (_chatView == null || _chatView.isDisposed()) {
                    _chatView = new ChatView(pParent.getDisplay(), _address, _controller);
                }
                else {
                    _chatView.setFocus();
                }
            }
        };
        _contactComposite.addMouseListener(mouseListener);
        _nameLabel.addMouseListener(mouseListener);
        
        final SingleContactView tmpThis = this;
        
        // bei schlien listener entfernen
        _contactComposite.addDisposeListener(new DisposeListener() {
            
            @Override
            public void widgetDisposed(DisposeEvent pE) {
                pController.removeListener(tmpThis);
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyText(de.hwrBerlin.hwrchat.model.messages.TextMessage)
     */
    @Override
    public void notifyText(final TextMessage pMessage) {
        if (_parent.getDisplay().isDisposed()) {
            return;
        }
        _parent.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                if (pMessage.getAddressee() instanceof Group) {
                    if (_address instanceof Group
                            && pMessage.getAddressee().getId() == _address.getId()) {
                        if (_chatView == null || _chatView.isDisposed()) {
                            _chatView = new ChatView(_parent.getDisplay(), _address, _controller);
                        }
                        else {
                            _chatView.setFocus();
                        }
                        _chatView.reciveMessage(pMessage);
                    }
                }
                else if (pMessage.getSender() instanceof User && _address instanceof User
                        && pMessage.getSender().getId() == _address.getId()) {
                    if (_chatView == null || _chatView.isDisposed()) {
                        _chatView = new ChatView(_parent.getDisplay(), _address, _controller);
                    }
                    else {
                        _chatView.setFocus();
                    }
                    _chatView.reciveMessage(pMessage);
                }
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyUserUpdate(de.hwrBerlin.hwrchat.model.messages.UpdatedUserAliveMessage)
     */
    @Override
    public void notifyAddressUpdate(final UpdatedAdressMessage pMessage) {
        if (_parent.getDisplay().isDisposed()) {
            return;
        }
        _parent.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                if (_address.getId() == pMessage.getCurrentAdress().getId()
                        && _address.getClass() == pMessage.getCurrentAdress().getClass()) {
                    setStatusLabel(pMessage.getCurrentAdress());
                    // TODO hier andere saupfate sachen eintragen
                    
                    _contactComposite.redraw();
                    _contactComposite.layout();
                    // Shell shell = new Shell();
                    // shell.setImage(_statusLabel.getImage());
                    // shell.open();
                }
            }
            


            private void setStatusLabel(Address pCurrentClientUser) {
                if (_statusLabel != null && !_statusLabel.isDisposed()) {
                    Image statusImage;
                    // Wenn user dann den Status der users
                    if (_address instanceof User) {
                        if (((User) _address).getKnowingUsers().contains(
                                _controller.getCurrentUser())) {
                            
                            statusImage = new Image(_statusLabel.getDisplay(), ImageColorConstants
                                    .getStatusImage(Status.fromValue(((User) pCurrentClientUser)
                                            .getStatus())));
                            if (((User) pCurrentClientUser).getStatus() != null) {
                                _statusLabel.setToolTipText(((User) pCurrentClientUser).getStatus()
                                        .toString());
                            }
                        }
                        else {
                            statusImage = new Image(_statusLabel.getDisplay(), ImageColorConstants
                                    .getStatusImage(Status.AWAY));
                        }
                    }
                    // Wenn gruppe dann Online
                    else {
                        statusImage = new Image(_statusLabel.getDisplay(), ImageColorConstants
                                .getStatusImage(Status.ONLINE));
                        _statusLabel.setToolTipText(Status.ONLINE.toString());
                    }
                    _statusLabel.setImage(statusImage);
                }
            }
        });
    }
}
