/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view.contactList;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.clientTest.listener.IMessageReceiveListener;
import de.hwrBerlin.hwrchat.clientTest.view.AddContactDialog;
import de.hwrBerlin.hwrchat.clientTest.view.GroupCreationCopmposite;
import de.hwrBerlin.hwrchat.clientTest.view.ImageColorConstants;
import de.hwrBerlin.hwrchat.clientTest.view.TextConstants;
import de.hwrBerlin.hwrchat.model.Address;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

/**
 * @author Nico Smeenk
 * 
 *         Anzeig der Kontaktliste
 */
public class ContactListView extends AMessageReceiveAdapter {
    
    /** Map der Views */
    private Map<Address, SingleContactView> _nameComposites = new HashMap<Address, SingleContactView>();
    /** Anzeigecomposite */
    private Composite _listComposite;
    /** Controller */
    private Controller _controller;
    /** angezeigte User */
    private List<Address> _showAdress = new ArrayList<Address>();
    
    private Composite _parent;
    
    

    /**
     * Konstruktor
     * 
     * @param pParent
     * @param pStyle
     * @param pShowBullets
     * @param pController
     * @param pMessage
     */
    public ContactListView(Composite pParent, int pStyle, Controller pController,
            ConnectionRequestMessage pMessage) {
        
        _parent = pParent;
        
        _controller = pController;
        _controller.addListener(this);
        
        final ScrolledComposite scrolledComposite = new ScrolledComposite(pParent, pStyle);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setLayoutData("grow, push, wmin 200, hmin 100");
        
        _listComposite = new Composite(scrolledComposite, SWT.NONE);
        _listComposite.setLayout(new MigLayout("fillx, wrap 2", "[][min!]"));
        _listComposite.setBackground(new Color(pParent.getDisplay(), 240, 240, 240));
        
        scrolledComposite.setContent(_listComposite);
        
        scrolledComposite.addControlListener(new ControlAdapter() {
            public void controlResized(ControlEvent e) {
                scrolledComposite.setMinSize(_listComposite.computeSize(SWT.DEFAULT, SWT.DEFAULT));
                
            }
        });
        
        _showAdress.addAll(((User) pMessage.getAddressee()).getKnowingGroups());
        _showAdress.addAll(((User) pMessage.getAddressee()).getKnowingUsers());
        redraw();
    }
    


    /**
     * 
     */
    private void redraw() {
        Collections.sort(_showAdress);
        for (Control widget : _listComposite.getChildren()) {
            if (widget instanceof IMessageReceiveListener){
                _controller.removeListener((IMessageReceiveListener) widget);
            }
            widget.dispose();
        }
        
        boolean wasFirstGroup = false;
        initContactLine();
        for (Address address : _showAdress) {
            if (address instanceof Group && !wasFirstGroup) {
                wasFirstGroup = true;
                initGroupLine();
            }
            SingleContactView singelContactView = new SingleContactView(_listComposite, SWT.BORDER,
                    address, _controller, this);
            _nameComposites.put(address, singelContactView);
        }
        
        if (!wasFirstGroup) {
            initGroupLine();
        }
        
        _listComposite.layout();
    }
    


    // public void redraw() {
    //
    // // alles lschen
    // for (Control widget : _listComposite.getChildren()) {
    // widget.dispose();
    // }
    //
    // // neue Elemente erstellen
    // boolean wasFirstGroup = false;
    //
    // initContactLine();
    //
    // }
    
    /**
     * initiiert die Contaktliste
     */
    private void initGroupLine() {
        Label groupLabel = new Label(_listComposite, SWT.NONE);
        groupLabel.setText(TextConstants.TEXT_GROUP_TITLE);
        
        Button groupCreateButton = new Button(_listComposite, SWT.PUSH);
        groupCreateButton.setImage(new Image(_listComposite.getDisplay(),
                ImageColorConstants.IMAGE_CREATE_GROUP));
        groupCreateButton.setToolTipText(TextConstants.TOOL_TIP_CREATE_GROUP);
        
        groupCreateButton.addSelectionListener(new SelectionAdapter() {
            public void widgetSelected(SelectionEvent e) {
                Shell shell = new Shell(_listComposite.getDisplay(), SWT.CLOSE);
                shell.setLayout(new MigLayout("fill"));
                shell.setImage(new Image(_listComposite.getDisplay(),
                        ImageColorConstants.IMAGE_ICON));
                shell.setText(TextConstants.TEXT_CREATE_GROUP);
                
                new GroupCreationCopmposite(shell, SWT.NONE, _controller);
                
                shell.pack();
                shell.open();
            };
            
        });
        
    }
    


    /**
     * initiiert die Contaktliste
     */
    private void initContactLine() {
        Label contactsLabel = new Label(_listComposite, SWT.NONE);
        contactsLabel.setText(TextConstants.TEXT_CONTACTS_TITLE);
        
        Button contactAdd = new Button(_listComposite, SWT.PUSH);
        contactAdd.setImage(new Image(_listComposite.getDisplay(),
                ImageColorConstants.IMAGE_ADD_CONTACT));
        contactAdd.setToolTipText(TextConstants.TOOL_TIP_ADD_CONTACT);
        
        contactAdd.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                new AddContactDialog(_listComposite, _controller);
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyAddressUpdate(de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage)
     */
    @Override
    public void notifyAddressUpdate(final UpdatedAdressMessage pMessage) {
        if (_parent.getDisplay().isDisposed()) {
            return;
        }
        _parent.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                
                if (!_showAdress.contains(pMessage.getCurrentAdress())) {
                    _showAdress.add(pMessage.getCurrentAdress());
                    redraw(); 
                }
            }
        });
    }
}
