/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import java.text.SimpleDateFormat;
import java.util.Date;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

/**
 * @author Nico Smeenk
 * 
 *         Stellt eine Liste der Nachrichten beim Chatten dar
 */
public class MessageList extends Composite {
    
    /** Speichert die Farbe die als hintergrund genutzt wird - TODO eventuell in Constante auslagern */
    private final Color chatBackgroundColor = new Color(getDisplay(), 255, 255, 255);
    
    /** Speichert die Farbe des Textes in dem die User angezeigt werden - TODO eventuell in Constante auslagern */
    private final Color chatUserVoregroundColor = new Color(getDisplay(), 0, 0, 255);
    
    

    /**
     * Erstellt das Messagtcomposite
     * 
     * @param pParent
     * @param pStyle
     */
    public MessageList(Composite pParent, int pStyle) {
        super(pParent, pStyle);
        setLayout(new MigLayout("fillx, wrap 3", "[min!][min!][min]"));
        setBackground(chatBackgroundColor);
    }
    


    /**
     * Zeigt eine neue Message an
     * 
     * @param pName
     * @param pMessage
     */
    public void showMessage(String pName, String pMessage) {
        
        // zeitanzeige
        Label timeLabel = new Label(this, SWT.NONE);
        timeLabel.setText(new SimpleDateFormat("hh:mm").format(new Date()) + "   ");
        timeLabel.setBackground(chatBackgroundColor);
        timeLabel.setForeground(chatUserVoregroundColor);
        timeLabel.setLayoutData("top");
        
        // Darstellung von Name und Datum
        Label nameLabel = new Label(this, SWT.NONE);
        nameLabel.setText(pName + "   ");
        nameLabel.setBackground(chatBackgroundColor);
        nameLabel.setForeground(chatUserVoregroundColor);
        nameLabel.setLayoutData("top");
        
        // Darstellung der Nachricht
        Text messageText = new Text(this, SWT.WRAP | SWT.READ_ONLY);
        messageText.setText(pMessage);
        messageText.setBackground(chatBackgroundColor);
        messageText.setLayoutData("top, wmin 0, growx");
        
        this.redraw();
        this.layout();
    }
}
