/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.exceptionhandling.ExceptionConstants;
import de.hwrBerlin.hwrchat.clientTest.exceptionhandling.ShowableException;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.clientTest.view.contactList.ContactListView;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage;

/**
 * @author Nico Smeenk
 * 
 *         Klasse fr die Verwalung der View
 * 
 */
public class MainView extends AMessageReceiveAdapter {
    
    /** Controller */
    private Controller _controller;
    /** Der Display */
    private Display _display;
    /** Die Hauptshell */
    private Shell _shell;
    /** Log inphase? */
    private LoginView _loginView = null;
    
    

    /**
     * Konstruktor
     */
    public MainView(Controller pController) {
        
        _controller = pController;
        
        // Grafische Oberflche erzeugen
        _display = new Display();
        _shell = new Shell(_display);
        
        _shell.setImage(new Image(_shell.getDisplay(), ImageColorConstants.IMAGE_ICON));
        _shell.setBackground(new Color(_shell.getDisplay(), ImageColorConstants.RGB_MAIN_BACK));
        _shell.setText(TextConstants.TEXT_TITLE);
        _shell.setBackgroundMode(SWT.INHERIT_FORCE);
        _shell.setLayout(new MigLayout("center, wrap 1", "", "[min!][]"));
        
        // Verbindung zur Datenbank herstellen
        try {
            _controller.connectToServer();
            _controller.addListener(this);
            
            // Login bauen
            createHeader();
            _loginView = new LoginView(_shell, SWT.NONE, _controller);
            
            _shell.pack();
            _shell.open();
        }
        catch (ShowableException e) {
            PrintException(e);
            _shell.close();
        }
        
        // View schleife
        while (!_shell.isDisposed()) {
            if (!_display.readAndDispatch()) {
                _display.sleep();
            }
        }
        quitClient();
        _display.dispose();
        System.exit(0);
    }
    


    /**
     * @param shell
     *            Erstellt das Logo im Headerbereich
     */
    private void createHeader() {
        Composite logoComposite = new Composite(_shell, SWT.NONE);
        logoComposite.setLayout(new MigLayout("fill, wrap 1"));
        logoComposite.setLayoutData("grow");
        
        Label logoLabel = new Label(logoComposite, SWT.SHELL_TRIM);
        logoLabel.setImage(new Image(_display, ImageColorConstants.IMAGE_NEGATIV_LOGO));
        logoLabel.setLayoutData("grow");
    }
    


    /**
     * Kmmert sich um alles was bercksichtigt werden muss wenn die View geschlossen wird
     */
    private void quitClient() {
        if (_shell != null && !_shell.isDisposed()) {
            _shell.dispose();
        }
        if (_controller != null) {
            _controller.quitClient();
        }
    }
    


    /**
     * @param pE
     */
    private void PrintException(ShowableException pE) {
        MessageBox messageBox = new MessageBox(_shell, SWT.ICON_ERROR);
        messageBox.setText(pE.getTitle());
        messageBox.setMessage(pE.getMessage());
        messageBox.open();
    }
    


    // ===================================================================================
    // Listenerteil
    // ===================================================================================
    
    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyLogin(de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage)
     */
    @Override
    public void notifyLogin(final ConnectionRequestMessage pMessage) {
        if (_display.isDisposed()) {
            return;
        }
        _display.asyncExec(new Runnable() {
            @Override
            public void run() {
                if (_loginView != null) {
                    if (pMessage.getErrorMessage() != null) {
                        PrintException(new ShowableException(
                                ExceptionConstants.WRONG_LOGIN_DATA_TITLE, pMessage
                                        .getErrorMessage()));
                        _loginView.resetInputs();
                    }
                    else {
                        
                        _loginView = null;
                        
                        // alles lschen
                        for (Control item : _shell.getChildren()) {
                            item.dispose();
                        }
                        
                        // Kontaktliste erstellen
                        createHeader();
                        
                        new ContactListView(_shell, SWT.V_SCROLL | SWT.H_SCROLL | SWT.BORDER,
                                _controller, pMessage);
                        
                        _shell.setSize(_shell.getSize());
                        _shell.layout();
                    }
                }
                
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyGroupAttention(de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage)
     */
    @Override
    public void notifyGroupRequest(final GroupAttendRequestMessage pMessage) {
        if (_display.isDisposed()) {
            return;
        }
        _display.asyncExec(new Runnable() {
            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(_shell, SWT.OK | SWT.CANCEL
                        | SWT.ICON_QUESTION);
                messageBox.setText(TextConstants.TEXT_GROUP_INVENTION);
                messageBox.setMessage(TextConstants.TEXT_GROUP_INVENTION_MESSAGE + "\n"
                        + pMessage.getGroup().getName());
                
                if (messageBox.open() == SWT.OK) {
                    _controller.acceptGroupRequest(pMessage.getGroup());
                }
                
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyFileTransferRequest(de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage)
     */
    @Override
    public void notifyFileTransferRequest(final FileTransferRequestMessage pMessage) {
        if (_display.isDisposed()) {
            return;
        }
        _display.asyncExec(new Runnable() {
            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(_shell, SWT.OK | SWT.CANCEL
                        | SWT.ICON_QUESTION);
                messageBox.setText(TextConstants.TEXT_FILE_TRANSFER_REQUEST);
                messageBox.setMessage(TextConstants.TEXT_FILE_TRANSFER_REQUEST_MESSAGE + "\n"
                        + pMessage.getRequestFile().getName() + "\nVon: " + pMessage.getSender().getName());
                
                if (messageBox.open() == SWT.OK) {
                    _controller.acceptFileTransfer(pMessage.getSender(), pMessage.getRequestFile());
                }
                
            }
        });
    }
    
    /* (non-Javadoc)
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyFriendshipRequest(de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage)
     */
    @Override
    public void notifyFriendshipRequest(final FriendshipRequestMessage pMessage) {
        if (_display.isDisposed()) {
            return;
        }
        _display.asyncExec(new Runnable() {
            @Override
            public void run() {
                MessageBox messageBox = new MessageBox(_shell, SWT.OK | SWT.CANCEL
                        | SWT.ICON_QUESTION);
                messageBox.setText(TextConstants.TEXT_FRIENDSHIP_REQUEST);
                messageBox.setMessage(TextConstants.TEXT_FRIENDSHIP_MESSAGE + "\n"
                        + pMessage.getSender().getName() + ":\n" + pMessage.getRequestMessage());
                
                if (messageBox.open() == SWT.OK) {
                    _controller.acceptFriendRequest(pMessage.getSender());
                }
                
            }
        });
    }
}
