/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Text;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.exceptionhandling.ShowableException;

/**
 * @author Nico Smeenk
 * 
 */
public class LoginView extends Composite {
    
    /** Comtroller */
    private Controller _controller;
    /** Namensfeld */
    private Text _nameText;
    /** Passwortfeld */
    private Text _passwordText;
    
    

    /**
     * @param pParent
     * @param pStyle
     */
    public LoginView(Composite pParent, int pStyle, Controller pController) {
        super(pParent, pStyle);
        
        _controller = pController;
        
        // View bauen
        setLayout(new MigLayout("fill, ins 0, wrap 1"));
        
        Composite inputComposite = new Composite(this, SWT.BORDER);
        inputComposite.setLayoutData("grow");
        inputComposite.setLayout(new MigLayout("fill, wrap 2", "[min!]20[]"));
        inputComposite.setBackground(new Color(getDisplay(), 255, 255, 255));
        
        Text loginTextInstruction = new Text(inputComposite, SWT.READ_ONLY | SWT.WRAP);
        loginTextInstruction.setLayoutData("spanx 2");
        loginTextInstruction.setText(TextConstants.TEXT_LOGIN_INSTRUCTION);
        
        Label spacerLabel = new Label(inputComposite, SWT.NONE);
        spacerLabel.setLayoutData("spanx");
        
        Label nameLabel = new Label(inputComposite, SWT.NONE);
        nameLabel.setText(TextConstants.TEXT_LOGIN_NAME);
        
        _nameText = new Text(inputComposite, SWT.BORDER);
        _nameText.setLayoutData("growx");
        
        Label passwordLabel = new Label(inputComposite, SWT.NONE);
        passwordLabel.setText(TextConstants.TEXT_LOGIN_PASSWORD);
        
        _passwordText = new Text(inputComposite, SWT.BORDER | SWT.PASSWORD);
        _passwordText.setLayoutData("growx");
        
        // =================================================
        // Eventhandling
        // =================================================
        
        KeyAdapter enterKeyListener = new KeyAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.KeyAdapter#keyPressed(org.eclipse.swt.events.KeyEvent)
             */
            @Override
            public void keyPressed(KeyEvent pE) {
                // Bei Enter absenden
                if (pE.keyCode == 13 || pE.keyCode == 16777296) {
                    // Daten an den Controller geben
                    try {
                        _nameText.setEnabled(false);
                        _passwordText.setEnabled(false);
                        
                        _controller.checkLoginData(_nameText.getText(), _passwordText.getText()
                                .hashCode());
                    }
                    catch (ShowableException se) {
                        MessageBox errorBox = new MessageBox(getShell(), SWT.ICON_ERROR);
                        errorBox.setText(se.getTitle());
                        errorBox.setMessage(se.getMessage());
                        errorBox.open();
                        
                        resetInputs();
                    }
                }
            }
            
        };
        
        _nameText.addKeyListener(enterKeyListener);
        _passwordText.addKeyListener(enterKeyListener);
        
        _nameText.setFocus();
    }
    


    /**
     * Setzt die view wieder bereit zur eingabe
     */
    public void resetInputs() {
        _passwordText.setText("");
        _nameText.setEnabled(true);
        _passwordText.setEnabled(true);
        _passwordText.setFocus();
    }
}
