/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.User;

/**
 * @author Nico Smeenk
 * 
 */
public class InviteUserToGroup extends AMessageReceiveAdapter {
    
    /**
     * @param pShell
     * @param pStyle
     * @param pController
     * @param pGroup
     */
    public InviteUserToGroup(Shell pShell, final Controller pController, final Group pGroup) {
        
        pController.addListener(this);
        
        final Shell shell = new Shell(pShell);
        shell.setImage(new Image(pShell.getDisplay(), ImageColorConstants.IMAGE_ICON));
        shell.setText(pGroup.getName());
        
        shell.setLayout(new MigLayout("fill, wrap1"));
        
        final List userList = new List(shell, SWT.BORDER | SWT.MULTI | SWT.V_SCROLL);
        for (User user : pController.getCurrentUser().getKnowingUsers()) {
            if (!pGroup.getUser().contains(user)) {
                userList.add(user.getName());
            }
        }
        userList.setLayoutData("grow, hmin 200, hmax 500, wmin 200");
        
        Button inviteButton = new Button(shell, SWT.PUSH);
        inviteButton.setLayoutData("grow");
        inviteButton.setText("Einladen");
        
        inviteButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                for (int selIndex : userList.getSelectionIndices()) {
                    for (User user : pController.getCurrentUser().getKnowingUsers()) {
                        if (user.getName().equals(userList.getItem(selIndex))) {
                            pController.inviteToGroup(pGroup, user);
                        }
                    }
                    
                }
                shell.close();
            }
        });
        
        shell.pack();
        shell.open();
        
        final InviteUserToGroup tmpThis = this;
        
        shell.addDisposeListener(new DisposeListener() {
            
            @Override
            public void widgetDisposed(DisposeEvent pE) {
                pController.removeListener(tmpThis);
            }
        });
        
    }
    
}
