/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import org.eclipse.swt.graphics.RGB;

import de.hwrBerlin.hwrchat.model.Status;

/**
 * @author Nico Smeenk
 *
 * speichert BilderPfade
 */
public class ImageColorConstants {
    private static final String IMAGE_PATH = "Images/";
    
    public static final String IMAGE_ICON = IMAGE_PATH + "icon.png";
    public static final String IMAGE_NEGATIV_LOGO = IMAGE_PATH + "logo_negativ.gif";
    
    private static final String IMAGE_STATUS_ONLINE = IMAGE_PATH + "online.png";
    private static final String IMAGE_STATUS_OFFLINE = IMAGE_PATH + "offline.png";
    private static final String IMAGE_STATUS_AWAY = IMAGE_PATH + "away.png";
    
    public static final String IMAGE_ADD_CONTACT = IMAGE_PATH + "user_add.png";
    public static final String IMAGE_CREATE_GROUP = IMAGE_PATH + "group_add.png";
    public static final String IMAGE_SEARCH_USER = IMAGE_PATH + "search.png";
    
    private static final RGB RGB_STATUS_AWAY = new RGB(220, 220, 220);
    private static final RGB RGB_STATUS_ONLINE = new RGB(220, 255, 220);
    private static final RGB RGB_STATUS_OFFLINE = new RGB(255, 220, 220);

    public static final RGB RGB_MAIN_BACK = new RGB(217, 36, 37);
    
    /**
     * gibt das zu dem Status passenden Bild zurck
     * 
     * @param pStatus
     * @return
     */
    public static String getStatusImage(Status pStatus) {
        switch (pStatus) {
            case AWAY:
                return IMAGE_STATUS_AWAY;
            case ONLINE:
                return IMAGE_STATUS_ONLINE;
            case OFFLINE:
                return IMAGE_STATUS_OFFLINE;
            default:
                return null;
        }
    }
    


    /**
     * gibt die zu dem Status passende Farbkombination an
     * 
     * @param pStatus
     * @return
     */
    public static RGB getStatusRGB(Status pStatus) {
        switch (pStatus) {
            case AWAY:
                return RGB_STATUS_AWAY;
            case ONLINE:
                return RGB_STATUS_ONLINE;
            case OFFLINE:
                return RGB_STATUS_OFFLINE;
            default:
                return null;
        }
    }
}
