/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;

/**
 * @author Nico Smeenk
 * 
 *         Eingabe des neuen Gruppennamens
 */
public class GroupCreationCopmposite extends Composite {
    
    /**
     * @param pParent
     * @param pStyle
     */
    public GroupCreationCopmposite(final Composite pParent, int pStyle, final Controller pController) {
        super(pParent, pStyle);
        
        setLayout(new MigLayout("fill, wrap 1"));
        
        Label descriptionLabel = new Label(this, SWT.NONE);
        descriptionLabel.setText(TextConstants.TEXT_SET_NAME_FOR_NEW_GRUOP);
        
        new Label(this, SWT.NONE);
        
        final Text newNameText = new Text(this, SWT.BORDER);
        newNameText.setLayoutData("grow");
        
        Button submitButton = new Button(this, SWT.PUSH);
        submitButton.setLayoutData("grow");
        submitButton.setText(TextConstants.TEXT_SEND_GRUOP_CREATION_BUTTON);
        
        newNameText.addKeyListener(new KeyAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.KeyAdapter#keyReleased(org.eclipse.swt.events.KeyEvent)
             */
            @Override
            public void keyReleased(KeyEvent pE) {
                if (pE.keyCode == 13 || pE.keyCode == 16777296) {
                    pController.createGroup(newNameText.getText());
                    pParent.getShell().close();
                }
            }
        });
        
        submitButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                pController.createGroup(newNameText.getText());
                pParent.getShell().close();
            }
        });
    }
    
}
