package de.hwrBerlin.hwrchat.clientTest.view;

import java.io.File;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.model.Address;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

public class ChatView extends AMessageReceiveAdapter {
    
    private Controller _controller;
    
    private Display _display;
    private Shell _shell;
    private Address _address;
    private Text _inputText;
    private List _userList;
    
    private MessageList _messageList;
    
    

    public ChatView(Display pDisplay, Address pAddress, Controller pController) {
        
        _display = pDisplay;
        _address = pAddress;
        _controller = pController;
        
        _controller.addListener(this);
        
        // prfen ob user oder Gruppenansicht
        boolean isOneToOneChat = false;
        if (_address instanceof User) {
            isOneToOneChat = true;
        }
        
        // neue Shell initiren
        _shell = new Shell(pDisplay);
        _shell.setImage(new Image(_display, ImageColorConstants.IMAGE_ICON));
        _shell.setText("Chatt mit " + _address.getName());
        
        if (isOneToOneChat) {
            _shell.setLayout(new MigLayout("fill, wrap 4", "[min!][][min!][min!]"));
        }
        else {
            _shell.setLayout(new MigLayout("fill, wrap 5", "[min!][][min!][min!][min!]"));
        }
        
        // Liste der Nachrichten
        final ScrolledComposite scrollList = new ScrolledComposite(_shell, SWT.V_SCROLL
                | SWT.BORDER);
        scrollList.setLayoutData("spanx 4, grow, pushy, hmin 100, wmin 100");
        
        _messageList = new MessageList(scrollList, SWT.NONE);
        _messageList.setLayoutData("spanx 4, growy, growx, pushy, wmin 100");
        
        scrollList.addControlListener(new ControlAdapter() {
            public void controlResized(ControlEvent e) {
                scrollList.setMinSize(_messageList.computeSize(SWT.DEFAULT, SWT.DEFAULT));
            }
        });
        
        scrollList.setContent(_messageList);
        scrollList.setExpandVertical(true);
        scrollList.setExpandHorizontal(true);
        
        // Wenn Gruppe dann Teilnehmerliste anzeigen
        if (!isOneToOneChat) {
            _userList = new List(_shell, SWT.BORDER | SWT.H_SCROLL | SWT.V_SCROLL);
            _userList.setLayoutData("growy, spany 2, wmin 100");
            
            for (User user : ((Group) _address).getUser()) {
                
                if (user == ((Group) _address).getFounder()) {
                    _userList.add(user.getName(), 0);
                }
                else {
                    _userList.add(user.getName());
                }
            }
        }
        
        _inputText = new Text(_shell, SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        _inputText.setLayoutData("spanx 4, h 70!, growx, wmin 100");
        _inputText.setFocus();
        
        // Buttons
        // schlien
        Button closeButton = new Button(_shell, SWT.PUSH);
        closeButton.setLayoutData("spanx 1");
        closeButton.setText("Schlieen");
        
        // Dateitransfer //TODO machen
        Button filetransferButton = new Button(_shell, SWT.PUSH);
        filetransferButton.setLayoutData("spanx 2, right");
        filetransferButton.setText("Dateitransfer");
        if (_address instanceof Group) {
            filetransferButton.setEnabled(false);
        }
        
        // senden
        Button sendButton = new Button(_shell, SWT.PUSH);
        sendButton.setLayoutData("");
        sendButton.setText("Senden");
        
        // Dateitransfer
        filetransferButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                FileDialog fileLoadDialog = new FileDialog(_shell, SWT.OPEN);
                String fileOpenName = fileLoadDialog.open();
                File file = new File(fileOpenName);
                
                _controller.sendFileRequest((User) _address, file);
            }
        });
        
        // Wenn Gruppe dann mglichkeit zum einladen
        if (!isOneToOneChat) {
            // TODO funktionalitt
            Button inventUser = new Button(_shell, SWT.PUSH);
            inventUser.setText("Einladen");
            inventUser.setLayoutData("growx");
            // inventUser.setEnabled(false);
            
            inventUser.addSelectionListener(new SelectionAdapter() {
                /*
                 * (non-Javadoc)
                 * 
                 * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
                 */
                @Override
                public void widgetSelected(SelectionEvent pE) {
                    new InviteUserToGroup(_shell, _controller, (Group) _address);
                }
            });
        }
        
        // shell ffnen
        _shell.setSize(600, 400);
        _shell.open();
        
        // Events =========================================================================================
        // Senden wenn man Enter drckt
        _inputText.addKeyListener(new KeyAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.KeyAdapter#keyReleased(org.eclipse.swt.events.KeyEvent)
             */
            @Override
            public void keyPressed(KeyEvent pE) {
                if (pE.keyCode == 13 || pE.keyCode == 1677296) {
                    sendMessage();
                }
            }
            


            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.KeyAdapter#keyReleased(org.eclipse.swt.events.KeyEvent)
             */
            @Override
            public void keyReleased(KeyEvent pE) {
                if (_inputText.getText().matches("[\\r\\n]*")) {
                    _inputText.setText("");
                }
            }
        });
        // Senden
        sendButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                sendMessage();
            }
        });
        // Schlien
        closeButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                _shell.close();
            }
        });
        
        final ChatView tmpThis = this;
        
        _shell.addDisposeListener(new DisposeListener() {
            
            @Override
            public void widgetDisposed(DisposeEvent pE) {
                _controller.removeListener(tmpThis);
            }
        });
    }
    


    /**
     * sendet die Eingaben
     */
    private void sendMessage() {
        if (!_inputText.getText().matches("[\\r\\n]*")) {
            _controller.sendTextMessage(_inputText.getText(), _address);
            TextMessage message = new TextMessage();
            message.setSender(_controller.getCurrentUser());
            message.setMessage(_inputText.getText());
            
            reciveMessage(message);
            _inputText.setText("");
        }
    }
    


    /**
     * Prft ob die View noch existiert
     * 
     * @return
     */
    public boolean isDisposed() {
        return _shell.isDisposed();
    }
    


    /**
     * Setzt den Fokus
     */
    public void setFocus() {
        _inputText.setFocus();
    }
    


    /**
     * Nachricht empfangen
     * 
     * @param pMessage
     */
    public void reciveMessage(TextMessage pMessage) {
        _messageList.showMessage(pMessage.getSender().getName(), pMessage.getMessage());
        ((ScrolledComposite) _messageList.getParent()).setMinSize(_messageList.computeSize(
                SWT.DEFAULT, SWT.DEFAULT));
        ((ScrolledComposite) _messageList.getParent()).setOrigin(_messageList.getSize());
        
        _controller.log(_address, pMessage.getMessage(), pMessage.getSender());
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyAddressUpdate(de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage)
     */
    @Override
    public void notifyAddressUpdate(final UpdatedAdressMessage pMessage) {
        if (_display.isDisposed()) {
            return;
        }
        _display.asyncExec(new Runnable() {
            @Override
            public void run() {
                
                if (pMessage.getCurrentAdress() instanceof Group && _address instanceof Group) {
                    _address = pMessage.getCurrentAdress();
                    
                    _userList.removeAll();
                    for (User user : ((Group) _address).getUser()) {
                        
                        if (user == ((Group) _address).getFounder()) {
                            _userList.add(user.getName(), 0);
                        }
                        else {
                            _userList.add(user.getName());
                        }
                    }
                }
            }
        });
    }
}
