/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.view;

import java.util.List;

import net.miginfocom.swt.MigLayout;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import de.hwrBerlin.hwrchat.clientTest.controller.Controller;
import de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage;

/**
 * @author Nico Smeenk
 * 
 */
public class AddContactDialog extends AMessageReceiveAdapter {
    
    private Combo _findCombo;
    private List<User> _userList;
    
    

    /**
     * @param pListComposite
     */
    public AddContactDialog(Composite pListComposite, final Controller pController) {
        
        pController.addListener(this);
        
        final Shell shell = new Shell(pListComposite.getDisplay(), SWT.CLOSE);
        shell.setLayout(new MigLayout("fill, wrap 2", "[][min!]"));
        shell.setImage(new Image(pListComposite.getDisplay(), ImageColorConstants.IMAGE_ICON));
        shell.setText(TextConstants.TEXT_SERCH_USER_TITLE);
        
        final Text serchText = new Text(shell, SWT.BORDER);
        serchText.setLayoutData("wmin 200");
        
        Button serchButton = new Button(shell, SWT.PUSH);
        serchButton.setImage(new Image(pListComposite.getDisplay(),
                ImageColorConstants.IMAGE_SEARCH_USER));
        serchButton.setToolTipText(TextConstants.TOOL_TIP_SEARCH_CONTACT);
        
        _findCombo = new Combo(shell, SWT.BORDER | SWT.READ_ONLY);
        _findCombo.setLayoutData("grow");
        
        final Button addContactButton = new Button(shell, SWT.PUSH);
        addContactButton.setImage(new Image(pListComposite.getDisplay(),
                ImageColorConstants.IMAGE_ADD_CONTACT));
        addContactButton.setToolTipText(TextConstants.TOOL_TIP_ADD_CONTACT);
        addContactButton.setEnabled(false);
        
        Label messageLabel = new Label(shell, SWT.NONE);
        messageLabel.setText("Anfragenachricht:");
        messageLabel.setLayoutData("grow, spanx");
        
        final Text messageText = new Text(shell, SWT.BORDER | SWT.V_SCROLL | SWT.WRAP);
        messageText.setLayoutData("grow, spanx, hmin 200");
        
        _findCombo.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                if (!(_findCombo.getItem(_findCombo.getSelectionIndex())).equals("")) {
                    addContactButton.setEnabled(true);
                }
            }
        });
        
        serchButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                pController.searchUser(serchText.getText());
            }
        });
        
        final AddContactDialog tmp = this;
        addContactButton.addSelectionListener(new SelectionAdapter() {
            /*
             * (non-Javadoc)
             * 
             * @see org.eclipse.swt.events.SelectionAdapter#widgetSelected(org.eclipse.swt.events.SelectionEvent)
             */
            @Override
            public void widgetSelected(SelectionEvent pE) {
                if (_findCombo.getSelectionIndex() != -1) {
                    pController.sendFriendRequest(_userList.get(_findCombo.getSelectionIndex()),
                            messageText.getText());
                    shell.close();
                    pController.removeListener(tmp);
                }
            }
        });
        
        shell.pack();
        shell.open();
        
        final AddContactDialog tmpThis = this;
        
        shell.addDisposeListener(new DisposeListener() {
            
            @Override
            public void widgetDisposed(DisposeEvent pE) {
                pController.removeListener(tmpThis);
            }
        });
    }
    


    /*
     * (non-Javadoc)
     * 
     * @see de.hwrBerlin.hwrchat.clientTest.listener.AMessageReceiveAdapter#notifyUserSerchResult(de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage)
     */
    @Override
    public void notifyUserSerchResult(final FindUserRequestMessage pMessage) {
        if (_findCombo.getDisplay().isDisposed()) {
            return;
        }
        _findCombo.getDisplay().asyncExec(new Runnable() {
            @Override
            public void run() {
                
                _findCombo.removeAll();
                
                _userList = pMessage.getFoundUser();
                
                for (User user : pMessage.getFoundUser()) {
                    _findCombo.add(user.getName());
                }
                
                _findCombo.redraw();
            }
        });
    }
    
}
