/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.listener;

import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;
import de.hwrBerlin.hwrchat.model.messages.UpdatedAdressMessage;

/**
 * @author Nico Smeenk
 * 
 *         Dieses Interface definiert die Vernderungen die im Controller vorgenommen werden knnen. Wird eine der Methoden aufgerufen sollen diese durch den Adapter gehen und dann in der jeweiligen
 *         View enden. Somit muss eine View nurnoch die Teile des Adapters berschreiben, die sie benutzen will.
 */
public interface IMessageReceiveListener {
    
    /**
     * Registriert den Verbindungsaufbau zum Server
     * 
     * @param pMessage
     *            Daten in Nachrichtenform
     */
    void notifyLogin(ConnectionRequestMessage pMessage);
    


    /**
     * Schickt Nachricht
     * 
     * @param pMessage
     */
    void notifyText(TextMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyAddressUpdate(UpdatedAdressMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyStartFileTransfer(FileTransferRequestMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyFileTransferRequest(FileTransferRequestMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyGroupRequest(GroupAttendRequestMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyFriendshipRequest(FriendshipRequestMessage pMessage);
    


    /**
     * @param pMessage
     */
    void notifyUserSerchResult(FindUserRequestMessage pMessage);
    
}
