/**
 * 
 */
package de.hwrBerlin.hwrchat.clientTest.controller;

import java.io.File;
import java.io.IOException;
import java.io.ObjectOutputStream;

import de.hwrBerlin.hwrchat.model.Address;
import de.hwrBerlin.hwrchat.model.Group;
import de.hwrBerlin.hwrchat.model.Status;
import de.hwrBerlin.hwrchat.model.User;
import de.hwrBerlin.hwrchat.model.messages.ChangeStatusMessage;
import de.hwrBerlin.hwrchat.model.messages.ConnectionRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FileTransferRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FindUserRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.FriendshipRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.GroupAttendRequestMessage;
import de.hwrBerlin.hwrchat.model.messages.OpenGroupMessage;
import de.hwrBerlin.hwrchat.model.messages.TextMessage;

/**
 * @author Nico Smeenk
 * 
 *         Kmmert sich um das Senden von verschiedenen Nachrichtenarten
 */
public class SendMessageController {
    
    /** Steam zum rausschreiben von Dateien */
    private ObjectOutputStream _outputSteam;
    
    

    /**
     * Konstruktor
     * 
     * @param pOutputStream
     *            Output der genutzt werden soll
     */
    public SendMessageController(ObjectOutputStream pOutputStream) {
        _outputSteam = pOutputStream;
    }
    


    /**
     * Wird beim Anmelden aufgerufen. Je nach reaktion mssen Befehle an die View weitergegeben werden.
     * 
     * @param pText
     * @param pHashCode
     */
    public void checkLoginData(String pName, int pPasswordHashCode) {
        // Daten an den Server senden
        ConnectionRequestMessage loginMessage = new ConnectionRequestMessage();
        loginMessage.setSender(new User(pName, pPasswordHashCode, -1));
        
        try {
            _outputSteam.writeObject(loginMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pText
     * @param pAddress
     */
    public void sendTextMessage(String pText, Address pSender, Address pAddress) {
        TextMessage textMessage = new TextMessage();
        textMessage.setSender(pSender);
        textMessage.setAddressee(pAddress);
        textMessage.setMessage(pText);
        
        try {
            _outputSteam.writeObject(textMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param reciever
     * @param requestMessage
     *            Wird versended wenn ein User eine Freundschaftsanfrage stellt
     */
    public void sendUserFriendshipRequest(Address pSender, Address pAddress, String pRequestMessage) {
        
        // Daten an den Server senden
        FriendshipRequestMessage message = new FriendshipRequestMessage();
        message.setSender(pSender);
        message.setAddressee(pAddress);
        message.setRequestMessage(pRequestMessage);
        
        try {
            _outputSteam.writeObject(message);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * senden einer Statusnderung
     * 
     * @param pSender
     * @param pAddress
     * @param pStatus
     */
    public void sendChangeStatusMessage(Address pSender, Address pAddress, Status pStatus) {
        ChangeStatusMessage changeStatusMessage = new ChangeStatusMessage();
        changeStatusMessage.setSender(pSender);
        changeStatusMessage.setAddressee(pAddress);
        changeStatusMessage.setStatus(pStatus.toValue());
        
        try {
            _outputSteam.writeObject(changeStatusMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pSender
     * @param pAddress
     * @param pStatus
     */
    public void sendCreateGroupMessage(User pSender, Address pAddress, String pName) {
        OpenGroupMessage openGroupMessage = new OpenGroupMessage();
        openGroupMessage.setGroup(new Group(pName, pSender, -1));
        openGroupMessage.setSender(pSender);
        openGroupMessage.setAddressee(pAddress);
        
        try {
            _outputSteam.writeObject(openGroupMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pSender
     * @param pUser
     * @param pGroup
     */
    public void sendGroupInvite(User pSender, Address pAddress, Group pGroup) {
        GroupAttendRequestMessage groupAttendRequestMessage = new GroupAttendRequestMessage();
        groupAttendRequestMessage.setSender(pSender);
        groupAttendRequestMessage.setAddressee(pAddress);
        groupAttendRequestMessage.setGroup(pGroup);
        
        try {
            _outputSteam.writeObject(groupAttendRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pCurrentUser
     * @param pObject
     * @param pB
     */
    public void sendGroupRequest(User pSender, Address pAddress, Group pGroup, boolean pValidate) {
        GroupAttendRequestMessage groupAttendRequestMessage = new GroupAttendRequestMessage();
        groupAttendRequestMessage.setSender(pSender);
        groupAttendRequestMessage.setAddressee(pAddress);
        groupAttendRequestMessage.setGroup(pGroup);
        groupAttendRequestMessage.setReverseRelation(true);
        groupAttendRequestMessage.setValidated(pValidate);
        
        try {
            _outputSteam.reset();
            _outputSteam.writeObject(groupAttendRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pCurrentUser
     * @param pAddress
     * @param pFile
     */
    public void sendFileTransferRequest(User pSender, Address pAddress, File pFile) {
        FileTransferRequestMessage fileTransferRequestMessage = new FileTransferRequestMessage();
        fileTransferRequestMessage.setSender(pSender);
        fileTransferRequestMessage.setAddressee(pAddress);
        fileTransferRequestMessage.setRequestFile(pFile);
        
        try {
            _outputSteam.writeObject(fileTransferRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pCurrentUser
     * @param pSender
     * @param pRequestFile
     */
    public void sendFileTransferResponse(User pSender, Address pAddress, File pRequestFile,
            boolean pValidate, int pPort) {
        FileTransferRequestMessage fileTransferRequestMessage = new FileTransferRequestMessage();
        fileTransferRequestMessage.setSender(pSender);
        fileTransferRequestMessage.setAddressee(pAddress);
        fileTransferRequestMessage.setRequestFile(pRequestFile);
        fileTransferRequestMessage.setReverseRelation(true);
        fileTransferRequestMessage.setValidated(pValidate);
        fileTransferRequestMessage.setFileTransferPort(pPort);
        
        try {
            _outputSteam.writeObject(fileTransferRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    


    /**
     * @param pCurrentUser
     * @param pSender
     * @param pValidate
     */
    public void sendAnserFriendshipRequest(User pSender, Address pAddress, boolean pValidate) {
        FriendshipRequestMessage friendshipRequestMessage = new FriendshipRequestMessage();
        friendshipRequestMessage.setSender(pSender);
        friendshipRequestMessage.setAddressee(pAddress);
        friendshipRequestMessage.setReverseRelation(true);
        friendshipRequestMessage.setValidated(pValidate);
    
        try {
            _outputSteam.writeObject(friendshipRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
    
    /**
     * @param pCurrentUser
     * @param pSender
     * @param pValidate
     */
    public void sendFriendshipRequest(User pSender, Address pAddress, String pMessage) {
        FriendshipRequestMessage friendshipRequestMessage = new FriendshipRequestMessage();
        friendshipRequestMessage.setSender(pSender);
        friendshipRequestMessage.setAddressee(pAddress);
        friendshipRequestMessage.setRequestMessage(pMessage);
        
        try {
            _outputSteam.writeObject(friendshipRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }



    /**
     * @param pCurrentUser
     * @param pText
     */
    public void sendSearchUser(User pSender, String pName) {
        FindUserRequestMessage findUserRequestMessage = new FindUserRequestMessage();
        findUserRequestMessage.setSearchUserName(pName);
        findUserRequestMessage.setSender(pSender);
        
        try {
            _outputSteam.writeObject(findUserRequestMessage);
        }
        catch (IOException e) {
            // TODO abfangen was hir passieren kann
            e.printStackTrace();
        }
    }
}
